/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyRange;

@NodeChildren(value={@NodeChild(value="begin"), @NodeChild(value="end")})
public abstract class RangeLiteralNode
extends RubyNode {
    private final boolean excludeEnd;
    @Node.Child
    private CallDispatchHeadNode cmpNode;

    public RangeLiteralNode(RubyContext context, SourceSection sourceSection, boolean excludeEnd) {
        super(context, sourceSection);
        this.excludeEnd = excludeEnd;
    }

    @Specialization
    public RubyRange.IntegerFixnumRange intRange(int begin, int end) {
        return new RubyRange.IntegerFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }

    @Specialization(guards={"fitsIntoInteger(begin)", "fitsIntoInteger(end)"})
    public RubyRange.IntegerFixnumRange longFittingIntRange(long begin, long end) {
        return new RubyRange.IntegerFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), (int)begin, (int)end, this.excludeEnd);
    }

    @Specialization(guards={"!fitsIntoInteger(begin) || !fitsIntoInteger(end)"})
    public RubyRange.LongFixnumRange longRange(long begin, long end) {
        return new RubyRange.LongFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }

    @Specialization(guards={"!isIntOrLong(begin) || !isIntOrLong(end)"})
    public Object doRange(VirtualFrame frame, Object begin, Object end) {
        Object cmpResult;
        if (this.cmpNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.cmpNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        try {
            cmpResult = this.cmpNode.call(frame, begin, "<=>", null, end);
        }
        catch (RaiseException e) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("bad value for range", this));
        }
        if (cmpResult == this.nil()) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("bad value for range", this));
        }
        return new RubyRange.ObjectRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }

    protected boolean fitsIntoInteger(long value) {
        return CoreLibrary.fitsIntoInteger(value);
    }

    protected boolean isIntOrLong(Object value) {
        return RubyGuards.isInteger(value) || RubyGuards.isLong(value);
    }
}

