/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.interop.TargetableRubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public abstract class RubyToIndexLabelNode
extends TargetableRubyNode {
    public RubyToIndexLabelNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyString(index)"})
    public Object doRubyString(RubyBasicObject index) {
        return index.toString();
    }

    @Specialization(guards={"isRubySymbol(index)"})
    public Object doRubySymbol(RubyBasicObject index) {
        return SymbolNodes.getString(index);
    }

    @Specialization(guards={"!isRubySymbol(index)"})
    public Object doObject(Object index) {
        return index;
    }
}

