/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

public class WriteReadOnlyGlobalNode
extends RubyNode {
    private final String name;
    @Node.Child
    private RubyNode value;

    public WriteReadOnlyGlobalNode(RubyContext context, SourceSection sourceSection, String name, RubyNode value) {
        super(context, sourceSection);
        this.name = name;
        this.value = value;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.value.executeVoid(frame);
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().nameErrorReadOnly(this.name, this));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeVoid(frame);
        return this.nil();
    }
}

