/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.fixnum;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.CoreLibrary;

@NodeChild(value="value", type=RubyNode.class)
public abstract class FixnumLowerNode
extends RubyNode {
    public FixnumLowerNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @Specialization
    public int lower(int value) {
        return value;
    }

    @Specialization(guards={"canLower(value)"})
    public int lower(long value) {
        return (int)value;
    }

    @Specialization(guards={"!canLower(value)"})
    public long lowerFails(long value) {
        return value;
    }

    @Specialization(guards={"!isInteger(value)", "!isLong(value)"})
    public Object passThrough(Object value) {
        return value;
    }

    protected static boolean canLower(long value) {
        return CoreLibrary.fitsIntoInteger(value);
    }
}

