/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="value")})
public abstract class AppendOneNode
extends RubyNode {
    public AppendOneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract RubyBasicObject executeAppendOne(RubyBasicObject var1, Object var2);

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyBasicObject array, int value) {
        ArrayNodes.setStore(array, new int[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyBasicObject array, long value) {
        ArrayNodes.setStore(array, new long[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyBasicObject array, double value) {
        ArrayNodes.setStore(array, new double[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyBasicObject array, Object value) {
        ArrayNodes.setStore(array, new Object[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public RubyBasicObject appendOneSameType(RubyBasicObject array, int value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public RubyBasicObject appendOneSameType(RubyBasicObject array, long value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public RubyBasicObject appendOneSameType(RubyBasicObject array, double value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public RubyBasicObject appendOneSameType(RubyBasicObject array, Object value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((Object[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    public void appendOneSameTypeGeneric(RubyBasicObject array, ArrayMirror storeMirror, Object value, ConditionProfile extendProfile) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + 1;
        ArrayMirror newStoreMirror = extendProfile.profile(newSize > storeMirror.getLength()) ? storeMirror.copyArrayAndMirror(ArrayUtils.capacity(storeMirror.getLength(), newSize)) : storeMirror;
        newStoreMirror.set(oldSize, value);
        ArrayNodes.setStore(array, newStoreMirror.getArray(), newSize);
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public RubyBasicObject appendOneLongIntoInteger(RubyBasicObject array, long value) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + 1;
        int[] oldStore = (int[])ArrayNodes.getStore(array);
        long[] newStore = ArrayUtils.longCopyOf(oldStore, ArrayUtils.capacity(oldStore.length, newSize));
        newStore[oldSize] = value;
        ArrayNodes.setStore(array, newStore, newSize);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "!isInteger(value)", "!isLong(value)"})
    public RubyBasicObject appendOneGeneralizeInteger(RubyBasicObject array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)), value);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "!isInteger(value)", "!isLong(value)"})
    public RubyBasicObject appendOneGeneralizeLong(RubyBasicObject array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)), value);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "!isDouble(value)"})
    public RubyBasicObject appendOneGeneralizeDouble(RubyBasicObject array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), value);
        return array;
    }

    public void appendOneGeneralizeGeneric(RubyBasicObject array, ArrayMirror storeMirror, Object value) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + 1;
        Object[] newStore = storeMirror.getBoxedCopy(ArrayUtils.capacity(storeMirror.getLength(), newSize));
        newStore[oldSize] = value;
        ArrayNodes.setStore(array, newStore, newSize);
    }
}

