/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

@CoreClass(name="Thread::Backtrace::Location")
public class ThreadBacktraceLocationNodes {
    private static final HiddenKey ACTIVATION_IDENTIFIER = new HiddenKey("activation");
    private static final Property ACTIVATION_PROPERTY;
    private static final DynamicObjectFactory THREAD_BACKTRACE_LOCATION_FACTORY;

    public static RubyBasicObject createRubyThreadBacktraceLocation(RubyClass rubyClass, Activation activation) {
        return new RubyBasicObject(rubyClass, THREAD_BACKTRACE_LOCATION_FACTORY.newInstance(activation));
    }

    protected static Activation getActivation(RubyBasicObject threadBacktraceLocation) {
        assert (threadBacktraceLocation.getDynamicObject().getShape().hasProperty(ACTIVATION_IDENTIFIER));
        return (Activation)ACTIVATION_PROPERTY.get(threadBacktraceLocation.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        ACTIVATION_PROPERTY = Property.create(ACTIVATION_IDENTIFIER, allocator.locationForType(Activation.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), 0);
        Shape shape = RubyBasicObject.EMPTY_SHAPE.addProperty(ACTIVATION_PROPERTY);
        THREAD_BACKTRACE_LOCATION_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends UnaryCoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toS(RubyBasicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationNodes.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.createString(sourceSection.getShortDescription());
            }
            return this.createString(String.format("%s:%d:in `%s'", sourceSection.getSource().getShortName(), sourceSection.getStartLine(), sourceSection.getIdentifier()));
        }
    }

    @CoreMethod(names={"lineno"})
    public static abstract class LinenoNode
    extends UnaryCoreMethodNode {
        public LinenoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int lineno(RubyBasicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationNodes.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            return sourceSection.getStartLine();
        }
    }

    @CoreMethod(names={"absolute_path", "path"})
    public static abstract class AbsolutePathNode
    extends UnaryCoreMethodNode {
        public AbsolutePathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject absolutePath(RubyBasicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationNodes.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.createString(sourceSection.getShortDescription());
            }
            return this.createString(sourceSection.getSource().getPath());
        }
    }
}

