/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.CheckArityNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.BinaryCoreMethodNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.methods.SymbolProcNode;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.SymbolCodeRangeableWrapper;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.object.BasicObjectType;
import org.jruby.util.ByteList;

@CoreClass(name="Symbol")
public abstract class SymbolNodes {
    public static final SymbolType SYMBOL_TYPE = new SymbolType();
    private static final HiddenKey STRING_IDENTIFIER = new HiddenKey("string");
    private static final Property STRING_PROPERTY;
    private static final HiddenKey BYTE_LIST_IDENTIFIER;
    private static final Property BYTE_LIST_PROPERTY;
    private static final HiddenKey HASH_CODE_IDENTIFIER;
    private static final Property HASH_CODE_PROPERTY;
    private static final HiddenKey CODE_RANGE_IDENTIFIER;
    private static final Property CODE_RANGE_PROPERTY;
    private static final HiddenKey CODE_RANGEABLE_WRAPPER_IDENTIFIER;
    private static final Property CODE_RANGEABLE_WRAPPER_PROPERTY;
    public static final DynamicObjectFactory SYMBOL_FACTORY;

    public static String getString(RubyBasicObject symbol) {
        assert (RubyGuards.isRubySymbol(symbol));
        assert (symbol.getDynamicObject().getShape().hasProperty(STRING_IDENTIFIER));
        return (String)STRING_PROPERTY.get(symbol.getDynamicObject(), true);
    }

    public static ByteList getByteList(RubyBasicObject symbol) {
        assert (RubyGuards.isRubySymbol(symbol));
        assert (symbol.getDynamicObject().getShape().hasProperty(BYTE_LIST_IDENTIFIER));
        return (ByteList)BYTE_LIST_PROPERTY.get(symbol.getDynamicObject(), true);
    }

    public static int getHashCode(RubyBasicObject symbol) {
        assert (RubyGuards.isRubySymbol(symbol));
        assert (symbol.getDynamicObject().getShape().hasProperty(HASH_CODE_IDENTIFIER));
        return (Integer)HASH_CODE_PROPERTY.get(symbol.getDynamicObject(), true);
    }

    public static int getCodeRange(RubyBasicObject symbol) {
        assert (RubyGuards.isRubySymbol(symbol));
        assert (symbol.getDynamicObject().getShape().hasProperty(CODE_RANGE_IDENTIFIER));
        return (Integer)CODE_RANGE_PROPERTY.get(symbol.getDynamicObject(), true);
    }

    public static void setCodeRange(RubyBasicObject symbol, int codeRange) {
        assert (RubyGuards.isRubySymbol(symbol));
        assert (symbol.getDynamicObject().getShape().hasProperty(CODE_RANGE_IDENTIFIER));
        try {
            CODE_RANGE_PROPERTY.set(symbol.getDynamicObject(), codeRange, symbol.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException();
        }
    }

    public static SymbolCodeRangeableWrapper getCodeRangeable(RubyBasicObject symbol) {
        assert (RubyGuards.isRubySymbol(symbol));
        assert (symbol.getDynamicObject().getShape().hasProperty(CODE_RANGEABLE_WRAPPER_IDENTIFIER));
        SymbolCodeRangeableWrapper wrapper = (SymbolCodeRangeableWrapper)CODE_RANGEABLE_WRAPPER_PROPERTY.get(symbol.getDynamicObject(), true);
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = new SymbolCodeRangeableWrapper(symbol);
        try {
            CODE_RANGEABLE_WRAPPER_PROPERTY.set(symbol.getDynamicObject(), wrapper, symbol.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException();
        }
        return wrapper;
    }

    static {
        BYTE_LIST_IDENTIFIER = new HiddenKey("byteList");
        HASH_CODE_IDENTIFIER = new HiddenKey("hashCode");
        CODE_RANGE_IDENTIFIER = new HiddenKey("codeRange");
        CODE_RANGEABLE_WRAPPER_IDENTIFIER = new HiddenKey("codeRangeableWrapper");
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        STRING_PROPERTY = Property.create(STRING_IDENTIFIER, allocator.locationForType(String.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
        BYTE_LIST_PROPERTY = Property.create(BYTE_LIST_IDENTIFIER, allocator.locationForType(ByteList.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
        HASH_CODE_PROPERTY = Property.create(HASH_CODE_IDENTIFIER, allocator.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.Final)), 0);
        CODE_RANGE_PROPERTY = Property.create(CODE_RANGE_IDENTIFIER, allocator.locationForType(Integer.TYPE), 0);
        CODE_RANGEABLE_WRAPPER_PROPERTY = Property.create(CODE_RANGEABLE_WRAPPER_IDENTIFIER, allocator.locationForType(SymbolCodeRangeableWrapper.class), 0);
        Shape shape = RubyBasicObject.LAYOUT.createShape(SYMBOL_TYPE).addProperty(STRING_PROPERTY).addProperty(BYTE_LIST_PROPERTY).addProperty(HASH_CODE_PROPERTY).addProperty(CODE_RANGE_PROPERTY).addProperty(CODE_RANGEABLE_WRAPPER_PROPERTY);
        SYMBOL_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toS(RubyBasicObject symbol) {
            return this.createString(SymbolNodes.getByteList(symbol).dup());
        }
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodArrayArgumentsNode {
        public ToProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"cachedSymbol == symbol"})
        public RubyBasicObject toProcCached(RubyBasicObject symbol, @Cached(value="symbol") RubyBasicObject cachedSymbol, @Cached(value="createProc(symbol)") RubyBasicObject cachedProc) {
            return cachedProc;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toProcUncached(RubyBasicObject symbol) {
            return this.createProc(symbol);
        }

        protected RubyBasicObject createProc(RubyBasicObject symbol) {
            SourceSection sourceSection = RubyCallStack.getCallerFrame(this.getContext()).getCallNode().getEncapsulatingSourceSection();
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.NO_ARGUMENTS, SymbolNodes.getString(symbol), true, null, false);
            RubyRootNode rootNode = new RubyRootNode(this.getContext(), sourceSection, new FrameDescriptor(), sharedMethodInfo, SequenceNode.sequence(this.getContext(), sourceSection, new CheckArityNode(this.getContext(), sourceSection, Arity.AT_LEAST_ONE), new SymbolProcNode(this.getContext(), sourceSection, SymbolNodes.getString(symbol))));
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
            return ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcClass(), ProcNodes.Type.PROC, sharedMethodInfo, callTarget, callTarget, callTarget, null, null, symbol.getContext().getCoreLibrary().getNilObject(), null);
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(RubyBasicObject symbol) {
            return SymbolNodes.getHashCode(symbol);
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject encoding(RubyBasicObject symbol) {
            return EncodingNodes.getEncoding(SymbolNodes.getByteList(symbol).getEncoding());
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends BinaryCoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(b)"})
        public boolean equal(RubyBasicObject a, RubyBasicObject b) {
            return a == b;
        }

        @Specialization(guards={"!isRubySymbol(b)"})
        public boolean equal(VirtualFrame frame, RubyBasicObject a, Object b) {
            return false;
        }
    }

    @CoreMethod(names={"all_symbols"}, onSingleton=true)
    public static abstract class AllSymbolsNode
    extends CoreMethodArrayArgumentsNode {
        public AllSymbolsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject allSymbols() {
            return this.createArray(this.getContext().getSymbolTable().allSymbols().toArray());
        }
    }

    public static class SymbolType
    extends BasicObjectType {
    }
}

