/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.runtime.control.RaiseException;

public class RaiseIfFrozenNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private IsFrozenNode isFrozenNode;

    public RaiseIfFrozenNode(RubyNode child) {
        super(child.getContext(), child.getEncapsulatingSourceSection());
        this.child = child;
        this.isFrozenNode = IsFrozenNodeGen.create(child.getContext(), child.getEncapsulatingSourceSection(), null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result = this.child.execute(frame);
        if (this.isFrozenNode.executeIsFrozen(result)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(result).getName(), this));
        }
        return result;
    }
}

