/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.ToSNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public final class InterpolatedStringNode
extends RubyNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    @Node.Child
    private TaintNode taintNode;
    private final ConditionProfile taintProfile = ConditionProfile.createCountingProfile();

    public InterpolatedStringNode(RubyContext context, SourceSection sourceSection, ToSNode[] children) {
        super(context, sourceSection);
        this.children = children;
        this.isTaintedNode = IsTaintedNodeGen.create(context, sourceSection, null);
        this.taintNode = TaintNodeGen.create(context, sourceSection, null);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        Object[] strings = new Object[this.children.length];
        boolean tainted = false;
        for (int n = 0; n < this.children.length; ++n) {
            Object toInterpolate;
            strings[n] = toInterpolate = this.children[n].execute(frame);
            tainted |= this.isTaintedNode.executeIsTainted(toInterpolate);
        }
        RubyBasicObject string = this.concat(strings);
        if (this.taintProfile.profile(tainted)) {
            this.taintNode.executeTaint(string);
        }
        return string;
    }

    @CompilerDirectives.TruffleBoundary
    private RubyBasicObject concat(Object[] strings) {
        RubyString builder = null;
        for (Object string : strings) {
            assert (RubyGuards.isRubyString(string));
            if (builder == null) {
                builder = this.getContext().toJRubyString((RubyBasicObject)string);
                continue;
            }
            try {
                builder.append19(this.getContext().toJRuby(string));
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityErrorIncompatible(builder.getEncoding().getCharsetName(), StringNodes.getByteList((RubyBasicObject)string).getEncoding().getCharsetName(), this));
            }
        }
        return this.getContext().toTruffle(builder);
    }
}

