/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.SingleValueCastNode;
import org.jruby.truffle.nodes.cast.SingleValueCastNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FiberNodesFactory;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyThread;

@CoreClass(name="Fiber")
public abstract class FiberNodes {

    @CoreMethod(names={"yield"}, onSingleton=true, argumentsAsArray=true)
    public static abstract class YieldNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        FiberTransferNode fiberTransferNode;

        public YieldNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fiberTransferNode = FiberNodesFactory.FiberTransferNodeFactory.create(context, sourceSection, new RubyNode[]{null, null, null});
        }

        @Specialization
        public Object yield(VirtualFrame frame, Object[] args) {
            RubyThread currentThread = this.getContext().getThreadManager().getCurrentThread();
            RubyFiber yieldingFiber = currentThread.getFiberManager().getCurrentFiber();
            RubyFiber fiberYieldedTo = yieldingFiber.getLastResumedByFiber();
            if (yieldingFiber.isRootFiber() || fiberYieldedTo == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().yieldFromRootFiberError(this));
            }
            return this.fiberTransferNode.executeTransferControlTo(frame, fiberYieldedTo, true, args);
        }
    }

    @CoreMethod(names={"resume"}, argumentsAsArray=true)
    public static abstract class ResumeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        FiberTransferNode fiberTransferNode;

        public ResumeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fiberTransferNode = FiberNodesFactory.FiberTransferNodeFactory.create(context, sourceSection, new RubyNode[]{null, null, null});
        }

        @Specialization
        public Object resume(VirtualFrame frame, RubyFiber fiberBeingResumed, Object[] args) {
            return this.fiberTransferNode.executeTransferControlTo(frame, fiberBeingResumed, false, args);
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public RubyBasicObject initialize(RubyFiber fiber, RubyBasicObject block) {
            CompilerDirectives.transferToInterpreter();
            fiber.initialize(block);
            return this.nil();
        }
    }

    public static abstract class FiberTransferNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingleValueCastNode singleValueCastNode;

        public FiberTransferNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        protected Object singleValue(VirtualFrame frame, Object[] args) {
            if (this.singleValueCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.singleValueCastNode = this.insert(SingleValueCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.singleValueCastNode.executeSingleValue(frame, args);
        }

        public abstract Object executeTransferControlTo(VirtualFrame var1, RubyFiber var2, boolean var3, Object[] var4);

        @Specialization
        protected Object transfer(VirtualFrame frame, RubyFiber fiber, boolean isYield, Object[] args) {
            CompilerDirectives.transferToInterpreter();
            if (!fiber.isAlive()) {
                throw new RaiseException(this.getContext().getCoreLibrary().deadFiberCalledError(this));
            }
            RubyThread currentThread = this.getContext().getThreadManager().getCurrentThread();
            if (fiber.getRubyThread() != currentThread) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().fiberError("fiber called across threads", this));
            }
            RubyFiber sendingFiber = currentThread.getFiberManager().getCurrentFiber();
            return this.singleValue(frame, sendingFiber.transferControlTo(fiber, isYield, args));
        }
    }
}

