/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyException;

@CoreClass(name="Exception")
public abstract class ExceptionNodes {

    @CoreMethod(names={"message"})
    public static abstract class MessageNode
    extends CoreMethodArrayArgumentsNode {
        public MessageNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object message(RubyException exception) {
            return exception.getMessage();
        }
    }

    @CoreMethod(names={"capture_backtrace!"}, optional=1)
    public static abstract class CaptureBacktraceNode
    extends CoreMethodArrayArgumentsNode {
        public CaptureBacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject captureBacktrace(RubyException exception, NotProvided offset) {
            return this.captureBacktrace(exception, 1);
        }

        @Specialization
        public RubyBasicObject captureBacktrace(RubyException exception, int offset) {
            Backtrace backtrace = RubyCallStack.getBacktrace(this, offset);
            exception.setBacktrace(backtrace);
            return this.nil();
        }
    }

    @CoreMethod(names={"backtrace"})
    public static abstract class BacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ReadHeadObjectFieldNode readCustomBacktrace = new ReadHeadObjectFieldNode("@custom_backtrace");

        public BacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object backtrace(RubyException exception) {
            if (this.readCustomBacktrace.isSet(exception)) {
                return this.readCustomBacktrace.execute(exception);
            }
            if (exception.getBacktrace() != null) {
                return exception.asRubyStringArray();
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject initialize(RubyException exception, NotProvided message) {
            exception.initialize(this.nil());
            return exception;
        }

        @Specialization(guards={"wasProvided(message)"})
        public RubyBasicObject initialize(RubyException exception, Object message) {
            exception.initialize(message);
            return exception;
        }
    }
}

