/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyModule;

@NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
public abstract class LookupConstantNode
extends RubyNode {
    private final LexicalScope lexicalScope;

    public LookupConstantNode(RubyContext context, SourceSection sourceSection, LexicalScope lexicalScope) {
        super(context, sourceSection);
        this.lexicalScope = lexicalScope;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public abstract RubyConstant executeLookupConstant(VirtualFrame var1, Object var2, String var3);

    @Specialization(guards={"module == cachedModule", "guardName(name, cachedName, sameNameProfile)"}, assumptions={"cachedModule.getUnmodifiedAssumption()"}, limit="getCacheLimit()")
    protected RubyConstant lookupConstant(VirtualFrame frame, RubyModule module, String name, @Cached(value="module") RubyModule cachedModule, @Cached(value="name") String cachedName, @Cached(value="doLookup(cachedModule, cachedName)") RubyConstant constant, @Cached(value="isVisible(cachedModule, constant)") boolean isVisible, @Cached(value="createBinaryProfile()") ConditionProfile sameNameProfile) {
        if (!isVisible) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateConstant(module, name, this));
        }
        return constant;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected RubyConstant lookupConstantUncached(RubyModule module, String name) {
        RubyConstant constant = this.doLookup(module, name);
        boolean isVisible = this.isVisible(module, constant);
        if (!isVisible) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateConstant(module, name, this));
        }
        return constant;
    }

    @Specialization(guards={"!isRubyModule(module)"})
    protected RubyConstant lookupNotModule(Object module, String name) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(module.toString(), "class/module", this));
    }

    protected boolean guardName(String name, String cachedName, ConditionProfile sameNameProfile) {
        if (sameNameProfile.profile(name == cachedName)) {
            return true;
        }
        return name.equals(cachedName);
    }

    protected RubyConstant doLookup(RubyModule module, String name) {
        return ModuleOperations.lookupConstant(this.getContext(), this.lexicalScope, module, name);
    }

    protected boolean isVisible(RubyModule module, RubyConstant constant) {
        return constant == null || constant.isVisibleTo(this.getContext(), this.lexicalScope, module);
    }
}

