/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeChild(type=RubyNode.class)
public abstract class ToSNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode callToSNode;
    @Node.Child
    private KernelNodes.ToSNode kernelToSNode;

    public ToSNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.callToSNode = DispatchHeadNodeFactory.createMethodCall(context, true);
    }

    protected RubyBasicObject kernelToS(VirtualFrame frame, Object object) {
        if (this.kernelToSNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.kernelToSNode = this.insert(KernelNodesFactory.ToSNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
        }
        return this.kernelToSNode.executeToS(frame, object);
    }

    @Specialization(guards={"isRubyString(string)"})
    public RubyBasicObject toS(RubyBasicObject string) {
        return string;
    }

    @Specialization(guards={"!isRubyString(object)"}, rewriteOn={UnexpectedResultException.class})
    public RubyBasicObject toS(VirtualFrame frame, Object object) throws UnexpectedResultException {
        Object value = this.callToSNode.call(frame, object, "to_s", null, new Object[0]);
        if (RubyGuards.isRubyString(value)) {
            return (RubyBasicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    @Specialization(guards={"!isRubyString(object)"})
    public RubyBasicObject toSFallback(VirtualFrame frame, Object object) {
        Object value = this.callToSNode.call(frame, object, "to_s", null, new Object[0]);
        if (RubyGuards.isRubyString(value)) {
            return (RubyBasicObject)value;
        }
        return this.kernelToS(frame, object);
    }
}

