/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

@ImportStatic(value={Integer.class})
@NodeChild(value="value", type=RubyNode.class)
public abstract class IntegerCastNode
extends RubyNode {
    public IntegerCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract int executeInteger(VirtualFrame var1, Object var2);

    @Override
    public abstract int executeInteger(VirtualFrame var1);

    @Specialization
    public int doIntegerFixnum(int value) {
        return value;
    }

    @Specialization(guards={"value >= MIN_VALUE", "value <= MAX_VALUE"})
    public int doLongFixnum(long value) {
        return (int)value;
    }

    @Fallback
    public int doBasicObject(Object object) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(object.toString(), "Fixnum (fitting in int)", this));
    }
}

