/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyClass;

public class ReadRestArgumentNode
extends RubyNode {
    private final int startIndex;
    private final int negativeEndIndex;
    private final boolean keywordArguments;
    private final BranchProfile noArgumentsLeftProfile = BranchProfile.create();
    private final BranchProfile subsetOfArgumentsProfile = BranchProfile.create();

    public ReadRestArgumentNode(RubyContext context, SourceSection sourceSection, int startIndex, int negativeEndIndex, boolean keywordArguments) {
        super(context, sourceSection);
        this.startIndex = startIndex;
        this.negativeEndIndex = negativeEndIndex;
        this.keywordArguments = keywordArguments;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object lastArgument;
        RubyClass arrayClass = this.getContext().getCoreLibrary().getArrayClass();
        int count = RubyArguments.getUserArgumentsCount(frame.getArguments());
        int endIndex = count + this.negativeEndIndex;
        if (this.keywordArguments && RubyGuards.isRubyHash(lastArgument = RubyArguments.getUserArgument(frame.getArguments(), RubyArguments.getUserArgumentsCount(frame.getArguments()) - 1))) {
            --endIndex;
        }
        int length = endIndex - this.startIndex;
        if (this.startIndex == 0) {
            Object[] arguments = RubyArguments.extractUserArguments(frame.getArguments());
            return ArrayNodes.createArray(arrayClass, arguments, length);
        }
        if (this.startIndex >= endIndex) {
            this.noArgumentsLeftProfile.enter();
            return ArrayNodes.createEmptyArray(arrayClass);
        }
        this.subsetOfArgumentsProfile.enter();
        Object[] arguments = RubyArguments.extractUserArguments(frame.getArguments());
        return ArrayNodes.createArray(arrayClass, ArrayUtils.extractRange(arguments, this.startIndex, endIndex), length);
    }
}

