/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.interop.messages;

import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.MessageUtil;
import com.oracle.truffle.interop.messages.Receiver;

public final class Write
implements Message {
    private final Object receiver;
    private final Argument id;
    private final Argument value;

    private Write(Object receiver, Argument id, Argument value) {
        this.receiver = receiver;
        this.id = id;
        this.value = value;
    }

    public static Write create(Receiver receiver, Argument id, Argument value) {
        return new Write(receiver, id, value);
    }

    public static Write create(Message receiver, Argument id, Argument value) {
        return new Write(receiver, id, value);
    }

    public Argument getId() {
        return this.id;
    }

    public Object getReceiver() {
        return this.receiver;
    }

    public Argument getValue() {
        return this.value;
    }

    @Override
    public boolean matchStructure(Object message) {
        if (!(message instanceof Write)) {
            return false;
        }
        Write m1 = this;
        Write m2 = (Write)message;
        return MessageUtil.compareMessage(m1.getReceiver(), m2.getReceiver());
    }

    public String toString() {
        return String.format("Write(%s, %s, %s)", this.receiver.toString(), this.id.toString(), this.value.toString());
    }
}

