/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;

public class Purpose {
    private static final String XKU_EMAIL_PROTECT = "1.3.6.1.5.5.7.3.4";
    private static final String XKU_SSL_CLIENT = "1.3.6.1.5.5.7.3.2";
    private static final String[] XKU_SSL_SERVER = new String[]{"1.3.6.1.5.5.7.3.1", "2.16.840.1.113730.4.1", "1.3.6.1.4.1.311.10.3.3"};
    public int purpose;
    public int trust;
    public int flags;
    CheckPurposeFunction checkPurpose;
    public String name;
    public String sname;
    public Object userData;
    private static final List<Purpose> xptable = new ArrayList<Purpose>();
    static final CheckPurposeFunction checkPurposeSSLClient = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            if (Purpose.xkuReject(x, Purpose.XKU_SSL_CLIENT)) {
                return 0;
            }
            if (ca != 0) {
                return Purpose.checkSSLCA(x);
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[0]) {
                return 0;
            }
            if (Purpose.nsReject(x, 128)) {
                return 0;
            }
            return 1;
        }
    };
    static final CheckPurposeFunction checkPurposeSSLServer = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            if (Purpose.xkuReject(x, XKU_SSL_SERVER)) {
                return 0;
            }
            if (ca != 0) {
                return Purpose.checkSSLCA(x);
            }
            if (Purpose.nsReject(x, 64)) {
                return 0;
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[0] && !x.getKeyUsage()[2]) {
                return 0;
            }
            return 1;
        }
    };
    static final CheckPurposeFunction checkPurposeNSSSLServer = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            int ret = checkPurposeSSLServer.call(purpose, x, ca);
            if (ret == 0 || ca != 0) {
                return ret;
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[2]) {
                return 0;
            }
            return 1;
        }
    };
    static final CheckPurposeFunction checkPurposeSMIMESign = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            int ret = Purpose.purposeSMIME(x, ca);
            if (ret == 0 || ca != 0) {
                return ret;
            }
            if (!(x.getKeyUsage() == null || x.getKeyUsage()[0] && x.getKeyUsage()[1])) {
                return 0;
            }
            return ret;
        }
    };
    static final CheckPurposeFunction checkPurposeSMIMEEncrypt = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            int ret = Purpose.purposeSMIME(x, ca);
            if (ret == 0 || ca != 0) {
                return ret;
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[2]) {
                return 0;
            }
            return ret;
        }
    };
    static final CheckPurposeFunction checkPurposeCRLSign = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            if (ca != 0) {
                int ca_ret = Purpose.checkCA(x);
                if (ca_ret != 2) {
                    return ca_ret;
                }
                return 0;
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[6]) {
                return 0;
            }
            return 1;
        }
    };
    static final CheckPurposeFunction noCheck = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            return 1;
        }
    };
    static final CheckPurposeFunction oscpHelper = new CheckPurposeFunction(){

        @Override
        public int call(Purpose purpose, X509AuxCertificate x, Integer ca) throws CertificateException {
            if (ca != 0) {
                return Purpose.checkCA(x);
            }
            return 1;
        }
    };
    private static final Purpose[] xstandard = new Purpose[]{new Purpose(1, 2, 0, checkPurposeSSLClient, "SSL client", "sslclient", null), new Purpose(2, 3, 0, checkPurposeSSLServer, "SSL server", "sslserver", null), new Purpose(3, 3, 0, checkPurposeNSSSLServer, "Netscape SSL server", "nssslserver", null), new Purpose(4, 4, 0, checkPurposeSMIMESign, "S/MIME signing", "smimesign", null), new Purpose(5, 4, 0, checkPurposeSMIMEEncrypt, "S/MIME encryption", "smimeencrypt", null), new Purpose(6, 1, 0, checkPurposeCRLSign, "CRL signing", "crlsign", null), new Purpose(7, -1, 0, noCheck, "Any Purpose", "any", null), new Purpose(8, 1, 0, oscpHelper, "OCSP helper", "ocsphelper", null)};

    private Purpose() {
    }

    Purpose(int p, int t, int f, CheckPurposeFunction cp, String n, String s2, Object u) {
        this.purpose = p;
        this.trust = t;
        this.flags = f;
        this.checkPurpose = cp;
        this.name = n;
        this.sname = s2;
        this.userData = u;
    }

    public static int checkPurpose(X509AuxCertificate x, int id, int ca) throws CertificateException {
        if (id == -1) {
            return 1;
        }
        int idx = Purpose.getByID(id);
        if (idx == -1) {
            return -1;
        }
        Purpose pt = Purpose.getFirst(idx);
        return pt.checkPurpose.call(pt, x, ca);
    }

    public static int set(int[] p, int purpose) {
        if (Purpose.getByID(purpose) == -1) {
            X509Error.addError(146);
            return 0;
        }
        p[0] = purpose;
        return 1;
    }

    public static int getCount() {
        return xptable.size() + xstandard.length;
    }

    public static Purpose getFirst(int idx) {
        if (idx < 0) {
            return null;
        }
        if (idx < xstandard.length) {
            return xstandard[idx];
        }
        return xptable.get(idx - xstandard.length);
    }

    public static int getBySName(String sname) {
        for (int i2 = 0; i2 < Purpose.getCount(); ++i2) {
            Purpose xptmp = Purpose.getFirst(i2);
            if (!xptmp.sname.equals(sname)) continue;
            return i2;
        }
        return -1;
    }

    public static int getByID(int purpose) {
        if (purpose >= 1 && purpose <= 8) {
            return purpose - 1;
        }
        int i2 = 0;
        for (Purpose p : xptable) {
            if (p.purpose != purpose) continue;
            return i2 + xstandard.length;
        }
        return -1;
    }

    public static int add(int id, int trust, int flags, CheckPurposeFunction ck, String name2, String sname, Object arg) {
        Purpose ptmp;
        flags &= 0xFFFFFFFE;
        flags |= 2;
        int idx = Purpose.getByID(id);
        if (idx == -1) {
            ptmp = new Purpose();
            ptmp.flags = 1;
        } else {
            ptmp = Purpose.getFirst(idx);
        }
        ptmp.name = name2;
        ptmp.sname = sname;
        ptmp.flags &= 1;
        ptmp.flags |= flags;
        ptmp.purpose = id;
        ptmp.trust = trust;
        ptmp.checkPurpose = ck;
        ptmp.userData = arg;
        if (idx == -1) {
            xptable.add(ptmp);
        }
        return 1;
    }

    public static void cleanup() {
        xptable.clear();
    }

    public int getID() {
        return this.purpose;
    }

    public String getName() {
        return this.name;
    }

    public String getSName() {
        return this.sname;
    }

    public int getTrust() {
        return this.trust;
    }

    public static int checkCA(X509AuxCertificate x) throws CertificateException {
        if (x.getKeyUsage() != null && !x.getKeyUsage()[5]) {
            return 0;
        }
        if (x.getExtensionValue("2.5.29.19") != null) {
            if (x.getBasicConstraints() != -1) {
                return 1;
            }
            return 0;
        }
        if (x.getVersion() == 1 && x.getIssuerX500Principal().equals(x.getSubjectX500Principal())) {
            return 3;
        }
        if (x.getKeyUsage() != null) {
            return 4;
        }
        Integer nsCertType = x.getNsCertType();
        if (nsCertType != null && (nsCertType & 7) != 0) {
            return 5;
        }
        return 0;
    }

    public static int checkSSLCA(X509AuxCertificate x) throws CertificateException {
        boolean v2;
        int ca_ret = Purpose.checkCA(x);
        if (ca_ret == 0) {
            return 0;
        }
        Integer nsCertType = x.getNsCertType();
        boolean bl = v2 = nsCertType != null && (nsCertType & 4) != 0;
        if (ca_ret != 5 || v2) {
            return ca_ret;
        }
        return 0;
    }

    public static boolean xkuReject(X509AuxCertificate x, String mustHaveXku) throws CertificateException {
        List<String> xku = x.getExtendedKeyUsage();
        return xku != null && !xku.contains(mustHaveXku);
    }

    public static boolean xkuReject(X509AuxCertificate x, String[] mustHaveOneOfXku) throws CertificateException {
        List<String> xku = x.getExtendedKeyUsage();
        if (xku == null) {
            return false;
        }
        for (String mustHaveXku : mustHaveOneOfXku) {
            if (!xku.contains(mustHaveXku)) continue;
            return false;
        }
        return true;
    }

    public static boolean nsReject(X509AuxCertificate x, int mustHaveCertType) throws CertificateException {
        Integer nsCertType = x.getNsCertType();
        return nsCertType != null && (nsCertType & mustHaveCertType) == 0;
    }

    public static int purposeSMIME(X509AuxCertificate x, int ca) throws CertificateException {
        if (Purpose.xkuReject(x, XKU_EMAIL_PROTECT)) {
            return 0;
        }
        if (ca != 0) {
            boolean v2;
            int ca_ret = Purpose.checkCA(x);
            if (ca_ret == 0) {
                return 0;
            }
            Integer nsCertType = x.getNsCertType();
            boolean bl = v2 = nsCertType != null && (nsCertType & 2) != 0;
            if (ca_ret != 5 || v2) {
                return ca_ret;
            }
            return 0;
        }
        Integer nsCertType = x.getNsCertType();
        if (nsCertType != null) {
            if ((nsCertType & 0x20) != 0) {
                return 1;
            }
            if ((nsCertType & 0x80) != 0) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    static interface CheckPurposeFunction
    extends Function3<Purpose, X509AuxCertificate, Integer> {
        @Override
        public int call(Purpose var1, X509AuxCertificate var2, Integer var3) throws CertificateException;
    }
}

