/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSequence;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Attribute
extends RubyObject {
    private static final long serialVersionUID = 5569940260019783275L;
    private static ObjectAllocator ATTRIBUTE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Attribute(runtime, klass);
        }
    };
    private IRubyObject oid;
    private IRubyObject value;
    private transient ASN1ObjectIdentifier objectId;

    public static void createAttribute(Ruby runtime, RubyModule _X509) {
        RubyClass _Attribute = _X509.defineClassUnder("Attribute", runtime.getObject(), ATTRIBUTE_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("AttributeError", openSSLError, openSSLError.getAllocator());
        _Attribute.defineAnnotatedMethods(X509Attribute.class);
    }

    static RubyClass _Attribute(Ruby runtime) {
        RubyModule _X509 = (RubyModule)runtime.getModule("OpenSSL").getConstant("X509");
        return _X509.getClass("Attribute");
    }

    public X509Attribute(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    static X509Attribute newAttribute(Ruby runtime, ASN1ObjectIdentifier type, ASN1Set values) throws IOException {
        X509Attribute attribute = new X509Attribute(runtime, X509Attribute._Attribute(runtime));
        attribute.objectId = type;
        ThreadContext context = runtime.getCurrentContext();
        attribute.value = ASN1.decodeObject(context, ASN1._ASN1(runtime), (ASN1Encodable)values);
        return attribute;
    }

    private ASN1ObjectIdentifier getTypeID() {
        if (this.objectId != null) {
            return this.objectId;
        }
        this.objectId = ASN1.getObjectID(this.getRuntime(), this.oid.toString());
        return this.objectId;
    }

    ASN1Primitive toASN1(ThreadContext context) {
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add((ASN1Encodable)this.getTypeID());
        if (this.value instanceof ASN1.Constructive) {
            v1.add(((ASN1.Constructive)this.value).toASN1(context));
        } else {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(((ASN1.ASN1Data)this.value).toASN1(context));
            v1.add((ASN1Encodable)new DERSet(v2));
        }
        return new DLSequence(v1);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args) {
        if (Arity.checkArgumentCount((Ruby)context.runtime, (IRubyObject[])args, (int)1, (int)2) == 1) {
            this.set_oid(OpenSSL.to_der_if_possible(context, args[0]));
            return this;
        }
        this.set_oid(args[0]);
        this.set_value(context, args[1]);
        return this;
    }

    @JRubyMethod
    public IRubyObject to_der(ThreadContext context) {
        byte[] bytes;
        try {
            bytes = this.toASN1(context).getEncoded("DER");
        }
        catch (IOException e) {
            throw Utils.newIOError(context.runtime, e);
        }
        return StringHelper.newString(context.runtime, bytes);
    }

    @JRubyMethod
    public IRubyObject oid() {
        if (this.oid == null) {
            Ruby runtime = this.getRuntime();
            this.oid = runtime.newString(ASN1.oid2Sym(runtime, this.objectId));
        }
        return this.oid;
    }

    @JRubyMethod(name={"oid="})
    public IRubyObject set_oid(IRubyObject oid2) {
        this.objectId = null;
        this.oid = oid2;
        return this.oid;
    }

    @JRubyMethod
    public IRubyObject value() {
        return this.value;
    }

    @JRubyMethod(name={"value="})
    public IRubyObject set_value(ThreadContext context, IRubyObject value2) {
        try {
            this.value = ASN1.decodeImpl(context, value2);
            return this.value;
        }
        catch (IOException e) {
            throw Utils.newIOError(context.runtime, e);
        }
        catch (IllegalArgumentException e) {
            throw Utils.newArgumentError(context.runtime, e);
        }
    }
}

