/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;

abstract class ObjectSupport {
    ObjectSupport() {
    }

    static RubyString inspect(RubyBasicObject self) {
        return ObjectSupport.inspect(self, self.getInstanceVariableList());
    }

    static RubyString inspect(RubyBasicObject self, List<Variable> variableList) {
        Ruby runtime = self.getRuntime();
        return RubyString.newString((Ruby)runtime, (CharSequence)ObjectSupport.inspect(runtime, self, variableList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder inspect(Ruby runtime, RubyBasicObject self, List<Variable> variableList) {
        StringBuilder part = new StringBuilder();
        String cname = self.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":0x");
        part.append(Integer.toHexString(System.identityHashCode(self)));
        if (runtime.isInspecting((Object)self)) {
            part.append(" ...>");
            return part;
        }
        try {
            runtime.registerInspecting((Object)self);
            ThreadContext context = runtime.getCurrentContext();
            StringBuilder stringBuilder = ObjectSupport.inspectObj(context, variableList, part);
            return stringBuilder;
        }
        finally {
            runtime.unregisterInspecting((Object)self);
        }
    }

    private static StringBuilder inspectObj(ThreadContext context, List<Variable> variableList, StringBuilder part) {
        String sep = "";
        for (Variable ivar : variableList) {
            part.append(sep).append(' ').append(ivar.getName()).append('=');
            Object ival = ivar.getValue();
            if (ival instanceof IRubyObject) {
                part.append(((IRubyObject)ival).callMethod(context, "inspect"));
            } else {
                part.append(ival);
            }
            sep = ",";
        }
        part.append('>');
        return part;
    }
}

