/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.building;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.building.Problem;
import org.apache.maven.building.ProblemCollector;
import org.apache.maven.building.ProblemCollectorFactory;
import org.apache.maven.building.Source;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingResult;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingException;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.apache.maven.toolchain.io.ToolchainsParseException;
import org.apache.maven.toolchain.io.ToolchainsReader;
import org.apache.maven.toolchain.merge.MavenToolchainMerger;
import org.apache.maven.toolchain.model.PersistedToolchains;

@Named
@Singleton
public class DefaultToolchainsBuilder
implements ToolchainsBuilder {
    private MavenToolchainMerger toolchainsMerger = new MavenToolchainMerger();
    @Inject
    private ToolchainsReader toolchainsReader;

    @Override
    public ToolchainsBuildingResult build(ToolchainsBuildingRequest request) throws ToolchainsBuildingException {
        ProblemCollector problems = ProblemCollectorFactory.newInstance(null);
        PersistedToolchains globalToolchains = this.readToolchains(request.getGlobalToolchainsSource(), request, problems);
        PersistedToolchains userToolchains = this.readToolchains(request.getUserToolchainsSource(), request, problems);
        this.toolchainsMerger.merge(userToolchains, globalToolchains, "global-level");
        problems.setSource("");
        if (this.hasErrors(problems.getProblems())) {
            throw new ToolchainsBuildingException(problems.getProblems());
        }
        return new DefaultToolchainsBuildingResult(userToolchains, problems.getProblems());
    }

    private PersistedToolchains readToolchains(Source toolchainsSource, ToolchainsBuildingRequest request, ProblemCollector problems) {
        PersistedToolchains toolchains;
        if (toolchainsSource == null) {
            return new PersistedToolchains();
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.toolchains.io.isStrict", Boolean.TRUE);
            try {
                toolchains = this.toolchainsReader.read(toolchainsSource.getInputStream(), options);
            }
            catch (ToolchainsParseException e) {
                options = Collections.singletonMap("org.apache.maven.toolchains.io.isStrict", Boolean.FALSE);
                toolchains = this.toolchainsReader.read(toolchainsSource.getInputStream(), options);
                problems.add(Problem.Severity.WARNING, e.getMessage(), e.getLineNumber(), e.getColumnNumber(), (Exception)e);
            }
        }
        catch (ToolchainsParseException e) {
            problems.add(Problem.Severity.FATAL, "Non-parseable toolchains " + toolchainsSource.getLocation() + ": " + e.getMessage(), e.getLineNumber(), e.getColumnNumber(), (Exception)e);
            return new PersistedToolchains();
        }
        catch (IOException e) {
            problems.add(Problem.Severity.FATAL, "Non-readable toolchains " + toolchainsSource.getLocation() + ": " + e.getMessage(), -1, -1, (Exception)e);
            return new PersistedToolchains();
        }
        return toolchains;
    }

    private boolean hasErrors(List<Problem> problems) {
        if (problems != null) {
            for (Problem problem : problems) {
                if (Problem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

