/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.invoke.MethodHandle;
import org.jruby.EvalType;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRBlockBody
extends IRBlockBody {
    protected final MethodHandle handle;
    protected boolean pushScope;
    protected boolean reuseParentScope;
    protected boolean usesKwargs;

    public CompiledIRBlockBody(MethodHandle handle, IRScope closure, long encodedSignature) {
        super(closure, Signature.decode(encodedSignature));
        this.handle = handle;
        this.reuseParentScope = closure.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
        this.pushScope = !closure.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED) && !this.reuseParentScope;
        this.usesKwargs = closure.receivesKeywordArgs();
        closure.getStaticScope().determineModule();
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2, Block block) {
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame prevFrame = context.preYieldNoScope(binding2);
        if (self2 == null || this.evalType.get() == EvalType.BINDING_EVAL) {
            self2 = this.useBindingSelf(binding2);
        }
        DynamicScope prevScope = binding2.getDynamicScope();
        if (this.pushScope) {
            context.pushScope(DynamicScope.newDynamicScope(this.getStaticScope(), prevScope, (EvalType)((Object)this.evalType.get())));
        } else if (this.reuseParentScope) {
            context.pushScope(prevScope);
        }
        this.evalType.set(EvalType.NONE);
        if (this.usesKwargs) {
            IRRuntimeHelpers.frobnicateKwargsArgument(context, this.getSignature().required(), args2);
        }
        try {
            IRubyObject iRubyObject = this.handle.invokeExact(context, this.getStaticScope(), self2, args2, block, binding2.getMethod(), type2);
            return iRubyObject;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            binding2.getFrame().setVisibility(oldVis);
            if (this.pushScope || this.reuseParentScope) {
                context.postYield(binding2, prevFrame);
            } else {
                context.postYieldNoScope(prevFrame);
            }
        }
    }
}

