/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.dispatch;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.collections.IntHashMap;

public class CallableSelector {
    private static final CallableAcceptor Exact = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.exactMatch(types, args2);
        }
    };
    private static final CallableAcceptor AssignableAndPrimitivable = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.assignableAndPrimitivable(types, args2);
        }
    };
    private static final CallableAcceptor AssignableOrDuckable = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.assignableOrDuckable(types, args2);
        }
    };
    private static final CallableAcceptor AssignableAndPrimitivableWithVarargs = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.assignableAndPrimitivableWithVarargs(types, args2);
        }
    };
    private static final Matcher EXACT = new Matcher(){

        @Override
        public boolean match(Class<?> type2, IRubyObject arg2) {
            Class argClass = CallableSelector.getJavaClass(arg2);
            return type2 == argClass || type2.isPrimitive() && CodegenUtils.getBoxType(type2) == argClass;
        }

        public String toString() {
            return "EXACT";
        }
    };
    private static final Matcher ASSIGNABLE = new Matcher(){

        public boolean match(Class type2, IRubyObject arg2) {
            return CallableSelector.assignable(type2, arg2);
        }

        public String toString() {
            return "ASSIGNABLE";
        }
    };
    private static final Matcher PRIMITIVABLE = new Matcher(){

        public boolean match(Class type2, IRubyObject arg2) {
            return CallableSelector.primitivable(type2, arg2);
        }

        public String toString() {
            return "PRIMITIVABLE";
        }
    };
    private static final Matcher DUCKABLE = new Matcher(){

        public boolean match(Class type2, IRubyObject arg2) {
            return CallableSelector.duckable(type2, arg2);
        }

        public String toString() {
            return "DUCKABLE";
        }
    };
    private static final Matcher[] NON_EXACT_MATCH_SEQUENCE = new Matcher[]{PRIMITIVABLE, ASSIGNABLE, DUCKABLE};

    private CallableSelector() {
    }

    public static ParameterTypes matchingCallableArityN(Ruby runtime, Map cache, ParameterTypes[] methods2, IRubyObject[] args2) {
        int signatureCode = CallableSelector.argsHashCode(args2);
        ParameterTypes method = (ParameterTypes)cache.get(signatureCode);
        if (method == null && (method = CallableSelector.findMatchingCallableForArgs((Ruby)runtime, (ParameterTypes[])methods2, (IRubyObject[])args2)) != null) {
            cache.put(signatureCode, method);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityN(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject[] args2) {
        int signatureCode = CallableSelector.argsHashCode(args2);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null && (method = (JavaCallable)CallableSelector.findMatchingCallableForArgs((Ruby)runtime, (ParameterTypes[])methods2, (IRubyObject[])args2)) != null) {
            cache.put(signatureCode, method);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityOne(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0) {
        int signatureCode = CallableSelector.argsHashCode(arg0);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null && (method = (JavaCallable)CallableSelector.findMatchingCallableForArgs((Ruby)runtime, (ParameterTypes[])methods2, (IRubyObject[])new IRubyObject[]{arg0})) != null) {
            cache.put(signatureCode, method);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityTwo(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null && (method = (JavaCallable)CallableSelector.findMatchingCallableForArgs((Ruby)runtime, (ParameterTypes[])methods2, (IRubyObject[])new IRubyObject[]{arg0, arg1})) != null) {
            cache.put(signatureCode, method);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityThree(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1, arg2);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null && (method = (JavaCallable)CallableSelector.findMatchingCallableForArgs((Ruby)runtime, (ParameterTypes[])methods2, (IRubyObject[])new IRubyObject[]{arg0, arg1, arg2})) != null) {
            cache.put(signatureCode, method);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityFour(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1, arg2, arg3);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null && (method = (JavaCallable)CallableSelector.findMatchingCallableForArgs((Ruby)runtime, (ParameterTypes[])methods2, (IRubyObject[])new IRubyObject[]{arg0, arg1, arg2, arg3})) != null) {
            cache.put(signatureCode, method);
        }
        return method;
    }

    public static <T extends ParameterTypes> T matchingCallableArityN(Ruby runtime, IntHashMap<T> cache, T[] methods2, IRubyObject[] args2) {
        int signatureCode = CallableSelector.argsHashCode(args2);
        ParameterTypes method = (ParameterTypes)cache.get(signatureCode);
        if (method == null && (method = CallableSelector.findMatchingCallableForArgs((Ruby)runtime, methods2, (IRubyObject[])args2)) != null) {
            cache.put(signatureCode, method);
        }
        return (T)method;
    }

    public static <T extends ParameterTypes> T matchingCallableArityOne(Ruby runtime, IntHashMap<T> cache, T[] methods2, IRubyObject arg0) {
        int signatureCode = CallableSelector.argsHashCode(arg0);
        ParameterTypes method = (ParameterTypes)cache.get(signatureCode);
        if (method == null && (method = CallableSelector.findMatchingCallableForArgs((Ruby)runtime, methods2, (IRubyObject[])new IRubyObject[]{arg0})) != null) {
            cache.put(signatureCode, method);
        }
        return (T)method;
    }

    public static <T extends ParameterTypes> T matchingCallableArityTwo(Ruby runtime, IntHashMap<T> cache, T[] methods2, IRubyObject arg0, IRubyObject arg1) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1);
        ParameterTypes method = (ParameterTypes)cache.get(signatureCode);
        if (method == null && (method = CallableSelector.findMatchingCallableForArgs((Ruby)runtime, methods2, (IRubyObject[])new IRubyObject[]{arg0, arg1})) != null) {
            cache.put(signatureCode, method);
        }
        return (T)method;
    }

    public static <T extends ParameterTypes> T matchingCallableArityThree(Ruby runtime, IntHashMap<T> cache, T[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1, arg2);
        ParameterTypes method = (ParameterTypes)cache.get(signatureCode);
        if (method == null && (method = CallableSelector.findMatchingCallableForArgs((Ruby)runtime, methods2, (IRubyObject[])new IRubyObject[]{arg0, arg1, arg2})) != null) {
            cache.put(signatureCode, method);
        }
        return (T)method;
    }

    public static <T extends ParameterTypes> T matchingCallableArityFour(Ruby runtime, IntHashMap<T> cache, T[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1, arg2, arg3);
        ParameterTypes method = (ParameterTypes)cache.get(signatureCode);
        if (method == null && (method = CallableSelector.findMatchingCallableForArgs((Ruby)runtime, methods2, (IRubyObject[])new IRubyObject[]{arg0, arg1, arg2, arg3})) != null) {
            cache.put(signatureCode, method);
        }
        return (T)method;
    }

    private static <T extends ParameterTypes> T findMatchingCallableForArgs(Ruby runtime, T[] methods2, IRubyObject ... args2) {
        ParameterTypes method = null;
        List candidates = CallableSelector.findCallableCandidates(methods2, (IRubyObject[])args2);
        int size2 = candidates.size();
        if (size2 > 0) {
            if (size2 == 1) {
                method = (ParameterTypes)candidates.get(0);
            } else {
                ParameterTypes mostSpecific = (ParameterTypes)candidates.get(0);
                Class[] msTypes = mostSpecific.getParameterTypes();
                boolean ambiguous = false;
                block0: for (int c = 1; c < size2; ++c) {
                    Class<?> cType;
                    Class msType;
                    int i2;
                    ParameterTypes candidate = (ParameterTypes)candidates.get(c);
                    Class<?>[] cTypes = candidate.getParameterTypes();
                    for (i2 = 0; i2 < msTypes.length; ++i2) {
                        msType = msTypes[i2];
                        cType = cTypes[i2];
                        if (msType == cType || !msType.isAssignableFrom(cType)) continue;
                        mostSpecific = candidate;
                        msTypes = cTypes;
                        ambiguous = false;
                        continue block0;
                    }
                    for (i2 = 0; i2 < msTypes.length; ++i2) {
                        msType = msTypes[i2];
                        cType = cTypes[i2];
                        if (msType == cType || msType.isAssignableFrom(cType) || cType.isAssignableFrom(msType)) {
                            ambiguous = false;
                            continue block0;
                        }
                        if (cType.isPrimitive() && msType.isAssignableFrom(CodegenUtils.getBoxType(cType))) {
                            ambiguous = false;
                            continue block0;
                        }
                        ambiguous = true;
                    }
                    if (!ambiguous) continue;
                    IRubyObject lastArg = args2.length > 0 ? args2[args2.length - 1] : null;
                    T procToIfaceMatch = CallableSelector.matchProcToInterfaceCandidate(lastArg, candidates);
                    if (procToIfaceMatch != null) {
                        mostSpecific = procToIfaceMatch;
                        ambiguous = false;
                        continue;
                    }
                    int msPref = 0;
                    int cPref = 0;
                    for (int i3 = 0; i3 < msTypes.length; ++i3) {
                        Class msType2 = msTypes[i3];
                        Class<?> cType2 = cTypes[i3];
                        msPref += CallableSelector.calcTypePreference(msType2, args2[i3]);
                        cPref += CallableSelector.calcTypePreference(cType2, args2[i3]);
                    }
                    if (msPref <= cPref) continue;
                    ambiguous = false;
                }
                method = mostSpecific;
                if (ambiguous) {
                    runtime.getWarnings().warn("ambiguous Java methods found, using " + ((Member)((Object)((JavaCallable)method).accessibleObject())).getName() + CodegenUtils.prettyParams(msTypes));
                }
            }
        }
        if (method == null && (method = CallableSelector.findCallable(methods2, (CallableAcceptor)Exact, (IRubyObject[])args2)) == null && (method = CallableSelector.findCallable(methods2, (CallableAcceptor)AssignableAndPrimitivable, (IRubyObject[])args2)) == null && (method = CallableSelector.findCallable(methods2, (CallableAcceptor)AssignableOrDuckable, (IRubyObject[])args2)) == null && (method = CallableSelector.findCallable(methods2, (CallableAcceptor)AssignableOrDuckable, (IRubyObject[])args2)) == null) {
            method = CallableSelector.findCallable(methods2, (CallableAcceptor)AssignableAndPrimitivableWithVarargs, (IRubyObject[])args2);
        }
        return (T)method;
    }

    private static <T extends ParameterTypes> T matchProcToInterfaceCandidate(IRubyObject lastArg, List<T> candidates) {
        if (lastArg instanceof RubyProc) {
            int arity2 = ((RubyProc)lastArg).getBlock().arity().getValue();
            ParameterTypes match = null;
            for (int i2 = 0; i2 < candidates.size(); ++i2) {
                ParameterTypes method = (ParameterTypes)candidates.get(i2);
                Class<?>[] params2 = method.getParameterTypes();
                if (params2.length == 0) {
                    return null;
                }
                Class<?> lastParam = params2[params2.length - 1];
                if (!lastParam.isInterface()) {
                    return null;
                }
                Method implMethod = Java.getFunctionalInterfaceMethod(lastParam);
                if (implMethod == null || implMethod.getParameterTypes().length != arity2) continue;
                if (match != null) {
                    return null;
                }
                match = method;
            }
            return (T)match;
        }
        return null;
    }

    private static <T extends ParameterTypes> T findCallable(T[] callables, CallableAcceptor acceptor, IRubyObject[] args2) {
        T bestCallable = null;
        int bestScore = -1;
        for (int i2 = 0; i2 < callables.length; ++i2) {
            int currentScore;
            T callable = callables[i2];
            if (!acceptor.accept((ParameterTypes)callable, args2) || (currentScore = CallableSelector.calcExactnessScore(callable, args2)) <= bestScore) continue;
            bestCallable = callable;
            bestScore = currentScore;
        }
        return bestCallable;
    }

    private static <T extends ParameterTypes> List<T> findCallableCandidates(T[] callables, IRubyObject[] args2) {
        for (int c = 0; c < callables.length; ++c) {
            T callable = callables[c];
            if (!CallableSelector.exactMatch(callable, args2)) continue;
            return Collections.singletonList(callable);
        }
        ArrayList<ParameterTypes> retained = new ArrayList<ParameterTypes>(callables.length);
        ParameterTypes[] incoming = (ParameterTypes[])callables.clone();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            retained.clear();
            for (Matcher matcher : NON_EXACT_MATCH_SEQUENCE) {
                for (int c = 0; c < incoming.length; ++c) {
                    Class<?>[] types;
                    ParameterTypes callable = incoming[c];
                    if (callable == null || !matcher.match((types = callable.getParameterTypes())[i2], args2[i2])) continue;
                    retained.add(callable);
                    incoming[c] = null;
                }
            }
            incoming = retained.toArray(new ParameterTypes[retained.size()]);
        }
        return retained;
    }

    private static int calcExactnessScore(ParameterTypes callable, IRubyObject[] args2) {
        Class<?>[] types = callable.getParameterTypes();
        int count2 = 0;
        if (callable.isVarArgs()) {
            int nonVarargs = types.length - 1;
            ++count2;
            for (int i2 = 0; i2 < nonVarargs && i2 < args2.length; ++i2) {
                if (types[i2] != CallableSelector.getJavaClass(args2[i2])) continue;
                ++count2;
            }
        } else {
            for (int i3 = 0; i3 < args2.length; ++i3) {
                if (types[i3] != CallableSelector.getJavaClass(args2[i3])) continue;
                ++count2;
            }
        }
        return count2;
    }

    private static boolean exactMatch(ParameterTypes paramTypes, IRubyObject ... args2) {
        Class<?>[] types = paramTypes.getParameterTypes();
        if (args2.length != types.length) {
            return false;
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (EXACT.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableAndPrimitivable(ParameterTypes paramTypes, IRubyObject ... args2) {
        Class<?>[] types = paramTypes.getParameterTypes();
        if (args2.length != types.length) {
            return false;
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (ASSIGNABLE.match(types[i2], args2[i2]) && PRIMITIVABLE.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableOrDuckable(ParameterTypes paramTypes, IRubyObject ... args2) {
        Class<?>[] types = paramTypes.getParameterTypes();
        if (args2.length != types.length) {
            return false;
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (ASSIGNABLE.match(types[i2], args2[i2]) || DUCKABLE.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableAndPrimitivableWithVarargs(ParameterTypes paramTypes, IRubyObject ... args2) {
        int i2;
        if (!paramTypes.isVarArgs()) {
            return false;
        }
        Class<?>[] types = paramTypes.getParameterTypes();
        Class<?> varArgArrayType = types[types.length - 1];
        Class<?> varArgType = varArgArrayType.getComponentType();
        if (args2.length == 0) {
            return types.length <= 1;
        }
        int nonVarargs = types.length - 1;
        for (i2 = args2.length - 1; i2 >= nonVarargs; --i2) {
            if (ASSIGNABLE.match(varArgType, args2[i2]) || PRIMITIVABLE.match(varArgType, args2[i2])) continue;
            return false;
        }
        for (i2 = 0; i2 < nonVarargs; ++i2) {
            if (ASSIGNABLE.match(types[i2], args2[i2]) || PRIMITIVABLE.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignable(Class<?> type2, IRubyObject arg2) {
        return JavaClass.assignable(type2, CallableSelector.getJavaClass(arg2));
    }

    private static boolean primitivable(Class<?> type2, IRubyObject arg2) {
        Class<?> argClass = CallableSelector.getJavaClass(arg2);
        if (type2.isPrimitive()) {
            if (type2 == Integer.TYPE || type2 == Long.TYPE || type2 == Short.TYPE || type2 == Character.TYPE) {
                return argClass == Long.TYPE || argClass == Byte.TYPE || argClass == Short.TYPE || argClass == Character.TYPE || argClass == Integer.TYPE || argClass == Long.class || argClass == Byte.class || argClass == Short.class || argClass == Character.class || argClass == Integer.class;
            }
            if (type2 == Float.TYPE || type2 == Double.TYPE) {
                return argClass == Double.TYPE || argClass == Float.TYPE || argClass == Float.class || argClass == Double.class;
            }
            if (type2 == Boolean.TYPE) {
                return argClass == Boolean.TYPE || argClass == Boolean.class;
            }
        }
        return false;
    }

    private static int calcTypePreference(Class<?> type2, IRubyObject arg2) {
        boolean primitive = type2.isPrimitive();
        if (primitive) {
            type2 = CodegenUtils.getBoxType(type2);
        }
        if (Number.class.isAssignableFrom(type2) || Character.class == type2) {
            if (arg2 instanceof RubyFixnum) {
                if (type2 == Long.class) {
                    return 10;
                }
                if (type2 == Integer.class) {
                    return 8;
                }
                if (type2 == BigInteger.class) {
                    return 7;
                }
                if (type2 == Short.class) {
                    return 6;
                }
                if (type2 == Byte.class) {
                    return 4;
                }
                if (type2 == Float.class) {
                    return 3;
                }
                if (type2 == Double.class) {
                    return 2;
                }
                return 1;
            }
            if (arg2 instanceof RubyBignum) {
                if (type2 == BigInteger.class) {
                    return 10;
                }
                if (type2 == Long.class) {
                    return 4;
                }
                if (type2 == Double.class) {
                    return 6;
                }
                if (type2 == Float.class) {
                    return 5;
                }
                return 1;
            }
            if (arg2 instanceof RubyInteger) {
                if (type2 == Long.class) {
                    return 10;
                }
                if (type2 == Integer.class) {
                    return 8;
                }
                if (type2 == Float.class) {
                    return 3;
                }
                if (type2 == Double.class) {
                    return 2;
                }
                return 1;
            }
            if (arg2 instanceof RubyFloat) {
                if (type2 == Double.class) {
                    return 10;
                }
                if (type2 == Float.class) {
                    return 8;
                }
                if (type2 == BigDecimal.class) {
                    return 6;
                }
                if (type2 == Long.class) {
                    return 4;
                }
                if (type2 == Integer.class) {
                    return 3;
                }
                if (type2 == Short.class) {
                    return 2;
                }
                return 1;
            }
        } else if (arg2 instanceof RubyString) {
            if (type2 == String.class) {
                return 10;
            }
            if (type2 == byte[].class) {
                return 8;
            }
            if (CharSequence.class.isAssignableFrom(type2)) {
                return 7;
            }
            if (type2 == Character.class) {
                return 1;
            }
        } else if (arg2 instanceof RubyBoolean && type2 == Boolean.class) {
            return 10;
        }
        return 0;
    }

    private static boolean duckable(Class<?> type2, IRubyObject arg2) {
        return JavaUtil.isDuckTypeConvertable(CallableSelector.getJavaClass(arg2), type2);
    }

    private static int argsHashCode(IRubyObject a0) {
        return 31 + CallableSelector.javaClassOrProcHashCode(a0);
    }

    private static int argsHashCode(IRubyObject a0, IRubyObject a1) {
        return 17 * (31 + CallableSelector.javaClassHashCode(a0)) + CallableSelector.javaClassOrProcHashCode(a1);
    }

    private static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2) {
        return 17 * (17 * (31 + CallableSelector.javaClassHashCode(a0)) + CallableSelector.javaClassHashCode(a1)) + CallableSelector.javaClassOrProcHashCode(a2);
    }

    private static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2, IRubyObject a3) {
        return 17 * (17 * (17 * (31 + CallableSelector.javaClassHashCode(a0)) + CallableSelector.javaClassHashCode(a1)) + CallableSelector.javaClassHashCode(a2)) + CallableSelector.javaClassOrProcHashCode(a3);
    }

    private static int argsHashCode(IRubyObject[] args2) {
        int last2 = args2.length - 1;
        if (last2 == -1) {
            return 0;
        }
        int result2 = 31;
        for (int i2 = 0; i2 < last2; ++i2) {
            result2 = 17 * (result2 + CallableSelector.javaClassHashCode(args2[i2]));
        }
        return result2 + CallableSelector.javaClassOrProcHashCode(args2[last2]);
    }

    private static int javaClassHashCode(IRubyObject arg2) {
        return arg2.getJavaClass().hashCode();
    }

    private static int javaClassOrProcHashCode(IRubyObject arg2) {
        Class javaClass = arg2.getJavaClass();
        return javaClass == RubyProc.class ? arg2.hashCode() : javaClass.hashCode();
    }

    private static Class<?> getJavaClass(IRubyObject arg2) {
        return arg2 != null ? arg2.getJavaClass() : Void.TYPE;
    }

    public static <T extends ParameterTypes> IntHashMap<T> newCallableCache() {
        return new IntHashMap(8);
    }

    private static interface Matcher {
        public boolean match(Class<?> var1, IRubyObject var2);
    }

    private static interface CallableAcceptor {
        public boolean accept(ParameterTypes var1, IRubyObject[] var2);
    }
}

