/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.math.BigInteger;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class Fixnum
extends ImmutableLiteral {
    public final long value;

    public Fixnum(long val) {
        super(OperandType.FIXNUM);
        this.value = val;
    }

    public Fixnum(BigInteger val) {
        this(val.longValue());
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newFixnum(this.value);
    }

    public int hashCode() {
        return 329 + (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object other) {
        return other instanceof Fixnum && this.value == ((Fixnum)other).value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Fixnum(this);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.value);
    }

    public static Fixnum decode(IRReaderDecoder d) {
        return new Fixnum(d.decodeLong());
    }

    public String toString() {
        return "Fixnum:" + this.value;
    }
}

