/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.Stack;
import org.jruby.RubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.interpreter.InterpreterEngine;
import org.jruby.ir.interpreter.Profiler;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.ConstantCache;

public class StartupInterpreterEngine
extends InterpreterEngine {
    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject[] args2, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        if (interpreterContext.receivesKeywordArguments()) {
            IRRuntimeHelpers.frobnicateKwargsArgument(context, interpreterContext.getRequiredArgsCount(), args2);
        }
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        boolean acceptsKeywordArgument = interpreterContext.receivesKeywordArguments();
        Stack<Integer> rescuePCs = new Stack<Integer>();
        boolean debug = IRRuntimeHelpers.isDebug();
        boolean profile = IRRuntimeHelpers.inProfileMode();
        Integer scopeVersion = profile ? Profiler.initProfiling(interpreterContext.getScope()) : 0;
        while (ipc < n) {
            Instr instr = instrs[ipc];
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {" + ipc + "} ", instr + "; <#RPCs=" + rescuePCs.size() + ">");
                ++Interpreter.interpInstrsCount;
            } else if (profile) {
                Profiler.instrTick(operation);
                ++Interpreter.interpInstrsCount;
            }
            ++ipc;
            try {
                block1 : switch (operation.opClass) {
                    case ARG_OP: {
                        StartupInterpreterEngine.receiveArg(context, instr, operation, args2, acceptsKeywordArgument, currDynScope, temp, exception2, block);
                        break;
                    }
                    case CALL_OP: {
                        if (profile) {
                            Profiler.updateCallSite(instr, interpreterContext.getScope(), scopeVersion);
                        }
                        StartupInterpreterEngine.processCall(context, instr, operation, currDynScope, currScope, temp, self2);
                        break;
                    }
                    case RET_OP: {
                        return StartupInterpreterEngine.processReturnOp(context, instr, operation, currDynScope, temp, self2, blockType, currScope);
                    }
                    case BRANCH_OP: {
                        switch (operation) {
                            case JUMP: {
                                JumpInstr jump = (JumpInstr)instr;
                                if (jump.exitsExcRegion()) {
                                    rescuePCs.pop();
                                }
                                ipc = jump.getJumpTarget().getTargetPC();
                                break block1;
                            }
                        }
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BOOK_KEEPING_OP: {
                        if (operation == Operation.PUSH_BINDING) {
                            currDynScope = interpreterContext.newDynamicScope(context);
                            context.pushScope(currDynScope);
                            break;
                        }
                        StartupInterpreterEngine.processBookKeepingOp(context, instr, operation, name2, args2, self2, block, blockType, implClass, rescuePCs);
                        break;
                    }
                    case OTHER_OP: {
                        StartupInterpreterEngine.processOtherOp(context, instr, operation, currDynScope, currScope, temp, self2, blockType);
                    }
                }
            }
            catch (Throwable t) {
                if (debug) {
                    StartupInterpreterEngine.extractToMethodToAvoidC2Crash(instr, t);
                }
                ipc = rescuePCs.empty() || t instanceof IRBreakJump && instr instanceof BreakInstr || t instanceof IRReturnJump && instr instanceof NonlocalReturnInstr ? -1 : (Integer)rescuePCs.pop();
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    protected static void processOtherOp(ThreadContext context, Instr instr, Operation operation, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject self2, Block.Type blockType) {
        switch (operation) {
            case RECV_SELF: {
                break;
            }
            case COPY: {
                CopyInstr c = (CopyInstr)instr;
                StartupInterpreterEngine.setResult(temp, currDynScope, c.getResult(), StartupInterpreterEngine.retrieveOp(c.getSource(), context, self2, currDynScope, currScope, temp));
                break;
            }
            case GET_FIELD: {
                IRubyObject result2;
                GetFieldInstr gfi = (GetFieldInstr)instr;
                IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                VariableAccessor a = gfi.getAccessor(object);
                IRubyObject iRubyObject = result2 = a == null ? null : (IRubyObject)a.get(object);
                if (result2 == null) {
                    if (context.runtime.isVerbose()) {
                        context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                    }
                    result2 = context.nil;
                }
                StartupInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result2);
                break;
            }
            case SEARCH_CONST: {
                SearchConstInstr sci = (SearchConstInstr)instr;
                ConstantCache cache = sci.getConstantCache();
                IRubyObject result3 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                StartupInterpreterEngine.setResult(temp, currDynScope, sci.getResult(), (Object)result3);
                break;
            }
            case RUNTIME_HELPER: {
                RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                StartupInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType));
                break;
            }
            case CHECK_FOR_LJE: {
                ((CheckForLJEInstr)instr).check(context, currDynScope, blockType);
                break;
            }
            case LOAD_FRAME_CLOSURE: {
                StartupInterpreterEngine.setResult(temp, currDynScope, instr, (Object)context.getFrameBlock());
                return;
            }
            default: {
                StartupInterpreterEngine.setResult(temp, currDynScope, instr, instr.interpret(context, currScope, currDynScope, self2, temp));
            }
        }
    }
}

