/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.Visibility;

public abstract class TypePopulator {
    public static final TypePopulator DEFAULT = new DefaultTypePopulator();

    public static void populateMethod(JavaMethod javaMethod, int arity2, String simpleName, boolean isStatic, CallConfiguration callConfig, boolean notImplemented) {
        javaMethod.setIsBuiltin(true);
        javaMethod.setArity(Arity.createArity(arity2));
        javaMethod.setJavaName(simpleName);
        javaMethod.setSingleton(isStatic);
        javaMethod.setCallConfig(callConfig);
        javaMethod.setNotImplemented(notImplemented);
    }

    public static void populateMethod(JavaMethod javaMethod, int arity2, String simpleName, boolean isStatic, CallConfiguration callConfig, boolean notImplemented, Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeArguments, CallConfiguration callerRequirement) {
        javaMethod.setIsBuiltin(true);
        javaMethod.setArity(Arity.createArity(arity2));
        javaMethod.setJavaName(simpleName);
        javaMethod.setSingleton(isStatic);
        javaMethod.setCallConfig(callConfig);
        javaMethod.setNotImplemented(notImplemented);
        javaMethod.setNativeCall(nativeTarget, nativeName, nativeReturn, nativeArguments, isStatic, false);
        javaMethod.setCallerRequirement(callerRequirement);
    }

    public static DynamicMethod populateModuleMethod(RubyModule cls, JavaMethod javaMethod) {
        DynamicMethod moduleMethod = javaMethod.dup();
        moduleMethod.setImplementationClass(cls.getSingletonClass());
        moduleMethod.setVisibility(Visibility.PUBLIC);
        return moduleMethod;
    }

    public abstract void populate(RubyModule var1, Class var2);

    public static class DefaultTypePopulator
    extends TypePopulator {
        @Override
        public void populate(RubyModule clsmod, Class clazz) {
            MethodFactory methodFactory = MethodFactory.createFactory(clsmod.getRuntime().getJRubyClassLoader());
            Ruby runtime = clsmod.getRuntime();
            RubyModule.MethodClumper clumper = new RubyModule.MethodClumper();
            clumper.clump(clazz);
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : clumper.getStaticAnnotatedMethods().entrySet()) {
                clsmod.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
                for (JavaMethodDescriptor desc : entry.getValue()) {
                    if (desc.anno.omit()) continue;
                    runtime.addBoundMethod(desc.declaringClassName, desc.name, entry.getKey());
                }
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : clumper.getAnnotatedMethods().entrySet()) {
                clsmod.defineAnnotatedMethod(entry.getKey(), entry.getValue(), methodFactory);
                for (JavaMethodDescriptor desc : entry.getValue()) {
                    if (desc.anno.omit()) continue;
                    runtime.addBoundMethod(desc.declaringClassName, desc.name, entry.getKey());
                }
            }
        }
    }
}

