/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BlockingIO;
import org.jruby.util.io.OpenFile;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger("RubyThread");
    private volatile ThreadLike threadImpl;
    private volatile transient Map<IRubyObject, IRubyObject> fiberLocalVariables;
    private volatile transient Map<IRubyObject, IRubyObject> threadLocalVariables;
    private final Map<Object, IRubyObject> contextVariables = new WeakHashMap<Object, IRubyObject>();
    private volatile boolean abortOnException;
    private volatile IRubyObject finalResult;
    private volatile RaiseException exitingException;
    private volatile RubyThreadGroup threadGroup;
    private volatile IRubyObject errorInfo;
    private volatile WeakReference<ThreadContext> contextRef;
    private volatile boolean handleInterrupt = true;
    private final List<RubyHash> interruptMaskStack = Collections.synchronizedList(new ArrayList());
    private final SleepTask2 sleepTask = new SleepTask2();
    private static final boolean DEBUG = false;
    private static final int RUBY_MIN_THREAD_PRIORITY = -3;
    private static final int RUBY_MAX_THREAD_PRIORITY = 3;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.RUN);
    private final Queue<IRubyObject> pendingInterruptQueue = new ConcurrentLinkedQueue<IRubyObject>();
    private volatile Unblocker unblockFunc;
    private volatile Object unblockArg;
    private final List<Lock> heldLocks = new Vector<Lock>();
    private volatile boolean disposed = false;
    private volatile int interruptFlag = 0;
    private volatile int interruptMask;
    private volatile boolean pendingInterruptQueueChecked = false;
    private volatile Selector currentSelector;
    private static final AtomicIntegerFieldUpdater INTERRUPT_FLAG_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RubyThread.class, "interruptFlag");
    private static final int TIMER_INTERRUPT_MASK = 1;
    private static final int PENDING_INTERRUPT_MASK = 2;
    private static final int POSTPONED_JOB_INTERRUPT_MASK = 4;
    private static final int TRAP_INTERRUPT_MASK = 8;
    private static final int INTERRUPT_NONE = 0;
    private static final int INTERRUPT_IMMEDIATE = 1;
    private static final int INTERRUPT_ON_BLOCKING = 2;
    private static final int INTERRUPT_NEVER = 3;
    private volatile BlockingIO.Condition blockingIO = null;
    @Deprecated
    private volatile BlockingTask currentBlockingTask;

    protected RubyThread(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.finalResult = runtime.getNil();
        this.errorInfo = runtime.getNil();
    }

    public RubyThread(Ruby runtime, RubyClass klass, Runnable runnable) {
        this(runtime, klass);
        this.startWith(runnable);
    }

    private void executeInterrupts(ThreadContext context, boolean blockingTiming) {
        int interrupt;
        Ruby runtime = context.runtime;
        boolean postponedJobInterrupt = false;
        while ((interrupt = this.getInterrupts()) != 0) {
            IRubyObject err;
            boolean timerInterrupt = (interrupt & 1) == 1;
            boolean pendingInterrupt = (interrupt & 2) == 2;
            if (!pendingInterrupt || !this.pendingInterruptActive() || (err = this.pendingInterruptDeque(context, blockingTiming ? 2 : 0)) == UNDEF) continue;
            if (err == RubyFixnum.zero(runtime) || err == RubyFixnum.one(runtime) || err == RubyFixnum.two(runtime)) {
                this.toKill();
                continue;
            }
            this.afterBlockingCall();
            if (this.status.get() == Status.SLEEP) {
                this.exitSleep();
            }
            RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{err}, Block.NULL_BLOCK);
        }
    }

    private void postponedJobFlush(ThreadContext context) {
    }

    private boolean pendingInterruptActive() {
        if (this.pendingInterruptQueueChecked) {
            return false;
        }
        return !this.pendingInterruptQueue.isEmpty();
    }

    private void toKill() {
        this.pendingInterruptClear();
        RubyThread.throwThreadKill();
    }

    private void pendingInterruptClear() {
        this.pendingInterruptQueue.clear();
    }

    private int getInterrupts() {
        int interrupt;
        while (!INTERRUPT_FLAG_UPDATER.compareAndSet(this, interrupt = this.interruptFlag, interrupt & this.interruptMask)) {
        }
        return interrupt & ~this.interruptMask;
    }

    private IRubyObject pendingInterruptDeque(ThreadContext context, int timing) {
        Iterator iterator = this.pendingInterruptQueue.iterator();
        while (iterator.hasNext()) {
            IRubyObject err = (IRubyObject)iterator.next();
            int maskTiming = this.pendingInterruptCheckMask(context, err);
            switch (maskTiming) {
                case 2: {
                    if (timing != 2) break;
                }
                case 0: 
                case 1: {
                    iterator.remove();
                    return err;
                }
            }
        }
        this.pendingInterruptQueueChecked = true;
        return UNDEF;
    }

    private int pendingInterruptCheckMask(ThreadContext context, IRubyObject err) {
        List<IRubyObject> ancestors2 = err.getMetaClass().getAncestorList();
        int ancestorsLen = ancestors2.size();
        List<RubyHash> maskStack = this.interruptMaskStack;
        int maskStackLen = maskStack.size();
        for (int i2 = 0; i2 < maskStackLen; ++i2) {
            RubyHash mask = maskStack.get(maskStackLen - (i2 + 1));
            for (int j = 0; j < ancestorsLen; ++j) {
                String symStr;
                IRubyObject klass = ancestors2.get(j);
                IRubyObject sym = mask.op_aref(context, klass);
                if (sym.isNil()) continue;
                switch (symStr = sym.toString()) {
                    case "immediate": {
                        return 1;
                    }
                    case "on_blocking": {
                        return 2;
                    }
                    case "never": {
                        return 3;
                    }
                }
                throw context.runtime.newThreadError("unknown mask signature");
            }
        }
        return 0;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public void setContext(ThreadContext context) {
        this.contextRef = new WeakReference<ThreadContext>(context);
    }

    public ThreadContext getContext() {
        return this.contextRef == null ? null : (ThreadContext)this.contextRef.get();
    }

    public Thread getNativeThread() {
        return this.threadImpl.nativeThread();
    }

    public void beforeStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            this.threadGroup.remove(this);
            this.unlockAll();
            this.beDead();
        }
        this.getRuntime().getThreadService().unregisterThread(this);
    }

    public static RubyClass createThreadClass(Ruby runtime) {
        RubyClass threadClass = runtime.defineClass("Thread", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setThread(threadClass);
        threadClass.setClassIndex(ClassIndex.THREAD);
        threadClass.setReifiedClass(RubyThread.class);
        threadClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(runtime, threadClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime.getThreadService().setMainThread(Thread.currentThread(), rubyThread);
        runtime.getDefaultThreadGroup().addDirectly(rubyThread);
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        RubyClass backtrace2 = threadClass.defineClassUnder("Backtrace", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass location = backtrace2.defineClassUnder("Location", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        location.defineAnnotatedMethods(Location.class);
        runtime.setLocation(location);
        return threadClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, true, block);
    }

    public static RubyThread start(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.start19(recv2, args2, block);
    }

    @JRubyMethod(rest=true, name={"start"}, meta=true)
    public static RubyThread start19(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        if (!block.isGiven()) {
            throw runtime.newArgumentError("tried to create Proc object without a block");
        }
        return RubyThread.startThread(recv2, args2, false, block);
    }

    public static RubyThread adopt(IRubyObject recv2, Thread t) {
        return RubyThread.adoptThread(recv2, t, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject recv2, Thread t, Block block) {
        Ruby runtime = recv2.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime, (RubyClass)recv2);
        rubyThread.threadImpl = new NativeThread(rubyThread, t);
        ThreadContext context = runtime.getThreadService().registerNewThread(rubyThread);
        runtime.getThreadService().associateThread(t, rubyThread);
        context.preAdoptThread();
        runtime.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime = this.getRuntime();
        if (!block.isGiven()) {
            throw runtime.newThreadError("must be called with a block");
        }
        if (this.threadImpl != null) {
            throw runtime.newThreadError("already initialized thread");
        }
        RubyRunnable runnable = new RubyRunnable(this, args2, block);
        return this.startWith(runnable);
    }

    private IRubyObject startWith(Runnable runnable) throws RaiseException, OutOfMemoryError {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            Thread thread2 = new Thread(runnable);
            thread2.setDaemon(true);
            thread2.setName("Ruby-" + runtime.getRuntimeNumber() + "-" + thread2.getName() + ": " + context.getFile() + ":" + (context.getLine() + 1));
            this.threadImpl = new NativeThread(this, thread2);
            this.addToCorrectThreadGroup(context);
            runtime.getThreadService().associateThread(thread2, this);
            this.threadImpl.start();
            Thread.yield();
            return this;
        }
        catch (OutOfMemoryError oome) {
            if (oome.getMessage().equals("unable to create new native thread")) {
                throw runtime.newThreadError(oome.getMessage());
            }
            throw oome;
        }
        catch (SecurityException ex) {
            throw runtime.newThreadError(ex.getMessage());
        }
    }

    private static RubyThread startThread(IRubyObject recv2, IRubyObject[] args2, boolean callInit, Block block) {
        RubyThread rubyThread = new RubyThread(recv2.getRuntime(), (RubyClass)recv2);
        if (callInit) {
            rubyThread.callInit(args2, block);
        } else {
            rubyThread.initialize(recv2.getRuntime().getCurrentContext(), args2, block);
        }
        return rubyThread;
    }

    public synchronized void cleanTerminate(IRubyObject result2) {
        this.finalResult = result2;
    }

    public synchronized void beDead() {
        this.status.set(Status.DEAD);
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.getRuntime().getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext context) {
        if (this.anyInterrupted()) {
            this.executeInterrupts(context, true);
        }
    }

    private boolean anyInterrupted() {
        return Thread.interrupted() || (this.interruptFlag & ~this.interruptMask) != 0;
    }

    private static void throwThreadKill() {
        throw new ThreadKill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject handle_interrupt(ThreadContext context, IRubyObject self2, IRubyObject _mask, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            throw runtime.newArgumentError("block is needed");
        }
        RubyHash mask = (RubyHash)TypeConverter.convertToTypeWithCheck(_mask, runtime.getHash(), "to_hash");
        mask.visitAll(new RubyHash.Visitor(){

            @Override
            public void visit(IRubyObject key2, IRubyObject value2) {
                RubySymbol sym;
                String symString;
                if (value2 instanceof RubySymbol && !(symString = (sym = (RubySymbol)value2).toString()).equals("immediate") && !symString.equals("on_blocking") && !symString.equals("never")) {
                    throw key2.getRuntime().newArgumentError("unknown mask signature");
                }
            }
        });
        RubyThread th = context.getThread();
        th.interruptMaskStack.add(mask);
        if (th.pendingInterruptQueue.isEmpty()) {
            th.pendingInterruptQueueChecked = false;
            th.setInterrupt();
        }
        try {
            IRubyObject iRubyObject = block.call(context);
            return iRubyObject;
        }
        finally {
            th.interruptMaskStack.remove(th.interruptMaskStack.size() - 1);
            th.setInterrupt();
            th.pollThreadEvents(context);
        }
    }

    @JRubyMethod(name={"pending_interrupt?"}, meta=true, optional=1)
    public static IRubyObject pending_interrupt_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return context.getThread().pending_interrupt_p(context, args2);
    }

    @JRubyMethod(name={"pending_interrupt?"}, optional=1)
    public IRubyObject pending_interrupt_p(ThreadContext context, IRubyObject[] args2) {
        if (this.pendingInterruptQueue.isEmpty()) {
            return context.runtime.getFalse();
        }
        if (args2.length == 1) {
            IRubyObject err = args2[0];
            if (!(err instanceof RubyModule)) {
                throw context.runtime.newTypeError("class or module required for rescue clause");
            }
            if (this.pendingInterruptInclude(err)) {
                return context.runtime.getTrue();
            }
            return context.runtime.getFalse();
        }
        return context.runtime.getTrue();
    }

    private boolean pendingInterruptInclude(IRubyObject err) {
        for (IRubyObject e : this.pendingInterruptQueue) {
            if (!((RubyModule)e).op_le(err).isTrue()) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception_x(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        return runtime.isGlobalAbortOnExceptionEnabled() ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set_x(IRubyObject recv2, IRubyObject value2) {
        recv2.getRuntime().setGlobalAbortOnExceptionEnabled(value2.isTrue());
        return value2;
    }

    @JRubyMethod(meta=true)
    public static RubyThread current(IRubyObject recv2) {
        return recv2.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(meta=true)
    public static RubyThread main(IRubyObject recv2) {
        return recv2.getRuntime().getThreadService().getMainThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject pass(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        ThreadService ts = runtime.getThreadService();
        boolean critical = ts.getCritical();
        ts.setCritical(false);
        try {
            Thread.yield();
        }
        finally {
            ts.setCritical(critical);
        }
        return recv2.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject exclusive(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime = context.runtime;
        ThreadService ts = runtime.getThreadService();
        boolean critical = ts.getCritical();
        ts.setCritical(true);
        try {
            IRubyObject iRubyObject = block.yieldSpecific(context);
            return iRubyObject;
        }
        finally {
            ts.setCritical(critical);
        }
    }

    @JRubyMethod(meta=true)
    public static RubyArray list(IRubyObject recv2) {
        IRubyObject[] activeThreads = recv2.getRuntime().getThreadService().getActiveRubyThreads();
        return recv2.getRuntime().newArrayNoCopy(activeThreads);
    }

    private void addToCorrectThreadGroup(ThreadContext context) {
        IRubyObject group2 = context.getThread().group();
        if (!group2.isNil()) {
            ((RubyThreadGroup)group2).addDirectly(this);
        } else {
            context.runtime.getDefaultThreadGroup().addDirectly(this);
        }
    }

    private IRubyObject getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return originalKey;
        }
        if (originalKey instanceof RubyString) {
            return this.getRuntime().newSymbol(originalKey.asJavaString());
        }
        if (originalKey instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "Do not use Fixnums as Symbols");
            throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
        }
        throw this.getRuntime().newTypeError(originalKey + " is not a symbol");
    }

    private synchronized Map<IRubyObject, IRubyObject> getFiberLocals() {
        if (this.fiberLocalVariables == null) {
            this.fiberLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.fiberLocalVariables;
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals(ThreadContext context) {
        return context.getFiberCurrentThread().getThreadLocals0();
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals0() {
        if (this.threadLocalVariables == null) {
            this.threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.threadLocalVariables;
    }

    @Override
    public final Map<Object, IRubyObject> getContextVariables() {
        return this.contextVariables;
    }

    public boolean isAlive() {
        return this.threadImpl.isAlive() && this.status.get() != Status.ABORTING;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public synchronized IRubyObject op_aref(IRubyObject key2) {
        IRubyObject value2 = this.getFiberLocals().get(this.getSymbolKey(key2));
        if (value2 != null) {
            return value2;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"[]="}, required=2)
    public synchronized IRubyObject op_aset(IRubyObject key2, IRubyObject value2) {
        key2 = this.getSymbolKey(key2);
        this.getFiberLocals().put(key2, value2);
        return value2;
    }

    @JRubyMethod(name={"thread_variable?"}, required=1)
    public synchronized IRubyObject thread_variable_p(ThreadContext context, IRubyObject key2) {
        return context.runtime.newBoolean(this.getThreadLocals(context).containsKey(this.getSymbolKey(key2)));
    }

    @JRubyMethod(name={"thread_variable_get"}, required=1)
    public synchronized IRubyObject thread_variable_get(ThreadContext context, IRubyObject key2) {
        IRubyObject value2 = this.getThreadLocals(context).get(this.getSymbolKey(key2));
        if (value2 != null) {
            return value2;
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"thread_variable_set"}, required=2)
    public synchronized IRubyObject thread_variable_set(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        key2 = this.getSymbolKey(key2);
        this.getThreadLocals(context).put(key2, value2);
        return value2;
    }

    @JRubyMethod(name={"thread_variables"})
    public synchronized IRubyObject thread_variables(ThreadContext context) {
        Map<IRubyObject, IRubyObject> vars = this.getThreadLocals(context);
        RubyArray ary = RubyArray.newArray(context.runtime, vars.size());
        for (Map.Entry<IRubyObject, IRubyObject> entry : vars.entrySet()) {
            ary.append(entry.getKey());
        }
        return ary;
    }

    @JRubyMethod
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return this.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Deprecated
    public IRubyObject join(IRubyObject[] args2) {
        return this.join(this.getRuntime().getCurrentContext(), args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=1)
    public IRubyObject join(ThreadContext context, IRubyObject[] args2) {
        RubyThread currentThread;
        Ruby runtime;
        block16: {
            runtime = context.runtime;
            long timeoutMillis = Long.MAX_VALUE;
            if (args2.length > 0 && !args2[0].isNil()) {
                if (args2.length > 1) {
                    throw runtime.newArgumentError(args2.length, 1);
                }
                timeoutMillis = (long)(1000.0 * args2[0].convertToFloat().getValue());
                if (timeoutMillis <= 0L) {
                    if (this.threadImpl.isAlive()) {
                        return context.nil;
                    }
                    return this;
                }
            }
            if (this.isCurrent()) {
                throw runtime.newThreadError("thread " + this.identityString() + " tried to join itself");
            }
            currentThread = context.getThread();
            try {
                if (runtime.getThreadService().getCritical()) {
                    RubyThread rubyThread = this;
                    synchronized (rubyThread) {
                        this.notify();
                    }
                }
                long timeToWait = Math.min(timeoutMillis, 200L);
                long start2 = System.currentTimeMillis();
                do {
                    currentThread.pollThreadEvents();
                    this.threadImpl.join(timeToWait);
                } while (this.threadImpl.isAlive() && System.currentTimeMillis() - start2 <= timeoutMillis);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                assert (false) : ie;
            }
            catch (ExecutionException ie) {
                ie.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)ie);
            }
        }
        if (this.exitingException != null) {
            runtime.getGlobalVariables().set("$!", this.exitingException.getException());
            throw this.exitingException;
        }
        currentThread.pollThreadEvents(context);
        if (this.threadImpl.isAlive()) {
            return context.nil;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    @JRubyMethod
    public synchronized IRubyObject inspect() {
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":");
        part.append(this.identityString());
        part.append(' ');
        part.append(this.status.toString().toLowerCase());
        part.append('>');
        return this.getRuntime().newString(part.toString());
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject key2) {
        key2 = this.getSymbolKey(key2);
        return this.getRuntime().newBoolean(this.getFiberLocals().containsKey(key2));
    }

    @JRubyMethod
    public RubyArray keys() {
        IRubyObject[] keys2 = new IRubyObject[this.getFiberLocals().size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.getFiberLocals().keySet().toArray(keys2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject stop(ThreadContext context, IRubyObject receiver2) {
        RubyThread rubyThread;
        RubyThread rubyThread2 = rubyThread = context.getThread();
        synchronized (rubyThread2) {
            rubyThread.pollThreadEvents(context);
            try {
                receiver2.getRuntime().getThreadService().setCritical(false);
                rubyThread.status.set(Status.SLEEP);
                rubyThread.wait();
            }
            catch (InterruptedException ie) {
                rubyThread.pollThreadEvents(context);
                rubyThread.status.set(Status.RUN);
            }
        }
        return receiver2.getRuntime().getNil();
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject kill(IRubyObject receiver2, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw receiver2.getRuntime().newTypeError(rubyThread, receiver2.getRuntime().getThread());
        }
        return ((RubyThread)rubyThread).kill();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject exit(IRubyObject receiver2, Block block) {
        RubyThread rubyThread = receiver2.getRuntime().getThreadService().getCurrentContext().getThread();
        return rubyThread.kill();
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.status.get() == Status.SLEEP || this.status.get() == Status.DEAD);
    }

    @JRubyMethod
    public synchronized RubyThread wakeup() {
        if (!this.threadImpl.isAlive() && this.status.get() == Status.DEAD) {
            throw this.getRuntime().newThreadError("killed thread");
        }
        this.status.set(Status.RUN);
        this.interrupt();
        return this;
    }

    @JRubyMethod
    public RubyFixnum priority() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.javaPriorityToRubyPriority(this.threadImpl.getPriority()));
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject priority2) {
        int iPriority = RubyNumeric.fix2int(priority2);
        if (iPriority < -3) {
            iPriority = -3;
        } else if (iPriority > 3) {
            iPriority = 3;
        }
        if (this.threadImpl.isAlive()) {
            int jPriority = this.rubyPriorityToJavaPriority(iPriority);
            if (jPriority < 1) {
                jPriority = 1;
            } else if (jPriority > 10) {
                jPriority = 10;
            }
            this.threadImpl.setPriority(jPriority);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), iPriority);
    }

    private int javaPriorityToRubyPriority(int javaPriority) {
        double d = 1.5 * Math.sqrt(8.0 * (double)javaPriority + 41.0) - 13.5;
        return Math.round((float)d);
    }

    private int rubyPriorityToJavaPriority(int rubyPriority) {
        if (rubyPriority < -3) {
            rubyPriority = -3;
        } else if (rubyPriority > 3) {
            rubyPriority = 3;
        }
        double d = Math.pow(rubyPriority, 2.0) / 18.0 + 1.5 * (double)rubyPriority + 5.0;
        return Math.round((float)d);
    }

    public IRubyObject raise(IRubyObject exception2) {
        return this.raise(new IRubyObject[]{exception2}, Block.NULL_BLOCK);
    }

    @JRubyMethod(optional=3)
    public IRubyObject raise(IRubyObject[] args2, Block block) {
        Ruby runtime = this.getRuntime();
        RubyThread currentThread = runtime.getCurrentContext().getThread();
        return this.genericRaise(runtime, args2, currentThread);
    }

    public IRubyObject genericRaise(Ruby runtime, IRubyObject[] args2, RubyThread currentThread) {
        if (!this.isAlive()) {
            return runtime.getNil();
        }
        if (currentThread == this) {
            RubyKernel.raise(runtime.getCurrentContext(), runtime.getKernel(), args2, Block.NULL_BLOCK);
        }
        IRubyObject exception2 = this.prepareRaiseException(runtime, args2, Block.NULL_BLOCK);
        this.pendingInterruptEnqueue(exception2);
        this.interrupt();
        return runtime.getNil();
    }

    private IRubyObject prepareRaiseException(Ruby runtime, IRubyObject[] args2, Block block) {
        IRubyObject exception2;
        if (args2.length == 0) {
            IRubyObject lastException = this.errorInfo;
            if (lastException.isNil()) {
                return new RaiseException(runtime, runtime.getRuntimeError(), "", false).getException();
            }
            return lastException;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args2.length == 1) {
            if (args2[0] instanceof RubyString) {
                return runtime.getRuntimeError().newInstance(context, args2, block);
            }
            if (args2[0] instanceof ConcreteJavaProxy) {
                return args2[0];
            }
            if (!args2[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception");
        } else {
            if (!args2[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception", args2[1]);
        }
        if (!runtime.getException().isInstance(exception2)) {
            return runtime.newTypeError("exception object expected").getException();
        }
        if (args2.length == 3) {
            ((RubyException)exception2).set_backtrace(args2[2]);
        }
        return exception2;
    }

    @JRubyMethod
    public synchronized IRubyObject run() {
        return this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep(long millis) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        this.sleepTask.millis = millis;
        try {
            long timeSlept = this.executeTask(this.getContext(), null, this.sleepTask);
            if (millis == 0L || timeSlept >= millis) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sleepTask.semaphore.drainPermits();
        }
    }

    public IRubyObject status() {
        return this.status(this.getRuntime());
    }

    @JRubyMethod
    public IRubyObject status(ThreadContext context) {
        return this.status(context.runtime);
    }

    private synchronized IRubyObject status(Ruby runtime) {
        if (this.threadImpl.isAlive()) {
            return runtime.getThreadStatus(this.status.get());
        }
        if (this.exitingException != null) {
            return runtime.getNil();
        }
        return runtime.getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void executeBlockingTask(BlockingTask task) throws InterruptedException {
        try {
            this.currentBlockingTask = task;
            this.enterSleep();
            this.pollThreadEvents();
            task.run();
        }
        finally {
            this.exitSleep();
            this.currentBlockingTask = null;
            this.pollThreadEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Data, Return> Return executeTask(ThreadContext context, Data data2, Task<Data, Return> task) throws InterruptedException {
        try {
            this.unblockArg = data2;
            this.unblockFunc = task;
            this.pollThreadEvents(context);
            this.enterSleep();
            Return Return2 = task.run(context, data2);
            return Return2;
        }
        finally {
            this.exitSleep();
            this.unblockFunc = null;
            this.unblockArg = null;
            this.pollThreadEvents(context);
        }
    }

    public void enterSleep() {
        this.status.set(Status.SLEEP);
    }

    public void exitSleep() {
        this.status.set(Status.RUN);
    }

    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        Ruby runtime = this.getRuntime();
        RubyThread currentThread = runtime.getCurrentContext().getThread();
        if (currentThread == runtime.getThreadService().getMainThread()) {
            // empty if block
        }
        return this.genericKill(runtime, currentThread);
    }

    private IRubyObject genericKill(Ruby runtime, RubyThread currentThread) {
        if (currentThread == this) {
            RubyThread.throwThreadKill();
        }
        this.pendingInterruptEnqueue(RubyFixnum.zero(runtime));
        this.interrupt();
        return this;
    }

    private void pendingInterruptEnqueue(IRubyObject v) {
        this.pendingInterruptQueue.add(v);
        this.pendingInterruptQueueChecked = false;
    }

    public void dieFromFinalizer() {
        this.genericKill(this.getRuntime(), null);
    }

    private static void debug(RubyThread thread2, String message2) {
    }

    @JRubyMethod
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    public IRubyObject backtrace(ThreadContext context) {
        return this.backtrace20(context, NULL_ARRAY);
    }

    @JRubyMethod(name={"backtrace"}, optional=2)
    public IRubyObject backtrace20(ThreadContext context, IRubyObject[] args2) {
        ThreadContext myContext = this.getContext();
        if (myContext == null) {
            return context.nil;
        }
        Thread nativeThread = this.getNativeThread();
        if (nativeThread == null) {
            return context.nil;
        }
        Ruby runtime = context.runtime;
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(runtime, args2, 0);
        Integer level2 = ll[0];
        Integer length2 = ll[1];
        return myContext.createCallerBacktrace(level2, length2, this.getNativeThread().getStackTrace());
    }

    @JRubyMethod(optional=2)
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject[] args2) {
        ThreadContext myContext = this.getContext();
        if (myContext == null) {
            return context.nil;
        }
        Ruby runtime = context.runtime;
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(runtime, args2, 0);
        Integer level2 = ll[0];
        Integer length2 = ll[1];
        return myContext.createCallerLocations(level2, length2, this.getNativeThread().getStackTrace());
    }

    public StackTraceElement[] javaBacktrace() {
        if (this.threadImpl instanceof NativeThread) {
            return ((NativeThread)this.threadImpl).getThread().getStackTrace();
        }
        return new StackTraceElement[0];
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception2) {
        assert (this.isCurrent());
        RubyException rubyException = exception2.getException();
        Ruby runtime = rubyException.getRuntime();
        if (runtime.getSystemExit().isInstance(rubyException)) {
            runtime.getThreadService().getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(runtime)) {
                runtime.getThreadService().getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
                return;
            }
            if (runtime.getDebug().isTrue()) {
                runtime.printError(exception2.getException());
            }
        }
        this.exitingException = exception2;
    }

    public void exceptionRaised(Throwable exception2) {
        if (exception2 instanceof RaiseException) {
            this.exceptionRaised((RaiseException)exception2);
            return;
        }
        assert (this.isCurrent());
        Ruby runtime = this.getRuntime();
        if (this.abortOnException(runtime) && exception2 instanceof Error) {
            runtime.getThreadService().getMainThread().getNativeThread().stop(exception2);
        } else {
            Helpers.throwException(exception2);
        }
    }

    private boolean abortOnException(Ruby runtime) {
        return runtime.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver2) {
        return receiver2.getRuntime().getThreadService().getMainThread();
    }

    public boolean select(RubyIO io2, int ops) {
        return this.select(io2.getChannel(), io2.getOpenFile(), ops);
    }

    public boolean select(RubyIO io2, int ops, long timeout2) {
        return this.select(io2.getChannel(), io2.getOpenFile(), ops, timeout2);
    }

    public boolean select(Channel channel, OpenFile fptr, int ops) {
        return this.select(channel, fptr, ops, -1L);
    }

    public boolean select(Channel channel, RubyIO io2, int ops) {
        return this.select(channel, io2 == null ? null : io2.getOpenFile(), ops, -1L);
    }

    public boolean select(Channel channel, RubyIO io2, int ops, long timeout2) {
        return this.select(channel, io2 == null ? null : io2.getOpenFile(), ops, timeout2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Channel channel, OpenFile fptr, int ops, long timeout2) {
        if (!(channel instanceof SelectableChannel) || fptr != null && fptr.fd().isNativeFile) return true;
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean oldBlocking = selectable.isBlocking();
            SelectionKey key2 = null;
            try {
                Set<SelectionKey> keySet;
                selectable.configureBlocking(false);
                if (fptr != null) {
                    fptr.addBlockingThread(this);
                }
                this.currentSelector = this.getRuntime().getSelectorPool().get(selectable.provider());
                key2 = selectable.register(this.currentSelector, ops);
                this.beforeBlockingCall();
                int result2 = timeout2 < 0L ? this.currentSelector.select() : (timeout2 == 0L ? this.currentSelector.selectNow() : this.currentSelector.select(timeout2));
                this.pollThreadEvents();
                if (result2 == 1 && (keySet = this.currentSelector.selectedKeys()).iterator().next() == key2) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            finally {
                try {
                    if (key2 != null) {
                        key2.cancel();
                    }
                    if (this.currentSelector != null) {
                        this.currentSelector.selectNow();
                    }
                }
                catch (Exception e) {}
                try {
                    if (this.currentSelector != null) {
                        this.getRuntime().getSelectorPool().put(this.currentSelector);
                    }
                }
                catch (Exception e) {
                }
                finally {
                    this.currentSelector = null;
                }
                if (fptr != null) {
                    fptr.removeBlockingThread(this);
                }
                try {
                    selectable.configureBlocking(oldBlocking);
                }
                catch (Exception e) {}
                this.afterBlockingCall();
            }
        }
    }

    public synchronized void interrupt() {
        BlockingTask t;
        Unblocker task;
        BlockingIO.Condition iowait;
        this.setInterrupt();
        Selector activeSelector = this.currentSelector;
        if (activeSelector != null) {
            activeSelector.wakeup();
        }
        if ((iowait = this.blockingIO) != null) {
            iowait.cancel();
        }
        if ((task = this.unblockFunc) != null) {
            task.wakeup(this, this.unblockArg);
        }
        if ((t = this.currentBlockingTask) != null) {
            t.wakeup();
        }
        this.notify();
    }

    public void setInterrupt() {
        int oldFlag;
        while (!INTERRUPT_FLAG_UPDATER.compareAndSet(this, oldFlag = this.interruptFlag, oldFlag | 2)) {
        }
    }

    public boolean waitForIO(ThreadContext context, RubyIO io2, int ops) {
        Channel channel = io2.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        try {
            io2.addBlockingThread(this);
            this.blockingIO = BlockingIO.newCondition(channel, ops);
            boolean ready2 = this.blockingIO.await();
            this.pollThreadEvents();
            boolean bl = ready2;
            return bl;
        }
        catch (IOException ioe) {
            throw context.runtime.newRuntimeError("Error with selector: " + ioe);
        }
        catch (InterruptedException ex) {
            throw context.runtime.newRuntimeError("Interrupted");
        }
        finally {
            this.blockingIO = null;
            io2.removeBlockingThread(this);
        }
    }

    public void beforeBlockingCall() {
        this.pollThreadEvents();
        this.enterSleep();
    }

    public void afterBlockingCall() {
        this.exitSleep();
        this.pollThreadEvents();
    }

    private void receivedAnException(ThreadContext context, IRubyObject exception2) {
        RubyModule kernelModule = this.getRuntime().getKernel();
        RubyThread.debug(this, "before propagating exception");
        kernelModule.callMethod(context, "raise", exception2);
    }

    public boolean wait_timeout(IRubyObject o, Double timeout2) throws InterruptedException {
        if (timeout2 != null) {
            long end_ns;
            long delay_ns = (long)(timeout2 * 1.0E9);
            long start_ns = System.nanoTime();
            if (delay_ns > 0L) {
                long delay_ms = delay_ns / 1000000L;
                int delay_ns_remainder = (int)(delay_ns % 1000000L);
                this.executeBlockingTask(new SleepTask(o, delay_ms, delay_ns_remainder));
            }
            return (end_ns = System.nanoTime()) - start_ns <= delay_ns;
        }
        this.executeBlockingTask(new SleepTask(o, 0L, 0));
        return true;
    }

    public RubyThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyThread other = (RubyThread)obj;
        return this.threadImpl == other.threadImpl || this.threadImpl != null && this.threadImpl.equals(other.threadImpl);
    }

    @Override
    public int hashCode() {
        int hash2 = 3;
        hash2 = 97 * hash2 + (this.threadImpl != null ? this.threadImpl.hashCode() : 0);
        return hash2;
    }

    @Override
    public String toString() {
        return this.threadImpl.toString();
    }

    public void lock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.lock();
        this.heldLocks.add(lock2);
    }

    public void lockInterruptibly(Lock lock2) throws InterruptedException {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.lockInterruptibly();
        this.heldLocks.add(lock2);
    }

    public boolean tryLock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        boolean locked = lock2.tryLock();
        if (locked) {
            this.heldLocks.add(lock2);
        }
        return locked;
    }

    public void unlock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.unlock();
        this.heldLocks.remove(lock2);
    }

    public void unlockAll() {
        assert (Thread.currentThread() == this.getNativeThread());
        for (Lock lock2 : this.heldLocks) {
            lock2.unlock();
        }
    }

    private String identityString() {
        return "0x" + Integer.toHexString(System.identityHashCode(this));
    }

    @Deprecated
    public void internalRaise(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        this.genericRaise(runtime, args2, runtime.getCurrentContext().getThread());
    }

    @Deprecated
    public void receiveMail(ThreadService.Event event2) {
    }

    @Deprecated
    public void checkMail(ThreadContext context) {
    }

    @Deprecated
    public boolean selectForAccept(RubyIO io2) {
        return this.select(io2, 16);
    }

    private class SleepTask2
    implements Task<Object, Long> {
        final Semaphore semaphore = new Semaphore(1);
        long millis;

        private SleepTask2() {
            this.semaphore.drainPermits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long run(ThreadContext context, Object data2) throws InterruptedException {
            long start2 = System.currentTimeMillis();
            try {
                if (this.millis == 0L) {
                    this.semaphore.tryAcquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                } else {
                    this.semaphore.tryAcquire(this.millis, TimeUnit.MILLISECONDS);
                }
                Long l = System.currentTimeMillis() - start2;
                return l;
            }
            finally {
                this.semaphore.drainPermits();
            }
        }

        @Override
        public void wakeup(RubyThread thread2, Object data2) {
            this.semaphore.release();
        }
    }

    public static final class SleepTask
    implements BlockingTask {
        private final Object object;
        private final long millis;
        private final int nanos;

        public SleepTask(Object object, long millis, int nanos) {
            this.object = object;
            this.millis = millis;
            this.nanos = nanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws InterruptedException {
            Object object = this.object;
            synchronized (object) {
                this.object.wait(this.millis, this.nanos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wakeup() {
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
            }
        }
    }

    public static interface Task<Data, Return>
    extends Unblocker<Data> {
        public Return run(ThreadContext var1, Data var2) throws InterruptedException;

        @Override
        public void wakeup(RubyThread var1, Data var2);
    }

    public static interface Unblocker<Data> {
        public void wakeup(RubyThread var1, Data var2);
    }

    @Deprecated
    public static interface BlockingTask {
        public void run() throws InterruptedException;

        public void wakeup();
    }

    public static class Location
    extends RubyObject {
        private final RubyStackTraceElement element;

        public Location(Ruby runtime, RubyClass klass, RubyStackTraceElement element) {
            super(runtime, klass);
            this.element = element;
        }

        @JRubyMethod
        public IRubyObject absolute_path(ThreadContext context) {
            return context.runtime.newString(this.element.getFileName());
        }

        @JRubyMethod
        public IRubyObject base_label(ThreadContext context) {
            return context.runtime.newString(this.element.getMethodName());
        }

        @JRubyMethod
        public IRubyObject inspect(ThreadContext context) {
            return this.to_s(context).inspect();
        }

        @JRubyMethod
        public IRubyObject label(ThreadContext context) {
            return context.runtime.newString(this.element.getMethodName());
        }

        @JRubyMethod
        public IRubyObject lineno(ThreadContext context) {
            return context.runtime.newFixnum(this.element.getLineNumber());
        }

        @JRubyMethod
        public IRubyObject path(ThreadContext context) {
            return context.runtime.newString(this.element.getFileName());
        }

        @JRubyMethod
        public IRubyObject to_s(ThreadContext context) {
            return context.runtime.newString(this.element.mriStyleString());
        }

        public static IRubyObject newLocationArray(Ruby runtime, RubyStackTraceElement[] elements) {
            RubyArray ary = runtime.newArray(elements.length);
            for (RubyStackTraceElement element : elements) {
                ary.append(new Location(runtime, runtime.getLocation(), element));
            }
            return ary;
        }
    }

    public static enum Status {
        RUN,
        SLEEP,
        ABORTING,
        DEAD;

        public final ByteList bytes = new ByteList(this.toString().toLowerCase().getBytes(RubyEncoding.UTF8));
    }
}

