/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.io.CachedFile;

public class FontsManager {
    public static final Collection<String> INCLUDED_FONTS = Arrays.asList("DroidSans.ttf", "DroidSans-Bold.ttf");

    private FontsManager() {
    }

    public static void initialize() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : INCLUDED_FONTS) {
            String string2 = "resource://data/fonts/" + string;
            try {
                InputStream inputStream = new CachedFile(string2).getInputStream();
                Throwable throwable = null;
                try {
                    graphicsEnvironment.registerFont(Font.createFont(0, inputStream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (FontFormatException | IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

