/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class AddTagsDialog
extends ExtendedDialog {
    private final JTable propertyTable;
    private final transient Collection<? extends OsmPrimitive> sel;
    private final int[] count;
    private final String sender;
    private static final Set<String> trustedSenders = new HashSet<String>();

    public AddTagsDialog(String[][] stringArray, String string, Collection<? extends OsmPrimitive> collection) {
        super(Main.parent, I18n.tr("Add tags to selected objects", new Object[0]), new String[]{I18n.tr("Add selected tags", new Object[0]), I18n.tr("Add all tags", new Object[0]), I18n.tr("Cancel", new Object[0])}, false, true);
        Object object;
        this.setToolTipTexts(new String[]{I18n.tr("Add checked tags to selected objects", new Object[0]), I18n.tr("Shift+Enter: Add all tags to selected objects", new Object[0]), ""});
        this.sender = string;
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{I18n.tr("Assume", new Object[0]), I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0]), I18n.tr("Existing values", new Object[0])}, stringArray.length){
            private final Class<?>[] types;
            {
                this.types = new Class[]{Boolean.class, String.class, Object.class, ExistingValues.class};
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return this.types[n];
            }
        };
        this.sel = collection;
        this.count = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.count[i] = 0;
            object = stringArray[i][0];
            String string2 = stringArray[i][1];
            Boolean bl = Boolean.TRUE;
            ExistingValues existingValues = new ExistingValues((String)object);
            for (OsmPrimitive osmPrimitive : this.sel) {
                String string3 = osmPrimitive.get((String)object);
                if (string3 == null) continue;
                existingValues.addValue(string3);
                if (string3.equals(string2)) continue;
                bl = Boolean.FALSE;
                int n = i;
                this.count[n] = this.count[n] + 1;
            }
            defaultTableModel.setValueAt(bl, i, 0);
            defaultTableModel.setValueAt(stringArray[i][0], i, 1);
            defaultTableModel.setValueAt(stringArray[i][1].isEmpty() ? new DeleteTagMarker(this.count[i]) : stringArray[i][1], i, 2);
            defaultTableModel.setValueAt(existingValues, i, 3);
        }
        this.propertyTable = new JTable(defaultTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (AddTagsDialog.this.count[n] > 0) {
                    component.setFont(component.getFont().deriveFont(2));
                    component.setForeground(new Color(100, 100, 100));
                } else {
                    component.setFont(component.getFont().deriveFont(0));
                    component.setForeground(new Color(0, 0, 0));
                }
                return component;
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                Object object = this.getValueAt(n, n2);
                if (object instanceof DeleteTagMarker) {
                    return null;
                }
                if (object instanceof ExistingValues) {
                    return null;
                }
                return this.getDefaultEditor(object.getClass());
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                int n2 = this.columnAtPoint(mouseEvent.getPoint());
                Object object = this.getValueAt(n, n2);
                if (n2 == 1 || n2 == 2) {
                    return object.toString();
                }
                if (n2 == 3) {
                    return ((ExistingValues)object).getToolTip();
                }
                return I18n.tr("Enable the checkbox to accept the value", new Object[0]);
            }
        };
        this.propertyTable.setAutoResizeMode(3);
        this.propertyTable.getColumnModel().getColumn(0).setMaxWidth(15);
        TableHelper.adjustColumnWidth(this.propertyTable, 1, 150);
        TableHelper.adjustColumnWidth(this.propertyTable, 2, 400);
        TableHelper.adjustColumnWidth(this.propertyTable, 3, 300);
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertyTable.getInputMap().put(KeyStroke.getKeyStroke(10, 1), "shiftenter");
        this.propertyTable.getActionMap().put("shiftenter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTagsDialog.this.buttonAction(1, actionEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        if (!this.sender.isEmpty() && !trustedSenders.contains(this.sender)) {
            object = new JCheckBox();
            ((AbstractButton)object).setAction(new AbstractAction(I18n.tr("Accept all tags from {0} for this session", this.sender), (JCheckBox)object){
                final /* synthetic */ JCheckBox val$c;
                {
                    this.val$c = jCheckBox;
                    super(string);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$c.isSelected()) {
                        trustedSenders.add(AddTagsDialog.this.sender);
                    } else {
                        trustedSenders.remove(AddTagsDialog.this.sender);
                    }
                }
            });
            jPanel.add((Component)object, GBC.eol().insets(20, 10, 0, 0));
        }
        this.setContent(jPanel);
        this.setDefaultButton(2);
    }

    @Override
    protected void buttonAction(int n, ActionEvent actionEvent) {
        if (Main.main.getCurrentDataSet() != null && n != 2) {
            TableModel tableModel = this.propertyTable.getModel();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                if (n != 1 && !((Boolean)tableModel.getValueAt(i, 0)).booleanValue()) continue;
                String string = (String)tableModel.getValueAt(i, 1);
                Object object = tableModel.getValueAt(i, 2);
                Main.main.undoRedo.add(new ChangePropertyCommand(this.sel, string, object instanceof String ? (String)object : ""));
            }
        }
        if (n == 2) {
            trustedSenders.remove(this.sender);
        }
        this.setVisible(false);
    }

    public static void addTags(final Map<String, String> map, final String string, final Collection<? extends OsmPrimitive> collection) {
        if (map.containsKey("addtags")) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                @Override
                public void run() {
                    String[] stringArray = null;
                    stringArray = Utils.decodeUrl((String)map.get("addtags")).split("\\|");
                    HashSet<String> hashSet = new HashSet<String>();
                    for (String string22 : stringArray) {
                        if (string22.trim().isEmpty() || !string22.contains("=")) continue;
                        hashSet.add(string22.trim());
                    }
                    if (!hashSet.isEmpty()) {
                        String[] stringArray2 = new String[hashSet.size()][2];
                        int n = 0;
                        for (String string22 : hashSet) {
                            String[] stringArray3 = string22.split("\\s*=\\s*", 2);
                            stringArray2[n][0] = stringArray3[0];
                            stringArray2[n][1] = stringArray3.length < 2 ? "" : stringArray3[1];
                            ++n;
                        }
                        AddTagsDialog.addTags((String[][])stringArray2, string, (Collection<? extends OsmPrimitive>)collection);
                    }
                }
            });
        }
    }

    public static void addTags(String[][] stringArray, String string, Collection<? extends OsmPrimitive> collection) {
        if (trustedSenders.contains(string)) {
            if (Main.main.getCurrentDataSet() != null) {
                for (String[] stringArray2 : stringArray) {
                    Main.main.undoRedo.add(new ChangePropertyCommand(collection, stringArray2[0], stringArray2[1]));
                }
            }
        } else {
            new AddTagsDialog(stringArray, string, collection).showDialog();
        }
    }

    static class ExistingValues {
        private String tag;
        private Map<String, Integer> valueCount;

        public ExistingValues(String string) {
            this.tag = string;
            this.valueCount = new HashMap<String, Integer>();
        }

        int addValue(String string) {
            Integer n = this.valueCount.get(string);
            int n2 = n == null ? 1 : n + 1;
            this.valueCount.put(string, n2);
            return n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.valueCount.keySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        private String getToolTip() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(I18n.tr("Old values of", new Object[0]));
            stringBuilder.append(" <b>");
            stringBuilder.append(this.tag);
            stringBuilder.append("</b><br/>");
            for (Map.Entry<String, Integer> entry : this.valueCount.entrySet()) {
                stringBuilder.append("<b>");
                stringBuilder.append(entry.getValue());
                stringBuilder.append(" x </b>");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("<br/>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
    }

    static class DeleteTagMarker {
        private int num;

        public DeleteTagMarker(int n) {
            this.num = n;
        }

        public String toString() {
            return I18n.tr("<delete from {0} objects>", this.num);
        }
    }
}

