/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayerImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("wms", "wms", I18n.tr("WMS Files (*.wms)", new Object[0]));
    private final WMSLayer wmsLayer;

    public WMSLayerImporter() {
        this(new WMSLayer());
    }

    public WMSLayerImporter(WMSLayer wMSLayer) {
        super(FILE_FILTER);
        this.wmsLayer = wMSLayer;
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));){
            this.wmsLayer.readExternal(objectInputStream);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalDataException(classNotFoundException);
        }
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                Main.main.addLayer(WMSLayerImporter.this.wmsLayer);
                WMSLayerImporter.this.wmsLayer.onPostLoadFromFile();
            }
        });
    }

    public final WMSLayer getWmsLayer() {
        return this.wmsLayer;
    }
}

