/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NoteWriter
extends XmlWriter {
    private final DateFormat ISO8601_FORMAT = DateUtils.newIsoDateTimeFormat();

    public NoteWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    public NoteWriter(OutputStream outputStream) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8))));
    }

    public void write(NoteData noteData) {
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.println("<osm-notes>");
        for (Note note : noteData.getNotes()) {
            this.out.print("  <note ");
            this.out.print("id=\"" + note.getId() + "\" ");
            this.out.print("lat=\"" + note.getLatLon().lat() + "\" ");
            this.out.print("lon=\"" + note.getLatLon().lon() + "\" ");
            this.out.print("created_at=\"" + this.ISO8601_FORMAT.format(note.getCreatedAt()) + "\" ");
            if (note.getClosedAt() != null) {
                this.out.print("closed_at=\"" + this.ISO8601_FORMAT.format(note.getClosedAt()) + "\" ");
            }
            this.out.println(">");
            for (NoteComment noteComment : note.getComments()) {
                this.writeComment(noteComment);
            }
            this.out.println("  </note>");
        }
        this.out.println("</osm-notes>");
        this.out.flush();
    }

    private void writeComment(NoteComment noteComment) {
        this.out.print("    <comment");
        this.out.print(" action=\"" + (Object)((Object)noteComment.getNoteAction()) + "\" ");
        this.out.print("timestamp=\"" + this.ISO8601_FORMAT.format(noteComment.getCommentTimestamp()) + "\" ");
        if (noteComment.getUser() != null && !noteComment.getUser().equals(User.getAnonymous())) {
            this.out.print("uid=\"" + noteComment.getUser().getId() + "\" ");
            this.out.print("user=\"" + NoteWriter.encode(noteComment.getUser().getName()) + "\" ");
        }
        this.out.print("is_new=\"" + noteComment.getIsNew() + "\" ");
        this.out.print(">");
        this.out.print(NoteWriter.encode(noteComment.getText(), false));
        this.out.println("</comment>");
    }
}

