/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class NoteImporter
extends FileImporter {
    private static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("osn,osn.bz2", "osn", I18n.tr("Note Files", new Object[0]) + " (*.osn *.osn.bz2)");

    public NoteImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(final File file, ProgressMonitor progressMonitor) throws IOException {
        if (Main.isDebugEnabled()) {
            Main.debug("importing notes file " + file.getAbsolutePath());
        }
        try (InputStream inputStream = Compression.getUncompressedFileInputStream(file);){
            final List<Note> list = new NoteReader(inputStream).parse();
            List<NoteLayer> list2 = null;
            if (Main.map != null) {
                list2 = Main.map.mapView.getLayersOfType(NoteLayer.class);
            }
            if (list2 != null && !list2.isEmpty()) {
                list2.get(0).getNoteData().addNotes(list);
            } else {
                GuiHelper.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.addLayer(new NoteLayer(list, file.getName()));
                    }
                });
            }
        }
        catch (SAXException sAXException) {
            Main.error("error opening up notes file");
            Main.error(sAXException, true);
            throw new IOException(sAXException.getMessage(), sAXException);
        }
    }
}

