/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class AutoCompletionList
extends AbstractTableModel {
    private transient List<AutoCompletionListItem> list = new ArrayList<AutoCompletionListItem>();
    private transient ArrayList<AutoCompletionListItem> filtered = new ArrayList();
    private String filter = null;
    private transient Map<String, AutoCompletionListItem> valutToItemMap = new HashMap<String, AutoCompletionListItem>();

    public void applyFilter(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "filter");
        this.filter = string;
        this.filter();
    }

    public void clearFilter() {
        this.filter = null;
        this.filter();
    }

    public String getFilter() {
        return this.filter;
    }

    public void add(AutoCompletionListItem autoCompletionListItem) {
        if (autoCompletionListItem == null) {
            return;
        }
        this.appendOrUpdatePriority(autoCompletionListItem);
        this.sort();
        this.filter();
    }

    public void add(AutoCompletionList autoCompletionList) {
        CheckParameterUtil.ensureParameterNotNull(autoCompletionList, "other");
        for (AutoCompletionListItem autoCompletionListItem : autoCompletionList.list) {
            this.appendOrUpdatePriority(autoCompletionListItem);
        }
        this.sort();
        this.filter();
    }

    public void add(List<AutoCompletionListItem> list) {
        CheckParameterUtil.ensureParameterNotNull(list, "other");
        for (AutoCompletionListItem autoCompletionListItem : list) {
            this.appendOrUpdatePriority(autoCompletionListItem);
        }
        this.sort();
        this.filter();
    }

    public void add(Collection<String> collection, AutoCompletionItemPriority autoCompletionItemPriority) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            if (string == null) continue;
            AutoCompletionListItem autoCompletionListItem = new AutoCompletionListItem(string, autoCompletionItemPriority);
            this.appendOrUpdatePriority(autoCompletionListItem);
        }
        this.sort();
        this.filter();
    }

    public void addUserInput(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        int n = 0;
        for (String string : collection) {
            if (string == null) continue;
            AutoCompletionListItem autoCompletionListItem = new AutoCompletionListItem(string, new AutoCompletionItemPriority(false, false, false, n));
            this.appendOrUpdatePriority(autoCompletionListItem);
            ++n;
        }
        this.sort();
        this.filter();
    }

    protected void appendOrUpdatePriority(AutoCompletionListItem autoCompletionListItem) {
        AutoCompletionListItem autoCompletionListItem2 = this.valutToItemMap.get(autoCompletionListItem.getValue());
        if (autoCompletionListItem2 == null) {
            this.list.add(autoCompletionListItem);
            this.valutToItemMap.put(autoCompletionListItem.getValue(), autoCompletionListItem);
        } else {
            autoCompletionListItem2.setPriority(autoCompletionListItem2.getPriority().mergeWith(autoCompletionListItem.getPriority()));
        }
    }

    public boolean contains(AutoCompletionListItem autoCompletionListItem) {
        if (autoCompletionListItem == null) {
            return false;
        }
        return this.list.contains(autoCompletionListItem);
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        for (AutoCompletionListItem autoCompletionListItem : this.list) {
            if (!autoCompletionListItem.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void remove(String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            AutoCompletionListItem autoCompletionListItem = this.list.get(i);
            if (!autoCompletionListItem.getValue().equals(string)) continue;
            this.list.remove(i);
            return;
        }
    }

    protected void sort() {
        Collections.sort(this.list);
    }

    protected void filter() {
        this.filtered.clear();
        if (this.filter == null) {
            this.filtered.ensureCapacity(this.list.size());
            for (AutoCompletionListItem autoCompletionListItem : this.list) {
                this.filtered.add(autoCompletionListItem);
            }
            return;
        }
        for (AutoCompletionListItem autoCompletionListItem : this.list) {
            if (!autoCompletionListItem.getValue().startsWith(this.filter)) continue;
            this.filtered.add(autoCompletionListItem);
        }
        this.fireTableDataChanged();
    }

    public int getFilteredSize() {
        return this.filtered.size();
    }

    public AutoCompletionListItem getFilteredItem(int n) {
        if (n < 0 || n >= this.getFilteredSize()) {
            throw new IndexOutOfBoundsException("idx out of bounds. idx=" + n);
        }
        return this.filtered.get(n);
    }

    List<AutoCompletionListItem> getList() {
        return this.list;
    }

    List<AutoCompletionListItem> getUnmodifiableList() {
        return Collections.unmodifiableList(this.list);
    }

    public void clear() {
        this.valutToItemMap.clear();
        this.list.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.list == null ? 0 : this.getFilteredSize();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.list == null ? null : this.getFilteredItem(n);
    }
}

