/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.gui.widgets.JosmTextField;

public class AutoCompletingTextField
extends JosmTextField
implements ComboBoxEditor,
TableCellEditor {
    private Integer maxChars;
    protected AutoCompletionList autoCompletionList = null;
    protected String noAutoCompletionString = null;
    private transient CellEditorSupport tableCellEditorSupport;
    private String originalValue;

    @Override
    protected Document createDefaultModel() {
        return new AutoCompletionDocument();
    }

    protected final void init() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AutoCompletingTextField.this.selectAll();
                AutoCompletingTextField.this.applyFilter(AutoCompletingTextField.this.getText());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (AutoCompletingTextField.this.getText().isEmpty()) {
                    AutoCompletingTextField.this.applyFilter("");
                }
            }
        });
        this.tableCellEditorSupport = new CellEditorSupport(this);
    }

    public AutoCompletingTextField() {
        this(0);
    }

    public AutoCompletingTextField(int n) {
        this(n, true);
    }

    public AutoCompletingTextField(int n, boolean bl) {
        super(null, null, n, bl);
        this.init();
    }

    protected void applyFilter(String string) {
        if (this.autoCompletionList != null) {
            this.autoCompletionList.applyFilter(string);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        return this.getText();
    }

    @Override
    public void setItem(Object object) {
        if (object == null) {
            this.setText("");
        } else {
            this.setText(object.toString());
        }
    }

    @Override
    public void setText(String string) {
        this.noAutoCompletionString = string;
        super.setText(string);
    }

    public void setMaxChars(Integer n) {
        this.maxChars = n;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.tableCellEditorSupport.addCellEditorListener(cellEditorListener);
    }

    protected void rememberOriginalValue(String string) {
        this.originalValue = string;
    }

    protected void restoreOriginalValue() {
        this.setText(this.originalValue);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.tableCellEditorSupport.removeCellEditorListener(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.restoreOriginalValue();
        this.tableCellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.tableCellEditorSupport.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setText(object == null ? "" : object.toString());
        this.rememberOriginalValue(this.getText());
        return this;
    }

    class AutoCompletionDocument
    extends PlainDocument {
        AutoCompletionDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (AutoCompletingTextField.this.maxChars != null && string != null && this.getLength() + string.length() > AutoCompletingTextField.this.maxChars) {
                int n2 = AutoCompletingTextField.this.maxChars - this.getLength();
                if (n2 > 0) {
                    string = string.substring(0, n2);
                } else {
                    return;
                }
            }
            if (AutoCompletingTextField.this.autoCompletionList == null) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (n < this.getLength()) {
                super.insertString(n, string, attributeSet);
                return;
            }
            String string2 = this.getText(0, this.getLength());
            if (Main.pref.getBoolean("autocomplete.dont_complete_numbers", true)) {
                try {
                    Long.parseLong(string);
                    if (string2.length() == 0) {
                        super.insertString(n, string, attributeSet);
                        return;
                    }
                    Long.parseLong(string2);
                    super.insertString(n, string, attributeSet);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String string3 = string2.substring(0, n);
            AutoCompletingTextField.this.autoCompletionList.applyFilter(string3 + string);
            if (AutoCompletingTextField.this.autoCompletionList.getFilteredSize() > 0 && !Objects.equals(string, AutoCompletingTextField.this.noAutoCompletionString)) {
                String string4 = AutoCompletingTextField.this.autoCompletionList.getFilteredItem(0).getValue();
                this.remove(0, this.getLength());
                super.insertString(0, string4, attributeSet);
                AutoCompletingTextField.this.setCaretPosition(n + string.length());
                AutoCompletingTextField.this.moveCaretPosition(this.getLength());
            } else {
                String string5 = string3 + string;
                this.remove(0, this.getLength());
                super.insertString(0, string5, attributeSet);
                AutoCompletingTextField.this.setCaretPosition(this.getLength());
            }
        }
    }
}

