/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.TaggingPresets;

public final class TaggingPresetNameTemplateList
implements TaggingPresetListener {
    private static TaggingPresetNameTemplateList instance;
    private final List<TaggingPreset> presetsWithPattern = new LinkedList<TaggingPreset>();

    public static synchronized TaggingPresetNameTemplateList getInstance() {
        if (instance == null) {
            instance = new TaggingPresetNameTemplateList();
            TaggingPresets.addListener(instance);
        }
        return instance;
    }

    private TaggingPresetNameTemplateList() {
        this.buildPresetsWithPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPresetsWithPattern() {
        TaggingPresetNameTemplateList taggingPresetNameTemplateList = this;
        synchronized (taggingPresetNameTemplateList) {
            Main.debug("Building list of presets with name template");
            this.presetsWithPattern.clear();
            for (TaggingPreset taggingPreset : TaggingPresets.getTaggingPresets()) {
                if (taggingPreset.nameTemplate == null) continue;
                this.presetsWithPattern.add(taggingPreset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaggingPreset findPresetTemplate(OsmPrimitive osmPrimitive) {
        TaggingPresetNameTemplateList taggingPresetNameTemplateList = this;
        synchronized (taggingPresetNameTemplateList) {
            for (TaggingPreset taggingPreset : this.presetsWithPattern) {
                Set<TaggingPresetType> set;
                if (!taggingPreset.typeMatches(set = Collections.singleton(TaggingPresetType.forPrimitive(osmPrimitive)))) continue;
                if (taggingPreset.nameTemplateFilter != null) {
                    if (!taggingPreset.nameTemplateFilter.match(osmPrimitive)) continue;
                    return taggingPreset;
                }
                if (!taggingPreset.matches(set, osmPrimitive.getKeys(), false)) continue;
                return taggingPreset;
            }
        }
        return null;
    }

    @Override
    public void taggingPresetsModified() {
        this.buildPresetsWithPattern();
    }
}

