/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.dialogs.relation.RunnableAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.TextTagParser;
import org.openstreetmap.josm.tools.Utils;

public class TagTable
extends JTable {
    private TagCellEditor editor = null;
    private final TagEditorModel model;
    private Component nextFocusComponent;
    private final CopyOnWriteArrayList<Component> doNotStopCellEditingWhenFocused = new CopyOnWriteArrayList();
    private transient CellEditorRemover editorRemover;
    private RunnableAction deleteAction = null;
    private RunnableAction addAction = null;
    private RunnableAction pasteAction = null;

    public RunnableAction getDeleteAction() {
        return this.deleteAction;
    }

    public RunnableAction getAddAction() {
        return this.addAction;
    }

    public RunnableAction getPasteAction() {
        return this.pasteAction;
    }

    protected final void init() {
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(1);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 2), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.pasteAction = new PasteAction();
        TagCellEditor tagCellEditor = new TagCellEditor();
        this.setRowHeight(tagCellEditor.getEditor().getPreferredSize().height);
        this.setTagCellEditor(tagCellEditor);
    }

    public TagTable(TagEditorModel tagEditorModel) {
        super(tagEditorModel, new TagTableColumnModel(tagEditorModel.getColumnSelectionModel()), tagEditorModel.getRowSelectionModel());
        this.model = tagEditorModel;
        this.init();
    }

    @Override
    public Dimension getPreferredSize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        if (container != null) {
            Dimension dimension = super.getPreferredSize();
            dimension.width = container.getSize().width;
            return dimension;
        }
        return super.getPreferredSize();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyCode() == 127) {
            if (this.isEditing() && this.getSelectedColumnCount() == 1 && this.getSelectedRowCount() == 1) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            this.getDeleteAction().run();
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionManager(AutoCompletionManager autoCompletionManager) {
        if (autoCompletionManager == null) {
            Main.warn("argument autocomplete should not be null. Aborting.");
            Thread.dumpStack();
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionManager(autoCompletionManager);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public void setNextFocusComponent(Component component) {
        this.nextFocusComponent = component;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void addOKAccelatorListener(KeyListener keyListener) {
        this.addKeyListener(keyListener);
        if (this.editor != null) {
            this.editor.getEditor().addKeyListener(keyListener);
        }
    }

    public void setTagCellEditor(TagCellEditor tagCellEditor) {
        if (this.isEditing()) {
            this.editor.cancelCellEditing();
        }
        this.editor = tagCellEditor;
        this.getColumnModel().getColumn(0).setCellEditor(tagCellEditor);
        this.getColumnModel().getColumn(1).setCellEditor(tagCellEditor);
    }

    public void requestFocusInCell(int n, int n2) {
        this.changeSelection(n, n2, false, false);
        this.editCellAt(n, n2);
        Component component = this.getEditorComponent();
        if (component != null) {
            component.requestFocusInWindow();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).selectAll();
            }
        }
    }

    public void addComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.addIfAbsent(component);
    }

    public void removeComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.remove(component);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        return super.editCellAt(n, n2, eventObject);
    }

    @Override
    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeEditor();
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        private KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!TagTable.this.isEditing()) {
                return;
            }
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == TagTable.this) {
                    return;
                }
                if (TagTable.this.doNotStopCellEditingWhenFocused.contains(component)) {
                    return;
                }
                if (!(component instanceof Window)) continue;
                if (component != SwingUtilities.getRoot(TagTable.this) || TagTable.this.getCellEditor().stopCellEditing()) break;
                TagTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    class PasteAction
    extends RunnableAction
    implements PropertyChangeListener {
        public PasteAction() {
            this.putValue("SmallIcon", ImageProvider.get("", "pastetags"));
            this.putValue("ShortDescription", I18n.tr("Paste tags from buffer", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void run() {
            Relation relation = new Relation();
            TagTable.this.model.applyToPrimitive(relation);
            String string = Utils.getClipboardContent();
            if (string == null || string.isEmpty() || string.matches("((node|way|relation)\\s\\d+,)*(node|way|relation)\\s\\d+")) {
                List<PrimitiveData> list = Main.pasteBuffer.getDirectlyAdded();
                if (list == null || list.isEmpty()) {
                    return;
                }
                PasteTagsAction.TagPaster tagPaster = new PasteTagsAction.TagPaster(list, Collections.singletonList(relation));
                TagTable.this.model.updateTags(tagPaster.execute());
            } else {
                Map<String, String> map = TextTagParser.readTagsFromText(string);
                if (map == null || map.isEmpty()) {
                    TextTagParser.showBadBufferMessage(HelpUtil.ht("/Action/PasteTags"));
                } else if (TextTagParser.validateTags(map)) {
                    ArrayList<Tag> arrayList = new ArrayList<Tag>();
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        String string2 = entry.getKey();
                        String string3 = entry.getValue();
                        arrayList.add(new Tag(string2, string3));
                    }
                    TagTable.this.model.updateTags(arrayList);
                }
            }
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends RunnableAction
    implements PropertyChangeListener {
        public AddAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.putValue("ShortDescription", I18n.tr("Add a new tag", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void run() {
            TableCellEditor tableCellEditor = TagTable.this.getCellEditor();
            if (tableCellEditor != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            int n = TagTable.this.model.getRowCount() - 1;
            String string = ((TagModel)TagTable.this.model.getValueAt(n, 0)).getName();
            if (!string.trim().isEmpty()) {
                TagTable.this.model.appendNewTag();
            }
            TagTable.this.requestFocusInCell(TagTable.this.model.getRowCount() - 1, 0);
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends RunnableAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table", new Object[0]));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.updateEnabledState();
        }

        protected void deleteTagNames() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagNames(nArray);
        }

        protected void deleteTagValues() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagValues(nArray);
        }

        protected void deleteTags() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTags(nArray);
        }

        @Override
        public void run() {
            TableCellEditor tableCellEditor;
            if (!this.isEnabled()) {
                return;
            }
            switch (TagTable.this.getSelectedColumnCount()) {
                case 1: {
                    if (TagTable.this.getSelectedColumn() == 0) {
                        this.deleteTagNames();
                        break;
                    }
                    if (TagTable.this.getSelectedColumn() != 1) break;
                    this.deleteTagValues();
                    break;
                }
                case 2: {
                    this.deleteTags();
                }
            }
            if (TagTable.this.isEditing() && (tableCellEditor = TagTable.this.getCellEditor()) != null) {
                tableCellEditor.cancelCellEditing();
            }
            if (TagTable.this.model.getRowCount() == 0) {
                TagTable.this.model.ensureOneTag();
                TagTable.this.requestFocusInCell(0, 0);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            if (TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (!TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (TagTable.this.getSelectedColumnCount() > 1 || TagTable.this.getSelectedRowCount() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n > 0 || n2 > 0) {
                if (n == 1) {
                    --n;
                } else {
                    n = 1;
                    --n2;
                }
            }
            TagTable.this.requestFocusInCell(n2, n);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n2 == -1 && n == -1) {
                TagTable.this.requestFocusInCell(0, 0);
                return;
            }
            if (n == 0) {
                ++n;
            } else if (n == 1 && n2 < TagTable.this.getRowCount() - 1) {
                n = 0;
                ++n2;
            } else if (n == 1 && n2 == TagTable.this.getRowCount() - 1) {
                String string = ((TagModel)TagTable.this.model.getValueAt(n2, 0)).getName();
                if (!string.trim().isEmpty()) {
                    TagTable.this.model.appendNewTag();
                    n = 0;
                    ++n2;
                } else {
                    TagTable.this.clearSelection();
                    if (TagTable.this.nextFocusComponent != null) {
                        TagTable.this.nextFocusComponent.requestFocusInWindow();
                    }
                    return;
                }
            }
            TagTable.this.requestFocusInCell(n2, n);
        }
    }

    static class TagTableColumnModel
    extends DefaultTableColumnModel {
        public TagTableColumnModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.setSelectionModel(defaultListSelectionModel);
            TableColumn tableColumn = null;
            TagCellRenderer tagCellRenderer = new TagCellRenderer();
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Key", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(tagCellRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("Value", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(tagCellRenderer);
            this.addColumn(tableColumn);
        }
    }
}

