/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.PresetHandler;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagTable;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagEditorPanel
extends JPanel {
    private TagEditorModel model;
    private TagTable tagTable;
    private PresetListPanel presetListPanel;
    private final transient PresetHandler presetHandler;

    protected JPanel buildTagTableEditorPanel() {
        JPanel jPanel = new JPanel();
        this.tagTable = new TagTable(this.model);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.tagTable), "Center");
        if (this.presetHandler != null) {
            this.presetListPanel = new PresetListPanel();
            jPanel.add((Component)this.presetListPanel, "North");
        }
        return jPanel;
    }

    public void setNextFocusComponent(Component component) {
        this.tagTable.setNextFocusComponent(component);
    }

    protected JPanel buildButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JButton jButton = new JButton(this.tagTable.getAddAction());
        jPanel.add(jButton);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(jButton);
        jButton = new JButton(this.tagTable.getDeleteAction());
        jPanel.add(jButton);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(jButton);
        jButton = new JButton(this.tagTable.getPasteAction());
        jPanel.add(jButton);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(jButton);
        return jPanel;
    }

    public AbstractAction getPasteAction() {
        return this.tagTable.getPasteAction();
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = this.buildTagTableEditorPanel();
        JPanel jPanel2 = this.buildButtonsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        this.add((Component)jPanel, gridBagConstraints);
        if (this.presetHandler != null) {
            this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    TagEditorPanel.this.updatePresets();
                }
            });
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TagEditorPanel.this.tagTable.requestFocusInCell(0, 0);
            }
        });
    }

    public TagEditorPanel(PresetHandler presetHandler) {
        this(null, presetHandler);
    }

    public TagEditorPanel(TagEditorModel tagEditorModel, PresetHandler presetHandler) {
        this.model = tagEditorModel;
        this.presetHandler = presetHandler;
        if (this.model == null) {
            this.model = new TagEditorModel();
        }
        this.build();
    }

    public TagEditorModel getModel() {
        return this.model;
    }

    public void initAutoCompletion(OsmDataLayer osmDataLayer) {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        AutoCompletionManager autoCompletionManager = osmDataLayer.data.getAutoCompletionManager();
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        TagCellEditor tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(0).getCellEditor();
        tagCellEditor.setAutoCompletionManager(autoCompletionManager);
        tagCellEditor.setAutoCompletionList(autoCompletionList);
        tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(1).getCellEditor();
        tagCellEditor.setAutoCompletionManager(autoCompletionManager);
        tagCellEditor.setAutoCompletionList(autoCompletionList);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.tagTable.setEnabled(bl);
        super.setEnabled(bl);
    }

    private void updatePresets() {
        this.presetListPanel.updatePresets(EnumSet.of(TaggingPresetType.RELATION), this.model.getTags(), this.presetHandler);
        this.validate();
    }
}

