/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TagEditorModel
extends AbstractTableModel {
    public static final String PROP_DIRTY = TagEditorModel.class.getName() + ".dirty";
    protected final transient List<TagModel> tags = new ArrayList<TagModel>();
    private boolean dirty = false;
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private DefaultListSelectionModel rowSelectionModel;
    private DefaultListSelectionModel colSelectionModel;

    public TagEditorModel() {
        this.rowSelectionModel = new DefaultListSelectionModel();
        this.colSelectionModel = new DefaultListSelectionModel();
    }

    public TagEditorModel(DefaultListSelectionModel defaultListSelectionModel, DefaultListSelectionModel defaultListSelectionModel2) {
        CheckParameterUtil.ensureParameterNotNull(defaultListSelectionModel, "rowSelectionModel");
        CheckParameterUtil.ensureParameterNotNull(defaultListSelectionModel2, "colSelectionModel");
        this.rowSelectionModel = defaultListSelectionModel;
        this.colSelectionModel = defaultListSelectionModel2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public DefaultListSelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    public DefaultListSelectionModel getColumnSelectionModel() {
        return this.colSelectionModel;
    }

    public void removeProperyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireDirtyStateChanged(boolean bl, boolean bl2) {
        this.propChangeSupport.firePropertyChange(PROP_DIRTY, bl, bl2);
    }

    protected void setDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (bl2 != bl) {
            this.fireDirtyStateChanged(bl2, bl);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("unexpected rowIndex: rowIndex=" + n);
        }
        TagModel tagModel = this.tags.get(n);
        switch (n2) {
            case 0: 
            case 1: {
                return tagModel;
            }
        }
        throw new IndexOutOfBoundsException("unexpected columnIndex: columnIndex=" + n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        TagModel tagModel = this.get(n);
        if (tagModel == null) {
            return;
        }
        switch (n2) {
            case 0: {
                this.updateTagName(tagModel, (String)object);
                break;
            }
            case 1: {
                String string = (String)object;
                if (tagModel.getValueCount() > 1 && !string.isEmpty()) {
                    this.updateTagValue(tagModel, string);
                    break;
                }
                if (tagModel.getValueCount() > 1) break;
                this.updateTagValue(tagModel, string);
            }
        }
    }

    public void clear() {
        this.tags.clear();
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(TagModel tagModel) {
        CheckParameterUtil.ensureParameterNotNull(tagModel, "tag");
        this.tags.add(tagModel);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void prepend(TagModel tagModel) {
        CheckParameterUtil.ensureParameterNotNull(tagModel, "tag");
        this.tags.add(0, tagModel);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(String string, String string2) {
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        TagModel tagModel = this.get(string);
        if (tagModel == null) {
            int n;
            tagModel = new TagModel(string, string2);
            for (n = this.tags.size(); n >= 1 && this.tags.get(n - 1).getName().isEmpty() && this.tags.get(n - 1).getValue().isEmpty(); --n) {
            }
            this.tags.add(n, tagModel);
        } else {
            tagModel.addValue(string2);
        }
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public TagModel get(String string) {
        string = string == null ? "" : string;
        for (TagModel tagModel : this.tags) {
            if (!tagModel.getName().equals(string)) continue;
            return tagModel;
        }
        return null;
    }

    public TagModel get(int n) {
        if (n >= this.tags.size()) {
            return null;
        }
        return this.tags.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void deleteTagNames(int[] nArray) {
        if (this.tags == null) {
            return;
        }
        for (int n : nArray) {
            TagModel tagModel = this.tags.get(n);
            if (tagModel == null) continue;
            tagModel.setName("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void deleteTagValues(int[] nArray) {
        if (this.tags == null) {
            return;
        }
        for (int n : nArray) {
            TagModel tagModel = this.tags.get(n);
            if (tagModel == null) continue;
            tagModel.setValue("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void delete(String string) {
        if (string == null) {
            return;
        }
        Iterator<TagModel> iterator = this.tags.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            TagModel tagModel = iterator.next();
            if (!tagModel.getName().equals(string)) continue;
            bl = true;
            iterator.remove();
        }
        if (bl) {
            this.fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void deleteTags(int[] nArray) {
        if (this.tags == null) {
            return;
        }
        ArrayList<TagModel> arrayList = new ArrayList<TagModel>();
        for (int n : nArray) {
            TagModel tagModel = this.tags.get(n);
            if (tagModel == null) continue;
            arrayList.add(tagModel);
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            TagModel tagModel = (TagModel)object.next();
            this.tags.remove(tagModel);
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void appendNewTag() {
        TagModel tagModel = new TagModel();
        this.tags.add(tagModel);
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void ensureOneTag() {
        if (this.tags.isEmpty()) {
            this.appendNewTag();
        }
    }

    public void initFromPrimitive(Tagged tagged) {
        this.tags.clear();
        for (String string : tagged.keySet()) {
            String string2 = tagged.get(string);
            this.tags.add(new TagModel(string, string2));
        }
        TagModel tagModel = new TagModel();
        this.sort();
        this.tags.add(tagModel);
        this.setDirty(false);
        this.fireTableDataChanged();
    }

    public void initFromTags(Map<String, String> map) {
        this.tags.clear();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.tags.add(new TagModel(entry.getKey(), entry.getValue()));
        }
        this.sort();
        TagModel tagModel = new TagModel();
        this.tags.add(tagModel);
        this.setDirty(false);
    }

    public void initFromTags(TagCollection tagCollection) {
        this.tags.clear();
        if (tagCollection == null) {
            this.setDirty(false);
            return;
        }
        for (String string : tagCollection.getKeys()) {
            String string2 = tagCollection.getJoinedValues(string);
            this.tags.add(new TagModel(string, string2));
        }
        this.sort();
        TagModel tagModel = new TagModel();
        this.tags.add(tagModel);
        this.setDirty(false);
    }

    public void applyToPrimitive(Tagged tagged) {
        Map<String, String> map = tagged.getKeys();
        this.applyToTags(map, false);
        tagged.setKeys(map);
    }

    public void applyToTags(Map<String, String> map, boolean bl) {
        map.clear();
        for (TagModel tagModel : this.tags) {
            if (tagModel.getValueCount() > 1 || !bl && (tagModel.getName().trim().isEmpty() || tagModel.getValue().trim().isEmpty())) continue;
            map.put(tagModel.getName().trim(), tagModel.getValue().trim());
        }
    }

    public Map<String, String> getTags() {
        return this.getTags(false);
    }

    public Map<String, String> getTags(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.applyToTags(hashMap, bl);
        return hashMap;
    }

    public TagCollection getTagCollection() {
        return TagCollection.from(this.getTags());
    }

    public boolean includesTag(String string) {
        if (string == null) {
            return false;
        }
        for (TagModel tagModel : this.tags) {
            if (!tagModel.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected Command createUpdateTagCommand(Collection<OsmPrimitive> collection, TagModel tagModel) {
        if (tagModel.getValueCount() > 1) {
            return null;
        }
        if (tagModel.getName().trim().isEmpty()) {
            return null;
        }
        return new ChangePropertyCommand(collection, tagModel.getName(), tagModel.getValue());
    }

    protected Command createDeleteTagsCommand(Collection<OsmPrimitive> collection) {
        List<String> list = this.getKeys();
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (OsmPrimitive osmPrimitive : collection) {
            for (String string : osmPrimitive.keySet()) {
                if (list.contains(string)) continue;
                ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand(osmPrimitive, string, null);
                arrayList.add(changePropertyCommand);
            }
        }
        return new SequenceCommand(I18n.trn("Remove old keys from up to {0} object", "Remove old keys from up to {0} objects", collection.size(), collection.size()), arrayList);
    }

    public List<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TagModel tagModel : this.tags) {
            if (tagModel.getName().trim().isEmpty()) continue;
            arrayList.add(tagModel.getName());
        }
        return arrayList;
    }

    protected void sort() {
        Collections.sort(this.tags, new Comparator<TagModel>(){

            @Override
            public int compare(TagModel tagModel, TagModel tagModel2) {
                return tagModel.getName().compareTo(tagModel2.getName());
            }
        });
    }

    public void updateTagName(TagModel tagModel, String string) {
        String string2 = tagModel.getName();
        tagModel.setName(string);
        if (!string.equals(string2)) {
            this.setDirty(true);
        }
        SelectionStateMemento selectionStateMemento = new SelectionStateMemento();
        this.fireTableDataChanged();
        selectionStateMemento.apply();
    }

    public void updateTagValue(TagModel tagModel, String string) {
        String string2 = tagModel.getValue();
        tagModel.setValue(string);
        if (!string.equals(string2)) {
            this.setDirty(true);
        }
        SelectionStateMemento selectionStateMemento = new SelectionStateMemento();
        this.fireTableDataChanged();
        selectionStateMemento.apply();
    }

    public void updateTags(List<Tag> list) {
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, TagModel> hashMap = new HashMap<String, TagModel>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            TagModel object = this.get(i);
            hashMap.put(object.getName(), object);
        }
        for (Tag tag : list) {
            TagModel tagModel = (TagModel)hashMap.get(tag.getKey());
            if (tag.getValue().isEmpty()) {
                if (tagModel == null) continue;
                this.delete(tag.getKey());
                continue;
            }
            if (tagModel != null) {
                this.updateTagValue(tagModel, tag.getValue());
                continue;
            }
            this.add(tag.getKey(), tag.getValue());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    class SelectionStateMemento {
        private int rowMin;
        private int rowMax;
        private int colMin;
        private int colMax;

        public SelectionStateMemento() {
            this.rowMin = TagEditorModel.this.rowSelectionModel.getMinSelectionIndex();
            this.rowMax = TagEditorModel.this.rowSelectionModel.getMaxSelectionIndex();
            this.colMin = TagEditorModel.this.colSelectionModel.getMinSelectionIndex();
            this.colMax = TagEditorModel.this.colSelectionModel.getMaxSelectionIndex();
        }

        public void apply() {
            TagEditorModel.this.rowSelectionModel.setValueIsAdjusting(true);
            TagEditorModel.this.colSelectionModel.setValueIsAdjusting(true);
            if (this.rowMin >= 0 && this.rowMax >= 0) {
                TagEditorModel.this.rowSelectionModel.setSelectionInterval(this.rowMin, this.rowMax);
            }
            if (this.colMin >= 0 && this.colMax >= 0) {
                TagEditorModel.this.colSelectionModel.setSelectionInterval(this.colMin, this.colMax);
            }
            TagEditorModel.this.rowSelectionModel.setValueIsAdjusting(false);
            TagEditorModel.this.colSelectionModel.setValueIsAdjusting(false);
        }
    }
}

