/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class FeaturesPanel
extends JPanel {
    private JCheckBox notifier;
    private JLabel intervalLabel;
    private final JosmTextField notifierInterval = new JosmTextField(4);
    private final JosmTextField notesDaysClosed = new JosmTextField(4);

    public FeaturesPanel() {
        this.build();
        this.initFromPreferences();
        this.updateEnabledState();
    }

    private void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.notifier = new JCheckBox(I18n.tr("Periodically check for new messages", new Object[0]));
        this.add((Component)this.notifier, GBC.eol());
        this.notifier.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FeaturesPanel.this.updateEnabledState();
            }
        });
        this.intervalLabel = new JLabel(I18n.tr("Check interval (minutes):", new Object[0]));
        this.add((Component)this.intervalLabel, GBC.std().insets(25, 0, 0, 0));
        this.notifierInterval.setToolTipText(I18n.tr("Default value: {0}", MessageNotifier.PROP_INTERVAL.getDefaultValue()));
        this.notifierInterval.setMinimumSize(this.notifierInterval.getPreferredSize());
        this.add((Component)this.notifierInterval, GBC.eol().insets(5, 0, 0, 0));
        JLabel jLabel = new JLabel(I18n.tr("Max age for closed notes (days):", new Object[0]));
        jLabel.setToolTipText(I18n.tr("Specifies the number of days a note needs to be closed to no longer be downloaded", new Object[0]));
        this.add((Component)jLabel, GBC.std().insets(0, 20, 0, 0));
        this.notesDaysClosed.setToolTipText(I18n.tr("Default value: {0}", DownloadNotesTask.DAYS_CLOSED.getDefaultValue()));
        this.notesDaysClosed.setMinimumSize(this.notesDaysClosed.getPreferredSize());
        this.add((Component)this.notesDaysClosed, GBC.eol().insets(5, 20, 0, 0));
    }

    private void updateEnabledState() {
        boolean bl = this.notifier.isSelected();
        this.intervalLabel.setEnabled(bl);
        this.notifierInterval.setEnabled(bl);
        this.notifierInterval.setEditable(bl);
        this.notesDaysClosed.setEditable(bl);
    }

    public final void initFromPreferences() {
        this.notifier.setSelected(MessageNotifier.PROP_NOTIFIER_ENABLED.get());
        this.notifierInterval.setText(Integer.toString(MessageNotifier.PROP_INTERVAL.get()));
        this.notesDaysClosed.setText(Integer.toString(DownloadNotesTask.DAYS_CLOSED.get()));
    }

    public void saveToPreferences() {
        boolean bl = this.notifier.isSelected();
        boolean bl2 = MessageNotifier.PROP_NOTIFIER_ENABLED.put(bl);
        bl2 |= MessageNotifier.PROP_INTERVAL.parseAndPut(this.notifierInterval.getText());
        if (bl2 |= DownloadNotesTask.DAYS_CLOSED.parseAndPut(this.notesDaysClosed.getText())) {
            MessageNotifier.stop();
            if (bl) {
                MessageNotifier.start();
            }
        } else if (!MessageNotifier.isUserEnoughIdentified()) {
            MessageNotifier.stop();
        } else if (bl && !MessageNotifier.isRunning()) {
            MessageNotifier.start();
        }
    }
}

