/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.projection.CodeProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.CustomProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.GaussKruegerProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertCC9ZonesProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.PuwgProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SingleProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.preferences.projection.SwissGridProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTMFranceDOMProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTMProjectionChoice;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ProjectionPreference
implements SubPreferenceSetting {
    private static List<ProjectionChoice> projectionChoices = new ArrayList<ProjectionChoice>();
    private static Map<String, ProjectionChoice> projectionChoicesById = new HashMap<String, ProjectionChoice>();
    public static final ProjectionChoice wgs84 = ProjectionPreference.registerProjectionChoice(I18n.tr("WGS84 Geographic", new Object[0]), "core:wgs84", 4326, "epsg4326");
    public static final ProjectionChoice mercator = ProjectionPreference.registerProjectionChoice(I18n.tr("Mercator", new Object[0]), "core:mercator", 3857);
    public static final ProjectionChoice lambert;
    public static final ProjectionChoice utm_france_dom;
    public static final ProjectionChoice lambert_cc9;
    private static final StringProperty PROP_PROJECTION;
    private static final StringProperty PROP_COORDINATES;
    private static final CollectionProperty PROP_SUB_PROJECTION;
    public static final StringProperty PROP_SYSTEM_OF_MEASUREMENT;
    private static final String[] unitsValues;
    private static final String[] unitsValuesTr;
    private final JosmComboBox<ProjectionChoice> projectionCombo = new JosmComboBox<ProjectionChoice>(projectionChoices.toArray(new ProjectionChoice[0]));
    private final JosmComboBox<CoordinateFormat> coordinatesCombo = new JosmComboBox<CoordinateFormat>(CoordinateFormat.values());
    private final JosmComboBox<String> unitsCombo = new JosmComboBox<String>(unitsValuesTr);
    private JPanel projSubPrefPanel;
    private JPanel projSubPrefPanelWrapper = new JPanel(new GridBagLayout());
    private JLabel projectionCodeLabel;
    private Component projectionCodeGlue;
    private JLabel projectionCode = new JLabel();
    private JLabel projectionNameLabel;
    private Component projectionNameGlue;
    private JLabel projectionName = new JLabel();
    private JLabel bounds = new JLabel();
    private final JPanel projPanel = new JPanel(new GridBagLayout());
    private static final GBC projSubPrefPanelGBC;

    public static void registerProjectionChoice(ProjectionChoice projectionChoice) {
        projectionChoices.add(projectionChoice);
        projectionChoicesById.put(projectionChoice.getId(), projectionChoice);
    }

    public static ProjectionChoice registerProjectionChoice(String string, String string2, Integer n, String string3) {
        SingleProjectionChoice singleProjectionChoice = new SingleProjectionChoice(string, string2, "EPSG:" + n, string3);
        ProjectionPreference.registerProjectionChoice(singleProjectionChoice);
        return singleProjectionChoice;
    }

    private static ProjectionChoice registerProjectionChoice(String string, String string2, Integer n) {
        SingleProjectionChoice singleProjectionChoice = new SingleProjectionChoice(string, string2, "EPSG:" + n);
        ProjectionPreference.registerProjectionChoice(singleProjectionChoice);
        return singleProjectionChoice;
    }

    public static List<ProjectionChoice> getProjectionChoices() {
        return Collections.unmodifiableList(projectionChoices);
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        int n;
        ProjectionChoice projectionChoice = this.setupProjectionCombo();
        for (n = 0; n < this.coordinatesCombo.getItemCount(); ++n) {
            if (!((CoordinateFormat)((Object)this.coordinatesCombo.getItemAt(n))).name().equals(PROP_COORDINATES.get())) continue;
            this.coordinatesCombo.setSelectedIndex(n);
            break;
        }
        for (n = 0; n < unitsValues.length; ++n) {
            if (!unitsValues[n].equals(PROP_SYSTEM_OF_MEASUREMENT.get())) continue;
            this.unitsCombo.setSelectedIndex(n);
            break;
        }
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection method", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projectionCodeLabel = new JLabel(I18n.tr("Projection code", new Object[0]));
        this.projPanel.add((Component)this.projectionCodeLabel, GBC.std().insets(25, 5, 0, 5));
        this.projectionCodeGlue = GBC.glue(5, 0);
        this.projPanel.add(this.projectionCodeGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projectionNameLabel = new JLabel(I18n.tr("Projection name", new Object[0]));
        this.projPanel.add((Component)this.projectionNameLabel, GBC.std().insets(25, 5, 0, 5));
        this.projectionNameGlue = GBC.glue(5, 0);
        this.projPanel.add(this.projectionNameGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionName, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Bounds", new Object[0])), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projSubPrefPanelWrapper, GBC.eol().fill(2).insets(20, 5, 5, 5));
        this.projPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 10));
        this.projPanel.add((Component)new JLabel(I18n.tr("Display coordinates as", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("System of measurement", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.unitsCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add(GBC.glue(1, 1), GBC.std().fill(2).weight(1.0, 1.0));
        JScrollPane jScrollPane = new JScrollPane(this.projPanel);
        preferenceTabbedPane.getMapPreference().addSubTab(this, I18n.tr("Map Projection", new Object[0]), jScrollPane);
        this.selectedProjectionChanged(projectionChoice);
    }

    private void updateMeta(ProjectionChoice projectionChoice) {
        projectionChoice.setPreferences(projectionChoice.getPreferences(this.projSubPrefPanel));
        Projection projection = projectionChoice.getProjection();
        this.projectionCode.setText(projection.toCode());
        this.projectionName.setText(projection.toString());
        Bounds bounds = projection.getWorldBoundsLatLon();
        CoordinateFormat coordinateFormat = CoordinateFormat.getDefaultFormat();
        this.bounds.setText(bounds.getMin().lonToString(coordinateFormat) + ", " + bounds.getMin().latToString(coordinateFormat) + " : " + bounds.getMax().lonToString(coordinateFormat) + ", " + bounds.getMax().latToString(coordinateFormat));
        boolean bl = true;
        boolean bl2 = false;
        if (projectionChoice instanceof SubPrefsOptions) {
            bl = ((SubPrefsOptions)((Object)projectionChoice)).showProjectionCode();
            bl2 = ((SubPrefsOptions)((Object)projectionChoice)).showProjectionName();
        }
        this.projectionCodeLabel.setVisible(bl);
        this.projectionCodeGlue.setVisible(bl);
        this.projectionCode.setVisible(bl);
        this.projectionNameLabel.setVisible(bl2);
        this.projectionNameGlue.setVisible(bl2);
        this.projectionName.setVisible(bl2);
    }

    @Override
    public boolean ok() {
        ProjectionChoice projectionChoice = (ProjectionChoice)this.projectionCombo.getSelectedItem();
        String string = projectionChoice.getId();
        Collection<String> collection = projectionChoice.getPreferences(this.projSubPrefPanel);
        ProjectionPreference.setProjection(string, collection);
        if (PROP_COORDINATES.put(((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem())).name())) {
            CoordinateFormat.setCoordinateFormat((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem()));
        }
        int n = this.unitsCombo.getSelectedIndex();
        NavigatableComponent.setSystemOfMeasurement(unitsValues[n]);
        return false;
    }

    public static void setProjection() {
        ProjectionPreference.setProjection(PROP_PROJECTION.get(), (Collection<String>)PROP_SUB_PROJECTION.get());
    }

    public static void setProjection(String string, Collection<String> collection) {
        ProjectionChoice projectionChoice = projectionChoicesById.get(string);
        if (projectionChoice == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection {0} could not be activated. Using Mercator", string), I18n.tr("Error", new Object[0]), 0);
            collection = null;
            projectionChoice = mercator;
        }
        string = projectionChoice.getId();
        PROP_PROJECTION.put(string);
        PROP_SUB_PROJECTION.put(collection);
        Main.pref.putCollection("projection.sub." + string, collection);
        projectionChoice.setPreferences(collection);
        Projection projection = projectionChoice.getProjection();
        Main.setProjection(projection);
    }

    private void selectedProjectionChanged(final ProjectionChoice projectionChoice) {
        int n = this.projPanel.getComponentCount();
        if (n < 1) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectionPreference.this.updateMeta(projectionChoice);
            }
        };
        this.projSubPrefPanelWrapper.removeAll();
        this.projSubPrefPanel = projectionChoice.getPreferencePanel(actionListener);
        this.projSubPrefPanelWrapper.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
        this.projSubPrefPanel.repaint();
        this.updateMeta(projectionChoice);
    }

    private ProjectionChoice setupProjectionCombo() {
        ProjectionChoice projectionChoice = null;
        for (int i = 0; i < this.projectionCombo.getItemCount(); ++i) {
            ProjectionChoice projectionChoice2 = (ProjectionChoice)this.projectionCombo.getItemAt(i);
            projectionChoice2.setPreferences(this.getSubprojectionPreference(projectionChoice2));
            if (!projectionChoice2.getId().equals(PROP_PROJECTION.get())) continue;
            this.projectionCombo.setSelectedIndex(i);
            this.selectedProjectionChanged(projectionChoice2);
            projectionChoice = projectionChoice2;
        }
        if (projectionChoice == null) {
            throw new RuntimeException("Couldn't find the current projection in the list of available projections!");
        }
        this.projectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectionChoice projectionChoice = (ProjectionChoice)ProjectionPreference.this.projectionCombo.getSelectedItem();
                ProjectionPreference.this.selectedProjectionChanged(projectionChoice);
            }
        });
        return projectionChoice;
    }

    private Collection<String> getSubprojectionPreference(ProjectionChoice projectionChoice) {
        return Main.pref.getCollection("projection.sub." + projectionChoice.getId(), null);
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getMapPreference();
    }

    public void selectProjection(ProjectionChoice projectionChoice) {
        if (this.projectionCombo != null && projectionChoice != null) {
            this.projectionCombo.setSelectedItem(projectionChoice);
        }
    }

    static {
        ProjectionPreference.registerProjectionChoice(new UTMProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("Belgian Lambert 1972", new Object[0]), "core:belgianLambert1972", 31370);
        ProjectionPreference.registerProjectionChoice(I18n.tr("Belgian Lambert 2008", new Object[0]), "core:belgianLambert2008", 3812);
        ProjectionPreference.registerProjectionChoice(new SwissGridProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new GaussKruegerProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("Lambert Zone (Estonia)", new Object[0]), "core:lambertest", 3301);
        lambert = new LambertProjectionChoice();
        ProjectionPreference.registerProjectionChoice(lambert);
        ProjectionPreference.registerProjectionChoice(I18n.tr("Lambert 93 (France)", new Object[0]), "core:lambert93", 2154);
        lambert_cc9 = new LambertCC9ZonesProjectionChoice();
        ProjectionPreference.registerProjectionChoice(lambert_cc9);
        utm_france_dom = new UTMFranceDOMProjectionChoice();
        ProjectionPreference.registerProjectionChoice(utm_france_dom);
        ProjectionPreference.registerProjectionChoice(I18n.tr("LKS-92 (Latvia TM)", new Object[0]), "core:tmerclv", 3059);
        ProjectionPreference.registerProjectionChoice(new PuwgProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("SWEREF99 13 30 / EPSG:3008 (Sweden)", new Object[0]), "core:sweref99", 3008);
        ProjectionPreference.registerProjectionChoice(new CodeProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new CustomProjectionChoice());
        PROP_PROJECTION = new StringProperty("projection", mercator.getId());
        PROP_COORDINATES = new StringProperty("coordinates", null);
        PROP_SUB_PROJECTION = new CollectionProperty("projection.sub", null);
        PROP_SYSTEM_OF_MEASUREMENT = new StringProperty("system_of_measurement", "Metric");
        unitsValues = new ArrayList<String>(SystemOfMeasurement.ALL_SYSTEMS.keySet()).toArray(new String[0]);
        unitsValuesTr = new String[unitsValues.length];
        for (int i = 0; i < unitsValues.length; ++i) {
            ProjectionPreference.unitsValuesTr[i] = I18n.tr(unitsValues[i], new Object[0]);
        }
        projSubPrefPanelGBC = GBC.std().fill(1).weight(1.0, 1.0);
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

