/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.projection.AbstractProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class CustomProjectionChoice
extends AbstractProjectionChoice
implements SubPrefsOptions {
    private String pref;

    public CustomProjectionChoice() {
        super(I18n.tr("Custom Projection", new Object[0]), "core:custom");
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        if (collection != null && !collection.isEmpty()) {
            this.pref = collection.iterator().next();
        }
    }

    @Override
    public Projection getProjection() {
        return new CustomProjection(this.pref);
    }

    @Override
    public String getCurrentCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProjectionName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JPanel getPreferencePanel(ActionListener actionListener) {
        return new PreferencePanel(this.pref, actionListener);
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        if (!(jPanel instanceof PreferencePanel)) {
            throw new IllegalArgumentException("Unsupported panel: " + jPanel);
        }
        PreferencePanel preferencePanel = (PreferencePanel)jPanel;
        String string = preferencePanel.input.getText();
        preferencePanel.rememberHistory();
        return Collections.singleton(string);
    }

    @Override
    public String[] allCodes() {
        return new String[0];
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        return null;
    }

    @Override
    public boolean showProjectionCode() {
        return false;
    }

    @Override
    public boolean showProjectionName() {
        return false;
    }

    public static class ParameterInfoDialog
    extends ExtendedDialog {
        public ParameterInfoDialog() {
            super(null, I18n.tr("Parameter information", new Object[0]), new String[]{I18n.tr("Close", new Object[0])}, false);
            this.setContent(this.build());
        }

        private JComponent build() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<b>+proj=...</b> - <i>" + I18n.tr("Projection name", new Object[0]) + "</i><br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Supported values:", new Object[0]) + " ");
            stringBuilder.append(this.listKeys(Projections.projs) + "<br>");
            stringBuilder.append("<b>+lat_0=..., +lat_1=..., +lat_2=...</b> - <i>" + I18n.tr("Projection parameters", new Object[0]) + "</i><br>");
            stringBuilder.append("<b>+x_0=..., +y_0=...</b> - <i>" + I18n.tr("False easting and false northing", new Object[0]) + "</i><br>");
            stringBuilder.append("<b>+lon_0=...</b> - <i>" + I18n.tr("Central meridian", new Object[0]) + "</i><br>");
            stringBuilder.append("<b>+k_0=...</b> - <i>" + I18n.tr("Scaling factor", new Object[0]) + "</i><br>");
            stringBuilder.append("<b>+ellps=...</b> - <i>" + I18n.tr("Ellipsoid name", new Object[0]) + "</i><br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Supported values:", new Object[0]) + " ");
            stringBuilder.append(this.listKeys(Projections.ellipsoids) + "<br>");
            stringBuilder.append("<b>+a=..., +b=..., +rf=..., +f=..., +es=...</b> - <i>" + I18n.tr("Ellipsoid parameters", new Object[0]) + "</i><br>");
            stringBuilder.append("<b>+datum=...</b> - <i>" + I18n.tr("Datum name", new Object[0]) + "</i><br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Supported values:", new Object[0]) + " ");
            stringBuilder.append(this.listKeys(Projections.datums) + "<br>");
            stringBuilder.append("<b>+towgs84=...</b> - <i>" + I18n.tr("3 or 7 term datum transform parameters", new Object[0]) + "</i><br>");
            stringBuilder.append("<b>+nadgrids=...</b> - <i>" + I18n.tr("NTv2 grid file", new Object[0]) + "</i><br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.tr("Built-in:", new Object[0]) + " ");
            stringBuilder.append(this.listKeys(Projections.nadgrids) + "<br>");
            stringBuilder.append("<b>+bounds=</b>minlon,minlat,maxlon,maxlat - <i>" + I18n.tr("Projection bounds (in degrees)", new Object[0]) + "</i><br>");
            stringBuilder.append("<b>+wmssrs=</b>EPSG:123456 - <i>" + I18n.tr("Sets the SRS=... parameter in the WMS request", new Object[0]) + "</i><br>");
            return new HtmlPanel(stringBuilder.toString());
        }

        private String listKeys(Map<String, ?> map) {
            ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
            Collections.sort(arrayList);
            return Utils.join(", ", arrayList);
        }
    }

    private static class PreferencePanel
    extends JPanel {
        public JosmTextField input;
        private HistoryComboBox cbInput;

        public PreferencePanel(String string, ActionListener actionListener) {
            this.build(string, actionListener);
        }

        private final void build(String string, final ActionListener actionListener) {
            this.input = new JosmTextField(30);
            this.cbInput = new HistoryComboBox();
            this.cbInput.setPrototypeDisplayValue(new AutoCompletionListItem("xxxx"));
            this.cbInput.setEditor(new BasicComboBoxEditor(){

                @Override
                protected JosmTextField createEditorComponent() {
                    return PreferencePanel.this.input;
                }
            });
            List<String> list = Arrays.asList("+proj=lonlat +ellps=WGS84 +datum=WGS84 +bounds=-180,-90,180,90", "+proj=tmerc +lat_0=0 +lon_0=9 +k_0=1 +x_0=3500000 +y_0=0 +ellps=bessel +nadgrids=BETA2007.gsb");
            LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection("projection.custom.value.history", list));
            Collections.reverse(linkedList);
            this.cbInput.setPossibleItems(linkedList);
            this.cbInput.setText(string == null ? "" : string);
            final HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setVisible(false);
            final JLabel jLabel = new JLabel();
            jLabel.setVisible(false);
            final AbstractTextComponentValidator abstractTextComponentValidator = new AbstractTextComponentValidator(this.input, false, false, false){
                private String error;

                @Override
                public void validate() {
                    if (!this.isValid()) {
                        this.feedbackInvalid(I18n.tr("Invalid projection configuration: {0}", this.error));
                    } else {
                        this.feedbackValid(I18n.tr("Projection configuration is valid.", new Object[0]));
                    }
                    actionListener.actionPerformed(null);
                }

                @Override
                public final boolean isValid() {
                    try {
                        CustomProjection customProjection = new CustomProjection();
                        customProjection.update(PreferencePanel.this.input.getText());
                    }
                    catch (ProjectionConfigurationException projectionConfigurationException) {
                        this.error = projectionConfigurationException.getMessage();
                        jLabel.setIcon(ImageProvider.get("data", "error"));
                        jLabel.setVisible(true);
                        htmlPanel.setText(this.error);
                        htmlPanel.setVisible(true);
                        return false;
                    }
                    htmlPanel.setVisible(false);
                    jLabel.setIcon(ImageProvider.get("misc", "green_check"));
                    jLabel.setVisible(true);
                    return true;
                }
            };
            JButton jButton = new JButton(I18n.tr("Validate", new Object[0]));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    abstractTextComponentValidator.validate();
                }
            });
            jButton.setLayout(new BorderLayout());
            jButton.setMargin(new Insets(-1, 0, -1, 0));
            JButton jButton2 = new JButton(I18n.tr("Parameter information...", new Object[0]));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ParameterInfoDialog parameterInfoDialog = new ParameterInfoDialog();
                    parameterInfoDialog.showDialog();
                    parameterInfoDialog.toFront();
                }
            });
            this.setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this.cbInput, GBC.std().fill(2).insets(0, 20, 5, 5));
            jPanel.add((Component)jButton, GBC.eol().insets(0, 20, 0, 5));
            this.add((Component)jPanel, GBC.eol().fill(2));
            jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)jLabel, GBC.std().anchor(17).weight(1.0E-4, 0.0));
            jPanel.add((Component)htmlPanel, GBC.eol().fill(2));
            this.add((Component)jPanel, GBC.eol().fill(2));
            jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)jButton2, GBC.std().insets(0, 20, 0, 0));
            jPanel.add(GBC.glue(1, 0), GBC.eol().fill(2));
            this.add((Component)jPanel, GBC.eol().fill(2));
        }

        public void rememberHistory() {
            this.cbInput.addCurrentItemToHistory();
            Main.pref.putCollection("projection.custom.value.history", this.cbInput.getHistory());
        }
    }
}

