/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ColorPreference
implements SubPreferenceSetting {
    private DefaultTableModel tableModel;
    private JTable colors;
    private List<String> del = new ArrayList<String>();
    private JButton colorEdit;
    private JButton defaultSet;
    private JButton remove;

    public void setColorModel(Map<String, String> map) {
        if (this.tableModel == null) {
            this.tableModel = new DefaultTableModel();
            this.tableModel.addColumn(I18n.tr("Name", new Object[0]));
            this.tableModel.addColumn(I18n.tr("Color", new Object[0]));
        }
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        TreeMap<String, String> treeMap3 = new TreeMap<String, String>();
        for (String string : map.keySet()) {
            if (string.startsWith("layer ")) {
                treeMap3.put(this.getName(string), string);
                continue;
            }
            if (string.startsWith("mappaint.")) {
                treeMap2.put(this.getName(string) + string, string);
                continue;
            }
            treeMap.put(this.getName(string), string);
        }
        this.addColorRows(map, treeMap);
        this.addColorRows(map, treeMap2);
        this.addColorRows(map, treeMap3);
        if (this.colors != null) {
            this.colors.repaint();
        }
    }

    private void addColorRows(Map<String, String> map, Map<String, String> map2) {
        for (String string : map2.values()) {
            Vector<Object> vector = new Vector<Object>(2);
            String string2 = map.get(string);
            Color color = ColorHelper.html2color(string2);
            if (color == null) {
                Main.warn("Unable to get color from '" + string2 + "' for color preference '" + string + "'");
            }
            vector.add(string);
            vector.add(color);
            this.tableModel.addRow(vector);
        }
    }

    public Map<String, String> getColorModel() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String string = (String)this.tableModel.getValueAt(i, 0);
            String string2 = ColorHelper.color2html((Color)this.tableModel.getValueAt(i, 1));
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private String getName(String string) {
        return Main.pref.getColorName(string);
    }

    @Override
    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        this.fixColorPrefixes();
        this.setColorModel(Main.pref.getAllColors());
        this.colorEdit = new JButton(I18n.tr("Choose", new Object[0]));
        this.colorEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPreference.this.colors.getSelectedRow();
                JColorChooser jColorChooser = new JColorChooser((Color)ColorPreference.this.colors.getValueAt(n, 1));
                int n2 = JOptionPane.showConfirmDialog(preferenceTabbedPane, jColorChooser, I18n.tr("Choose a color for {0}", ColorPreference.this.getName((String)ColorPreference.this.colors.getValueAt(n, 0))), 2, -1);
                if (n2 == 0) {
                    ColorPreference.this.colors.setValueAt(jColorChooser.getColor(), n, 1);
                }
            }
        });
        this.defaultSet = new JButton(I18n.tr("Set to default", new Object[0]));
        this.defaultSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPreference.this.colors.getSelectedRow();
                String string = (String)ColorPreference.this.colors.getValueAt(n, 0);
                Color color = Main.pref.getDefaultColor(string);
                if (color != null) {
                    ColorPreference.this.colors.setValueAt(color, n, 1);
                }
            }
        });
        JButton jButton = new JButton(I18n.tr("Set all to default", new Object[0]));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < ColorPreference.this.colors.getRowCount(); ++i) {
                    String string = (String)ColorPreference.this.colors.getValueAt(i, 0);
                    Color color = Main.pref.getDefaultColor(string);
                    if (color == null) continue;
                    ColorPreference.this.colors.setValueAt(color, i, 1);
                }
            }
        });
        this.remove = new JButton(I18n.tr("Remove", new Object[0]));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPreference.this.colors.getSelectedRow();
                ColorPreference.this.del.add((String)ColorPreference.this.colors.getValueAt(n, 0));
                ColorPreference.this.tableModel.removeRow(n);
            }
        });
        this.remove.setEnabled(false);
        this.colorEdit.setEnabled(false);
        this.defaultSet.setEnabled(false);
        this.colors = new JTable(this.tableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                super.valueChanged(listSelectionEvent);
                int n = this.getSelectedRow();
                ColorPreference.this.remove.setEnabled(n >= 0 && ColorPreference.this.isRemoveColor(n) != false);
                ColorPreference.this.colorEdit.setEnabled(n >= 0);
                ColorPreference.this.defaultSet.setEnabled(n >= 0);
            }
        };
        this.colors.setSelectionMode(0);
        final TableCellRenderer tableCellRenderer = this.colors.getDefaultRenderer(Object.class);
        this.colors.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object == null) {
                    return new JLabel();
                }
                if (n2 == 1) {
                    JLabel jLabel = new JLabel(ColorHelper.color2html((Color)object));
                    jLabel.setBackground((Color)object);
                    jLabel.setOpaque(true);
                    return jLabel;
                }
                return tableCellRenderer.getTableCellRendererComponent(jTable, ColorPreference.this.getName(object.toString()), bl, bl2, n, n2);
            }
        });
        this.colors.getColumnModel().getColumn(1).setWidth(100);
        this.colors.setToolTipText(I18n.tr("Colors used by different objects in JOSM.", new Object[0]));
        this.colors.setPreferredScrollableViewportSize(new Dimension(100, 112));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.colors);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, GBC.eol().insets(5, 0, 5, 5).fill(2));
        jPanel2.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        jPanel2.add((Component)this.colorEdit, GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)this.defaultSet, GBC.std().insets(5, 5, 5, 0));
        jPanel2.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)this.remove, GBC.std().insets(0, 5, 0, 0));
        preferenceTabbedPane.getDisplayPreference().addSubTab(this, I18n.tr("Colors", new Object[0]), jPanel);
    }

    Boolean isRemoveColor(int n) {
        return ((String)this.colors.getValueAt(n, 0)).startsWith("layer ");
    }

    private void fixColorPrefixes() {
        PaintColors.getColors();
        ConflictColors.getColors();
        Severity.getColors();
        MarkerLayer.getGenericColor();
        GpxDrawHelper.getGenericColor();
        OsmDataLayer.getOutsideColor();
        ImageryLayer.getFadeColor();
        MapScaler.getColor();
        MapStatus.getColors();
        ConflictDialog.getColor();
    }

    @Override
    public boolean ok() {
        Boolean bl = false;
        for (String string : this.del) {
            Main.pref.put("color." + string, null);
        }
        for (int i = 0; i < this.colors.getRowCount(); ++i) {
            String string;
            string = (String)this.colors.getValueAt(i, 0);
            if (!Main.pref.putColor(string, (Color)this.colors.getValueAt(i, 1)) || !string.startsWith("mappaint.")) continue;
            bl = true;
        }
        OsmDataLayer.createHatchTexture();
        return bl;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getDisplayPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ColorPreference();
        }
    }
}

