/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OsmPrivileges;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmOAuthAuthorizationClient {
    private final OAuthParameters oauthProviderParameters;
    private final OAuthConsumer consumer;
    private final OAuthProvider provider;
    private boolean canceled;
    private HttpURLConnection connection;

    public OsmOAuthAuthorizationClient() {
        this.oauthProviderParameters = OAuthParameters.createDefault(Main.pref.get("osm-server.url"));
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters oAuthParameters) {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(oAuthParameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters oAuthParameters, OAuthToken oAuthToken) {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(oAuthParameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
        this.consumer.setTokenWithSecret(oAuthToken.getKey(), oAuthToken.getSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object;
        DefaultOAuthProvider defaultOAuthProvider = (DefaultOAuthProvider)this.provider;
        this.canceled = true;
        if (defaultOAuthProvider != null) {
            try {
                object = defaultOAuthProvider.getClass().getDeclaredField("connection");
                ((Field)object).setAccessible(true);
                HttpURLConnection httpURLConnection = (HttpURLConnection)((Field)object).get(defaultOAuthProvider);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                Main.error(exception);
                Main.warn(I18n.tr("Failed to cancel running OAuth operation", new Object[0]));
            }
        }
        object = this;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public OAuthToken getRequestToken(ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Request Token from ''{0}''", this.oauthProviderParameters.getRequestTokenUrl()));
            this.provider.retrieveRequestToken(this.consumer, "", new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException oAuthException) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(oAuthException);
            }
            throw new OsmOAuthAuthorizationException(oAuthException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public OAuthToken getAccessToken(ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Access Token from ''{0}''", this.oauthProviderParameters.getAccessTokenUrl()));
            this.provider.retrieveAccessToken(this.consumer, null, new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException oAuthException) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(oAuthException);
            }
            throw new OsmOAuthAuthorizationException(oAuthException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public String getAuthoriseUrl(OAuthToken oAuthToken) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.oauthProviderParameters.getAuthoriseUrl()).append("?").append("oauth_token").append("=").append(oAuthToken.getKey());
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractToken(HttpURLConnection httpURLConnection) {
        try (InputStream inputStream = httpURLConnection.getInputStream();
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string;
            Matcher matcher;
            Pattern pattern = Pattern.compile(".*authenticity_token.*value=\"([^\"]+)\".*");
            do {
                if ((string = bufferedReader.readLine()) == null) return null;
            } while (!(matcher = pattern.matcher(string)).find());
            String string2 = matcher.group(1);
            return string2;
        }
        catch (IOException iOException) {
            Main.error(iOException);
            return null;
        }
    }

    protected SessionId extractOsmSession(HttpURLConnection httpURLConnection) {
        List<String> list = httpURLConnection.getHeaderFields().get("Set-Cookie");
        if (list == null) {
            return null;
        }
        for (String string : list) {
            String[] stringArray = string.split(";");
            if (stringArray == null || stringArray.length == 0) continue;
            for (String string2 : stringArray) {
                String[] stringArray2 = (string2 = string2.trim()).split("=");
                if (stringArray2 == null || stringArray2.length != 2 || !"_osm_session".equals(stringArray2[0])) continue;
                String string3 = this.extractToken(httpURLConnection);
                if (string3 == null) {
                    return null;
                }
                SessionId sessionId = new SessionId();
                sessionId.id = stringArray2[1];
                sessionId.token = string3;
                return sessionId;
            }
        }
        return null;
    }

    protected String buildPostRequest(Map<String, String> map) throws OsmOAuthAuthorizationException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String string = entry.getValue();
            string = string == null ? "" : string;
            stringBuilder.append(entry.getKey()).append("=").append(Utils.encodeUrl(string));
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    public String buildOsmLoginUrl() throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL uRL2 = new URL(Main.pref.get("oauth.protocol", "https"), uRL.getHost(), uRL.getPort(), "/login");
            return uRL2.toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new OsmOAuthAuthorizationException(malformedURLException);
        }
    }

    protected String buildOsmLogoutUrl() throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL uRL2 = new URL("http", uRL.getHost(), uRL.getPort(), "/logout");
            return uRL2.toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new OsmOAuthAuthorizationException(malformedURLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionId fetchOsmWebsiteSessionId() throws OsmOAuthAuthorizationException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.buildOsmLoginUrl()).append("?cookie_test=true");
            URL uRL = new URL(stringBuilder.toString());
            Object object = this;
            synchronized (object) {
                this.connection = Utils.openHttpConnection(uRL);
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.connect();
            object = this.extractOsmSession(this.connection);
            if (object == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", uRL.toString()));
            }
            Object object2 = object;
            return object2;
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchOAuthToken(SessionId sessionId, OAuthToken oAuthToken) throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.getAuthoriseUrl(oAuthToken));
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = Utils.openHttpConnection(uRL);
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
            this.connection.connect();
            sessionId.token = this.extractToken(this.connection);
            if (sessionId.token == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", uRL.toString()));
            }
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateOsmSession(SessionId sessionId, String string, String string2) throws OsmLoginFailedException {
        try {
            URL uRL = new URL(this.buildOsmLoginUrl());
            Object object = this;
            synchronized (object) {
                this.connection = Utils.openHttpConnection(uRL);
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            object = new HashMap();
            object.put("username", string);
            object.put("password", string2);
            object.put("referer", "/");
            object.put("commit", "Login");
            object.put("authenticity_token", sessionId.token);
            String string3 = this.buildPostRequest((Map<String, String>)object);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(string3.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId.id);
            this.connection.setInstanceFollowRedirects(false);
            this.connection.connect();
            try (DataOutputStream dataOutputStream = new DataOutputStream(this.connection.getOutputStream());){
                dataOutputStream.writeBytes(string3);
                dataOutputStream.flush();
            }
            int n = this.connection.getResponseCode();
            if (n != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authenticate user ''{0}'' with password ''***'' as OAuth user", string));
            }
        }
        catch (OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
            throw new OsmLoginFailedException(osmOAuthAuthorizationException.getCause());
        }
        catch (IOException iOException) {
            throw new OsmLoginFailedException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutOsmSession(SessionId sessionId) throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.buildOsmLogoutUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = Utils.openHttpConnection(uRL);
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.connect();
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAuthorisationRequest(SessionId sessionId, OAuthToken oAuthToken, OsmPrivileges osmPrivileges) throws OsmOAuthAuthorizationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.fetchOAuthToken(sessionId, oAuthToken);
        hashMap.put("oauth_token", oAuthToken.getKey());
        hashMap.put("oauth_callback", "");
        hashMap.put("authenticity_token", sessionId.token);
        if (osmPrivileges.isAllowWriteApi()) {
            hashMap.put("allow_write_api", "yes");
        }
        if (osmPrivileges.isAllowWriteGpx()) {
            hashMap.put("allow_write_gpx", "yes");
        }
        if (osmPrivileges.isAllowReadGpx()) {
            hashMap.put("allow_read_gpx", "yes");
        }
        if (osmPrivileges.isAllowWritePrefs()) {
            hashMap.put("allow_write_prefs", "yes");
        }
        if (osmPrivileges.isAllowReadPrefs()) {
            hashMap.put("allow_read_prefs", "yes");
        }
        if (osmPrivileges.isAllowModifyNotes()) {
            hashMap.put("allow_write_notes", "yes");
        }
        hashMap.put("commit", "Save changes");
        String string = this.buildPostRequest(hashMap);
        try {
            URL uRL = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            Object object = this;
            synchronized (object) {
                this.connection = Utils.openHttpConnection(uRL);
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(string.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
            this.connection.setInstanceFollowRedirects(false);
            this.connection.connect();
            object = new DataOutputStream(this.connection.getOutputStream());
            Throwable throwable = null;
            try {
                ((DataOutputStream)object).writeBytes(string);
                ((DataOutputStream)object).flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((FilterOutputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FilterOutputStream)object).close();
                    }
                }
            }
            int n = this.connection.getResponseCode();
            if (n != 200) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authorize OAuth request  ''{0}''", oAuthToken.getKey()));
            }
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    public void authorise(OAuthToken oAuthToken, String string, String string2, OsmPrivileges osmPrivileges, ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        CheckParameterUtil.ensureParameterNotNull(oAuthToken, "requestToken");
        CheckParameterUtil.ensureParameterNotNull(string, "osmUserName");
        CheckParameterUtil.ensureParameterNotNull(string2, "osmPassword");
        CheckParameterUtil.ensureParameterNotNull(osmPrivileges, "privileges");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Authorizing OAuth Request token ''{0}'' at the OSM website ...", oAuthToken.getKey()));
            progressMonitor.setTicksCount(4);
            progressMonitor.indeterminateSubTask(I18n.tr("Initializing a session at the OSM website...", new Object[0]));
            SessionId sessionId = this.fetchOsmWebsiteSessionId();
            sessionId.userName = string;
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Authenticating the session for user ''{0}''...", string));
            this.authenticateOsmSession(sessionId, string, string2);
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Authorizing request token ''{0}''...", oAuthToken.getKey()));
            this.sendAuthorisationRequest(sessionId, oAuthToken, osmPrivileges);
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Logging out session ''{0}''...", sessionId));
            this.logoutOsmSession(sessionId);
            if (this.canceled) {
                throw new OsmTransferCanceledException();
            }
            progressMonitor.worked(1);
        }
        catch (OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(osmOAuthAuthorizationException);
            }
            throw osmOAuthAuthorizationException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static class SessionId {
        private String id;
        private String token;
        private String userName;

        private SessionId() {
        }
    }
}

