/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class MapPaintStyles {
    private static ElemStyles styles = new ElemStyles();
    protected static final CopyOnWriteArrayList<MapPaintSylesUpdateListener> listeners = new CopyOnWriteArrayList();

    public static ElemStyles getStyles() {
        return styles;
    }

    private MapPaintStyles() {
    }

    public static ImageProvider getIconProvider(IconReference iconReference, boolean bl) {
        String string = iconReference.source.getPrefName();
        ImageProvider imageProvider = new ImageProvider(iconReference.iconName).setDirs(MapPaintStyles.getIconSourceDirs(iconReference.source)).setId("mappaint." + string).setArchive(iconReference.source.zipIcons).setInArchiveDir(iconReference.source.getZipEntryDirName()).setOptional(true);
        if (bl && imageProvider.get() == null) {
            Main.warn("Mappaint style \"" + string + "\" (" + iconReference.source.getDisplayString() + ") icon \"" + iconReference.iconName + "\" not found.");
            return null;
        }
        return imageProvider;
    }

    public static ImageIcon getIcon(IconReference iconReference, int n, int n2) {
        String string = iconReference.source.getPrefName();
        ImageIcon imageIcon = MapPaintStyles.getIconProvider(iconReference, false).setWidth(n).setHeight(n2).get();
        if (imageIcon == null) {
            Main.warn("Mappaint style \"" + string + "\" (" + iconReference.source.getDisplayString() + ") icon \"" + iconReference.iconName + "\" not found.");
            return null;
        }
        return imageIcon;
    }

    public static ImageIcon getNoIcon_Icon(StyleSource styleSource) {
        return new ImageProvider("misc/no_icon").setDirs(MapPaintStyles.getIconSourceDirs(styleSource)).setId("mappaint." + styleSource.getPrefName()).setArchive(styleSource.zipIcons).setInArchiveDir(styleSource.getZipEntryDirName()).setOptional(true).get();
    }

    public static ImageIcon getNodeIcon(Tag tag) {
        return MapPaintStyles.getNodeIcon(tag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getNodeIcon(Tag tag, boolean bl) {
        if (tag != null) {
            StyleCache.StyleList styleList;
            DataSet dataSet = new DataSet();
            Node node = new Node(LatLon.ZERO);
            node.put(tag.getKey(), tag.getValue());
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                dataSet.addPrimitive(node);
                styleList = (StyleCache.StyleList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)node, (double)0.5, (boolean)false).a;
                dataSet.removePrimitive(node);
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
            if (styleList != null) {
                for (ElemStyle elemStyle : styleList) {
                    MapImage mapImage;
                    if (!(elemStyle instanceof NodeElemStyle) || (mapImage = ((NodeElemStyle)elemStyle).mapImage) == null) continue;
                    if (bl || mapImage.name == null || !"misc/deprecated.png".equals(mapImage.name)) {
                        return new ImageIcon(mapImage.getImage(false));
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static List<String> getIconSourceDirs(StyleSource styleSource) {
        LinkedList<String> linkedList = new LinkedList<String>();
        File file = styleSource.getLocalSourceDir();
        if (file != null) {
            linkedList.add(file.getPath());
        }
        Collection<String> collection = Main.pref.getCollection("mappaint.icon.sources");
        for (String string : collection) {
            String[] stringArray = string.indexOf(61) >= 0 ? string.split("=", 2) : new String[]{"", string};
            if (stringArray[0].length() != 0 && !styleSource.getPrefName().equals(stringArray[0])) continue;
            linkedList.add(stringArray[1]);
        }
        if (Main.pref.getBoolean("mappaint.icon.enable-defaults", true)) {
            linkedList.add("resource://images/styles/standard/");
            linkedList.add("resource://images/styles/");
        }
        return linkedList;
    }

    public static void readFromPreferences() {
        styles.clear();
        List<SourceEntry> list = MapPaintPreference.MapPaintPrefHelper.INSTANCE.get();
        for (SourceEntry sourceEntry : list) {
            StyleSource styleSource = MapPaintStyles.fromSourceEntry(sourceEntry);
            if (styleSource == null) continue;
            styles.add(styleSource);
        }
        for (StyleSource styleSource : styles.getStyleSources()) {
            MapPaintStyles.loadStyleForFirstTime(styleSource);
        }
        MapPaintStyles.fireMapPaintSylesUpdated();
    }

    private static void loadStyleForFirstTime(StyleSource styleSource) {
        long l = System.currentTimeMillis();
        styleSource.loadStyleSource();
        if (Main.pref.getBoolean("mappaint.auto_reload_local_styles", true) && styleSource.isLocal()) {
            try {
                Main.fileWatcher.registerStyleSource(styleSource);
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
        }
        if (Main.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            Main.debug("Initializing map style " + styleSource.url + " completed in " + Utils.getDurationString(l2));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StyleSource fromSourceEntry(SourceEntry var0) {
        block30: {
            block29: {
                var1_1 = null;
                try {
                    var2_2 = new HashSet<String>();
                    var2_2.addAll(Arrays.asList("application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5".split(", ")));
                    var2_2.addAll(Arrays.asList("text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5".split(", ")));
                    var1_1 = new CachedFile(var0.url).setHttpAccept(Utils.join(", ", var2_2));
                    var3_4 = var1_1.findZipEntryPath("mapcss", "style");
                    if (var3_4 != null) {
                        var0.isZip = true;
                        var0.zipEntryPath = var3_4;
                        return new MapCSSStyleSource(var0);
                    }
                    var3_4 = var1_1.findZipEntryPath("xml", "style");
                    if (var3_4 != null) {
                        return new XmlStyleSource(var0);
                    }
                    if (var0.url.toLowerCase().endsWith(".mapcss")) {
                        return new MapCSSStyleSource(var0);
                    }
                    if (var0.url.toLowerCase().endsWith(".xml")) {
                        return new XmlStyleSource(var0);
                    }
                    var4_5 = new InputStreamReader(var1_1.getInputStream(), StandardCharsets.UTF_8);
                    var5_6 = null;
                    ** try [egrp 1[TRYBLOCK] [3, 5 : 186->268)] { 
lbl24:
                    // 1 sources

                    break block29;
lbl25:
                    // 1 sources

                    catch (Throwable var6_9) {
                        var5_6 = var6_9;
                        throw var6_9;
                    }
                }
                catch (IOException var2_3) {
                    Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", new Object[]{var0.url, var2_3.toString()}));
                    Main.error(var2_3);
                    return null;
                }
            }
            block21: while (true) {
                var6_7 = var4_5.read();
                switch (var6_7) {
                    case -1: {
                        ** break;
lbl38:
                        // 1 sources

                        break block30;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block21;
                    }
                    case 60: {
                        return new XmlStyleSource(var0);
                    }
                    default: {
                        return new MapCSSStyleSource(var0);
                    }
                }
                break;
            }
lbl45:
            // 1 sources

            finally {
                if (var4_5 != null) {
                    if (var5_6 != null) {
                        try {
                            var4_5.close();
                        }
                        catch (Throwable var6_8) {
                            var5_6.addSuppressed(var6_8);
                        }
                    } else {
                        var4_5.close();
                    }
                }
            }
        }
        Main.warn("Could not detect style type. Using default (xml).");
        return new XmlStyleSource(var0);
    }

    public static void reloadStyles(int ... nArray) {
        ArrayList<StyleSource> arrayList = new ArrayList<StyleSource>();
        List<StyleSource> list = styles.getStyleSources();
        for (int n : nArray) {
            arrayList.add(list.get(n));
        }
        Main.worker.submit(new MapPaintStyleLoader(arrayList));
    }

    public static void moveStyles(int[] nArray, int n) {
        if (!MapPaintStyles.canMoveStyles(nArray, n)) {
            return;
        }
        int[] nArray2 = Utils.copyArray(nArray);
        Arrays.sort(nArray2);
        ArrayList<StyleSource> arrayList = new ArrayList<StyleSource>(styles.getStyleSources());
        for (int n2 : nArray2) {
            StyleSource styleSource = (StyleSource)arrayList.get(n2);
            StyleSource styleSource2 = (StyleSource)arrayList.get(n2 + n);
            arrayList.set(n2, styleSource2);
            arrayList.set(n2 + n, styleSource);
        }
        styles.setStyleSources(arrayList);
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(arrayList);
        MapPaintStyles.fireMapPaintSylesUpdated();
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static boolean canMoveStyles(int[] nArray, int n) {
        if (nArray.length == 0) {
            return false;
        }
        int[] nArray2 = Utils.copyArray(nArray);
        Arrays.sort(nArray2);
        if (n < 0) {
            return nArray2[0] >= -n;
        }
        if (n > 0) {
            return nArray2[nArray2.length - 1] <= styles.getStyleSources().size() - 1 - n;
        }
        return true;
    }

    public static void toggleStyleActive(int ... nArray) {
        List<StyleSource> list = styles.getStyleSources();
        for (int n : nArray) {
            StyleSource styleSource = list.get(n);
            styleSource.active = !styleSource.active;
        }
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(list);
        if (nArray.length == 1) {
            MapPaintStyles.fireMapPaintStyleEntryUpdated(nArray[0]);
        } else {
            MapPaintStyles.fireMapPaintSylesUpdated();
        }
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static void addStyle(SourceEntry sourceEntry) {
        StyleSource styleSource = MapPaintStyles.fromSourceEntry(sourceEntry);
        if (styleSource != null) {
            styles.add(styleSource);
            MapPaintStyles.loadStyleForFirstTime(styleSource);
            MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(styles.getStyleSources());
            MapPaintStyles.fireMapPaintSylesUpdated();
            styles.clearCached();
            Main.map.mapView.repaint();
        }
    }

    public static void addMapPaintSylesUpdateListener(MapPaintSylesUpdateListener mapPaintSylesUpdateListener) {
        if (mapPaintSylesUpdateListener != null) {
            listeners.addIfAbsent(mapPaintSylesUpdateListener);
        }
    }

    public static void removeMapPaintSylesUpdateListener(MapPaintSylesUpdateListener mapPaintSylesUpdateListener) {
        listeners.remove(mapPaintSylesUpdateListener);
    }

    public static void fireMapPaintSylesUpdated() {
        for (MapPaintSylesUpdateListener mapPaintSylesUpdateListener : listeners) {
            mapPaintSylesUpdateListener.mapPaintStylesUpdated();
        }
    }

    public static void fireMapPaintStyleEntryUpdated(int n) {
        for (MapPaintSylesUpdateListener mapPaintSylesUpdateListener : listeners) {
            mapPaintSylesUpdateListener.mapPaintStyleEntryUpdated(n);
        }
    }

    public static interface MapPaintSylesUpdateListener {
        public void mapPaintStylesUpdated();

        public void mapPaintStyleEntryUpdated(int var1);
    }

    public static class MapPaintStyleLoader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private Collection<StyleSource> sources;

        public MapPaintStyleLoader(Collection<StyleSource> collection) {
            super(I18n.tr("Reloading style sources", new Object[0]));
            this.sources = collection;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPaintStyles.fireMapPaintSylesUpdated();
                    styles.clearCached();
                    if (Main.isDisplayingMapView()) {
                        Main.map.mapView.preferenceChanged(null);
                        Main.map.mapView.repaint();
                    }
                }
            });
        }

        @Override
        protected void realRun() {
            ProgressMonitor progressMonitor = this.getProgressMonitor();
            progressMonitor.setTicksCount(this.sources.size());
            for (StyleSource styleSource : this.sources) {
                if (this.canceled) {
                    return;
                }
                progressMonitor.subTask(I18n.tr("loading style ''{0}''...", styleSource.getDisplayString()));
                styleSource.loadStyleSource();
                progressMonitor.worked(1);
            }
        }
    }

    public static class IconReference {
        public final String iconName;
        public final StyleSource source;

        public IconReference(String string, StyleSource styleSource) {
            this.iconName = string;
            this.source = styleSource;
        }

        public String toString() {
            return "IconReference{iconName='" + this.iconName + "' source='" + this.source.getDisplayString() + "'}";
        }
    }

    public static class TagKeyReference {
        public final String key;

        public TagKeyReference(String string) {
            this.key = string;
        }

        public String toString() {
            return "TagKeyReference{key='" + this.key + "'}";
        }
    }
}

