/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.ColorScale;
import org.openstreetmap.josm.tools.I18n;

public class GpxDrawHelper {
    private GpxData data;
    private boolean forceLines;
    private boolean direction;
    private int lineWidth;
    private int maxLineLength;
    private boolean lines;
    private boolean large;
    private int largesize;
    private boolean hdopCircle;
    private boolean alternateDirection;
    private int delta;
    private double minTrackDurationForTimeColoring;
    private int hdopfactor;
    private static final double PHI = Math.toRadians(15.0);
    private boolean computeCacheInSync = false;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private boolean computeCacheColorDynamic;
    private ColorMode computeCacheColored;
    private int computeCacheColorTracksTune;
    private ColorMode colored;
    private int colorTracksTune;
    private boolean colorModeDynamic;
    private Color neutralColor;
    private int largePointAlpha;
    private ColorScale velocityScale;
    private ColorScale hdopScale;
    private ColorScale dateScale;
    private ColorScale directionScale;
    private int hdopAlpha;
    private static final int ll0 = 9;
    private static final int sl4 = 5;
    private static final int sl9 = 3;
    private static final int[][] dir = new int[][]{{5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}, {-5, -9, -9, -5}, {3, -9, -3, -9}, {9, -5, 5, -9}, {9, 3, 9, -3}, {5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}};

    private void setupColors() {
        this.hdopAlpha = Main.pref.getInteger("hdop.color.alpha", -1);
        this.velocityScale = ColorScale.createHSBScale(256).addTitle(I18n.tr("Velocity, km/h", new Object[0]));
        this.hdopScale = ColorScale.createHSBScale(256).makeReversed().addTitle(I18n.tr("HDOP, m", new Object[0]));
        this.dateScale = ColorScale.createHSBScale(256).addTitle(I18n.tr("Time", new Object[0]));
        this.directionScale = ColorScale.createCyclicScale(256).setIntervalCount(4).addTitle(I18n.tr("Direction", new Object[0]));
    }

    public GpxDrawHelper(GpxData gpxData) {
        this.data = gpxData;
        this.setupColors();
    }

    private static String specName(String string) {
        return "layer " + string;
    }

    public Color getColor(String string, boolean bl) {
        Color color = Main.pref.getColor(I18n.marktr("gps point"), GpxDrawHelper.specName(string), Color.gray);
        return bl || this.getColorMode(string) == ColorMode.NONE ? color : null;
    }

    public ColorMode getColorMode(String string) {
        try {
            int n = Main.pref.getInteger("draw.rawgps.colors", GpxDrawHelper.specName(string), 0);
            return ColorMode.values()[n];
        }
        catch (Exception exception) {
            Main.warn(exception);
            return ColorMode.NONE;
        }
    }

    public static Color getGenericColor() {
        return Main.pref.getColor(I18n.marktr("gps point"), Color.gray);
    }

    public void readPreferences(String string) {
        String string2 = GpxDrawHelper.specName(string);
        this.forceLines = Main.pref.getBoolean("draw.rawgps.lines.force", string2, false);
        this.direction = Main.pref.getBoolean("draw.rawgps.direction", string2, false);
        this.lineWidth = Main.pref.getInteger("draw.rawgps.linewidth", string2, 0);
        if (!this.data.fromServer) {
            this.maxLineLength = Main.pref.getInteger("draw.rawgps.max-line-length.local", string2, -1);
            this.lines = Main.pref.getBoolean("draw.rawgps.lines.local", string2, true);
        } else {
            this.maxLineLength = Main.pref.getInteger("draw.rawgps.max-line-length", string2, 200);
            this.lines = Main.pref.getBoolean("draw.rawgps.lines", string2, true);
        }
        this.large = Main.pref.getBoolean("draw.rawgps.large", string2, false);
        this.largesize = Main.pref.getInteger("draw.rawgps.large.size", string2, 3);
        this.hdopCircle = Main.pref.getBoolean("draw.rawgps.hdopcircle", string2, false);
        this.colored = this.getColorMode(string);
        this.alternateDirection = Main.pref.getBoolean("draw.rawgps.alternatedirection", string2, false);
        this.delta = Main.pref.getInteger("draw.rawgps.min-arrow-distance", string2, 40);
        this.colorTracksTune = Main.pref.getInteger("draw.rawgps.colorTracksTune", string2, 45);
        this.colorModeDynamic = Main.pref.getBoolean("draw.rawgps.colors.dynamic", string2, false);
        this.hdopfactor = Main.pref.getInteger("hdop.factor", 25);
        this.minTrackDurationForTimeColoring = Main.pref.getInteger("draw.rawgps.date-coloring-min-dt", 60);
        this.largePointAlpha = Main.pref.getInteger("draw.rawgps.large.alpha", -1) & 0xFF;
        this.neutralColor = this.getColor(string, true);
        this.velocityScale.setNoDataColor(this.neutralColor);
        this.dateScale.setNoDataColor(this.neutralColor);
        this.hdopScale.setNoDataColor(this.neutralColor);
        this.directionScale.setNoDataColor(this.neutralColor);
        this.largesize += this.lineWidth;
    }

    public void drawAll(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        this.checkCache();
        if (!this.computeCacheInSync) {
            this.calculateColors();
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.gpx.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.lineWidth != 0) {
            graphics2D.setStroke(new BasicStroke(this.lineWidth, 1, 1));
        }
        this.fixColors(list);
        this.drawLines(graphics2D, mapView, list);
        this.drawArrows(graphics2D, mapView, list);
        this.drawPoints(graphics2D, mapView, list);
        if (this.lineWidth != 0) {
            graphics2D.setStroke(stroke);
        }
    }

    public void calculateColors() {
        double d = 1.0E10;
        double d2 = -1.0E10;
        WayPoint object2 = null;
        if (this.colorModeDynamic) {
            double d3;
            Object object;
            if (this.colored == ColorMode.VELOCITY) {
                for (Collection<WayPoint> collection : this.data.getLinesIterable(null)) {
                    if (!this.forceLines) {
                        object2 = null;
                    }
                    for (WayPoint object3 : collection) {
                        object = object3.getCoor();
                        if (Double.isNaN(((LatLon)object).lat()) || Double.isNaN(((LatLon)object).lon())) continue;
                        if (object2 != null && object3.time > object2.time) {
                            d3 = ((LatLon)object).greatCircleDistance(object2.getCoor()) / (object3.time - object2.time);
                            if (d3 > d2) {
                                d2 = d3;
                            }
                            if (d3 < d) {
                                d = d3;
                            }
                        }
                        object2 = object3;
                    }
                }
                if (d >= d2) {
                    this.velocityScale.setRange(0.0, 33.333333333333336);
                } else {
                    this.velocityScale.setRange(d, d2);
                }
            } else if (this.colored == ColorMode.HDOP) {
                for (Collection<WayPoint> collection : this.data.getLinesIterable(null)) {
                    for (WayPoint wayPoint : collection) {
                        object = wayPoint.get("hdop");
                        if (object == null) continue;
                        d3 = ((Float)object).doubleValue();
                        if (d3 > d2) {
                            d2 = d3;
                        }
                        if (!(d3 < d)) continue;
                        d = d3;
                    }
                }
                if (d >= d2) {
                    this.hdopScale.setRange(0.0, 100.0);
                } else {
                    this.hdopScale.setRange(d, d2);
                }
            }
            object2 = null;
        } else {
            this.velocityScale.setRange(0.0, this.colorTracksTune);
            this.hdopScale.setRange(0.0, 1.0 / (double)this.hdopfactor);
        }
        double d4 = (double)System.currentTimeMillis() / 1000.0;
        if (this.colored == ColorMode.TIME) {
            Date[] dateArray = this.data.getMinMaxTimeForAllTracks();
            if (dateArray != null) {
                d = (double)((Date)dateArray[0]).getTime() / 1000.0;
                d2 = (double)((Date)dateArray[1]).getTime() / 1000.0;
            } else {
                d = 0.0;
                d2 = d4;
            }
            this.dateScale.setRange(d, d2);
        }
        for (Collection collection : this.data.getLinesIterable(null)) {
            if (!this.forceLines) {
                object2 = null;
            }
            for (WayPoint wayPoint : collection) {
                LatLon latLon = wayPoint.getCoor();
                wayPoint.customColoring = this.neutralColor;
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon())) continue;
                Color color = null;
                if (this.colored == ColorMode.HDOP) {
                    Float f = (Float)wayPoint.get("hdop");
                    color = this.hdopScale.getColor(f);
                }
                if (object2 != null) {
                    double d5 = latLon.greatCircleDistance(object2.getCoor());
                    boolean bl = false;
                    switch (this.colored) {
                        case VELOCITY: {
                            double d6 = wayPoint.time - object2.time;
                            if (d6 > 0.0) {
                                color = this.velocityScale.getColor(d5 / d6);
                                break;
                            }
                            color = this.velocityScale.getNoDataColor();
                            break;
                        }
                        case DIRECTION: {
                            double d7 = object2.getCoor().heading(wayPoint.getCoor());
                            color = this.directionScale.getColor(d7);
                            break;
                        }
                        case TIME: {
                            double d8 = wayPoint.time;
                            color = d8 > 0.0 && d8 <= d4 && d2 - d > this.minTrackDurationForTimeColoring ? this.dateScale.getColor(d8) : this.dateScale.getNoDataColor();
                        }
                    }
                    if (!bl && (this.maxLineLength == -1 || d5 <= (double)this.maxLineLength)) {
                        wayPoint.drawLine = true;
                        wayPoint.dir = (int)object2.getCoor().heading(wayPoint.getCoor());
                    } else {
                        wayPoint.drawLine = false;
                    }
                } else {
                    wayPoint.drawLine = false;
                    color = this.neutralColor;
                }
                if (color != null) {
                    wayPoint.customColoring = color;
                }
                object2 = wayPoint;
            }
        }
        this.computeCacheInSync = true;
    }

    private void drawLines(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        if (this.lines) {
            Point point = null;
            for (WayPoint wayPoint : list) {
                LatLon latLon = wayPoint.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon())) continue;
                Point point2 = mapView.getPoint(wayPoint.getEastNorth());
                if (wayPoint.drawLine && point != null && (point.x != point2.x || point.y != point2.y)) {
                    graphics2D.setColor(wayPoint.customColoring);
                    graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
                }
                point = point2;
            }
        }
    }

    private void drawArrows(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        Point point;
        LatLon latLon;
        Point point2;
        Point point3;
        if (this.lines && this.direction && !this.alternateDirection) {
            point3 = null;
            point2 = null;
            for (WayPoint wayPoint : list) {
                latLon = wayPoint.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon()) || !wayPoint.drawLine) continue;
                point = mapView.getPoint(wayPoint.getEastNorth());
                if (point3 != null && (point2 == null || point.x < point2.x - this.delta || point.x > point2.x + this.delta || point.y < point2.y - this.delta || point.y > point2.y + this.delta)) {
                    graphics2D.setColor(wayPoint.customColoring);
                    double d = Math.atan2(point.y - point3.y, point.x - point3.x) + Math.PI;
                    graphics2D.drawLine(point.x, point.y, (int)((double)point.x + 10.0 * Math.cos(d - PHI)), (int)((double)point.y + 10.0 * Math.sin(d - PHI)));
                    graphics2D.drawLine(point.x, point.y, (int)((double)point.x + 10.0 * Math.cos(d + PHI)), (int)((double)point.y + 10.0 * Math.sin(d + PHI)));
                    point2 = point;
                }
                point3 = point;
            }
        }
        if (this.lines && this.direction && this.alternateDirection) {
            point3 = null;
            point2 = null;
            for (WayPoint wayPoint : list) {
                latLon = wayPoint.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon()) || !wayPoint.drawLine) continue;
                point = mapView.getPoint(wayPoint.getEastNorth());
                if (point3 != null && (point2 == null || point.x < point2.x - this.delta || point.x > point2.x + this.delta || point.y < point2.y - this.delta || point.y > point2.y + this.delta)) {
                    graphics2D.setColor(wayPoint.customColoring);
                    graphics2D.drawLine(point.x, point.y, point.x + dir[wayPoint.dir][0], point.y + dir[wayPoint.dir][1]);
                    graphics2D.drawLine(point.x, point.y, point.x + dir[wayPoint.dir][2], point.y + dir[wayPoint.dir][3]);
                    point2 = point;
                }
                point3 = point;
            }
        }
    }

    private void drawPoints(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        Serializable serializable;
        if (this.large || this.hdopCircle) {
            int n = this.largesize / 2;
            for (WayPoint wayPoint : list) {
                serializable = wayPoint.getCoor();
                if (Double.isNaN(serializable.lat()) || Double.isNaN(serializable.lon())) continue;
                Point point = mapView.getPoint(wayPoint.getEastNorth());
                if (this.hdopCircle && wayPoint.get("hdop") != null) {
                    float f = ((Float)wayPoint.get("hdop")).floatValue();
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    Color color = this.hdopAlpha < 0 ? wayPoint.customColoring : new Color(wayPoint.customColoring.getRGB() & 0xFFFFFF | this.hdopAlpha << 24, true);
                    graphics2D.setColor(color);
                    int n2 = mapView.getPoint((LatLon)new LatLon((double)wayPoint.getCoor().lat(), (double)(wayPoint.getCoor().lon() + (double)(12.0f * f * 360.0f / 4.0E7f)))).x - point.x;
                    graphics2D.drawArc(point.x - n2 / 2, point.y - n2 / 2, n2, n2, 0, 360);
                }
                if (!this.large) continue;
                if (wayPoint.customColoring != null) {
                    Color color = this.largePointAlpha < 0 ? wayPoint.customColoring : new Color(wayPoint.customColoring.getRGB() & 0xFFFFFF | this.largePointAlpha << 24, true);
                    graphics2D.setColor(color);
                }
                graphics2D.fillRect(point.x - n, point.y - n, this.largesize, this.largesize);
            }
        }
        if (!this.large && this.lines) {
            graphics2D.setColor(this.neutralColor);
            for (WayPoint wayPoint : list) {
                LatLon latLon = wayPoint.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon()) || wayPoint.drawLine) continue;
                serializable = mapView.getPoint(wayPoint.getEastNorth());
                graphics2D.drawRect(((Point)serializable).x, ((Point)serializable).y, 0, 0);
            }
        }
        if (!this.large && !this.lines) {
            graphics2D.setColor(this.neutralColor);
            for (WayPoint wayPoint : list) {
                LatLon latLon = wayPoint.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon())) continue;
                serializable = mapView.getPoint(wayPoint.getEastNorth());
                graphics2D.setColor(wayPoint.customColoring);
                graphics2D.drawRect(((Point)serializable).x, ((Point)serializable).y, 0, 0);
            }
        }
    }

    private void fixColors(List<WayPoint> list) {
        for (WayPoint wayPoint : list) {
            if (wayPoint.customColoring != null) continue;
            wayPoint.customColoring = this.neutralColor;
        }
    }

    private void checkCache() {
        if (this.computeCacheMaxLineLengthUsed != this.maxLineLength || !this.neutralColor.equals(this.computeCacheColorUsed) || this.computeCacheColored != this.colored || this.computeCacheColorTracksTune != this.colorTracksTune || this.computeCacheColorDynamic != this.colorModeDynamic) {
            this.computeCacheMaxLineLengthUsed = this.maxLineLength;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = this.neutralColor;
            this.computeCacheColored = this.colored;
            this.computeCacheColorTracksTune = this.colorTracksTune;
            this.computeCacheColorDynamic = this.colorModeDynamic;
        }
    }

    public void dataChanged() {
        this.computeCacheInSync = false;
    }

    public void drawColorBar(Graphics2D graphics2D, MapView mapView) {
        int n = mapView.getWidth();
        if (this.colored == ColorMode.HDOP) {
            this.hdopScale.drawColorBar(graphics2D, n - 30, 50, 20, 100, 1.0);
        } else if (this.colored == ColorMode.VELOCITY) {
            this.velocityScale.drawColorBar(graphics2D, n - 30, 50, 20, 100, 3.6);
        } else if (this.colored == ColorMode.DIRECTION) {
            this.directionScale.drawColorBar(graphics2D, n - 30, 50, 20, 100, 57.29577951308232);
        }
    }

    public static enum ColorMode {
        NONE,
        VELOCITY,
        HDOP,
        DIRECTION,
        TIME;

    }
}

