/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.widgets.DateEditorWithSlider;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class DateFilterPanel
extends JPanel {
    private DateEditorWithSlider dateFrom = new DateEditorWithSlider(I18n.tr("From", new Object[0]));
    private DateEditorWithSlider dateTo = new DateEditorWithSlider(I18n.tr("To", new Object[0]));
    private JCheckBox noTimestampCb = new JCheckBox(I18n.tr("No timestamp", new Object[0]));
    private transient GpxLayer layer;
    private transient ActionListener filterAppliedListener;
    private final String PREF_DATE_0;
    private final String PREF_DATE_MIN;
    private final String PREF_DATE_MAX;
    private transient ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (DateFilterPanel.this.isEnabled()) {
                DateFilterPanel.this.applyFilterWithDelay();
            }
        }
    };
    private Timer t = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DateFilterPanel.this.applyFilter();
        }
    });

    public DateFilterPanel(GpxLayer gpxLayer, String string, boolean bl) {
        super(new GridBagLayout());
        this.PREF_DATE_0 = string + ".showzerotimestamp";
        this.PREF_DATE_MIN = string + ".mintime";
        this.PREF_DATE_MAX = string + ".maxtime";
        this.layer = gpxLayer;
        Date[] dateArray = gpxLayer.data.getMinMaxTimeForAllTracks();
        Date date = dateArray == null ? new GregorianCalendar(2000, 1, 1).getTime() : dateArray[0];
        Date date2 = dateArray == null ? new Date() : dateArray[1];
        this.dateFrom.setDate(date);
        this.dateTo.setDate(date2);
        this.dateFrom.setRange(date, date2);
        this.dateTo.setRange(date, date2);
        this.add((Component)this.noTimestampCb, GBC.std().grid(1, 1).insets(0, 0, 5, 0));
        this.add((Component)this.dateFrom, GBC.std().grid(2, 1).fill(2));
        this.add((Component)this.dateTo, GBC.eol().grid(3, 1).fill(2));
        this.setEnabled(bl);
        this.dateFrom.addDateListener(this.changeListener);
        this.dateTo.addDateListener(this.changeListener);
        this.noTimestampCb.addChangeListener(this.changeListener);
    }

    public void applyFilterWithDelay() {
        if (this.t.isRunning()) {
            this.t.restart();
        } else {
            this.t.start();
        }
    }

    public void applyFilter() {
        this.t.stop();
        this.filterTracksByDate();
        if (this.filterAppliedListener != null) {
            this.filterAppliedListener.actionPerformed(null);
        }
    }

    public void saveInPrefs() {
        Main.pref.putLong(this.PREF_DATE_MIN, this.dateFrom.getDate().getTime());
        Main.pref.putLong(this.PREF_DATE_MAX, this.dateTo.getDate().getTime());
        Main.pref.put(this.PREF_DATE_0, this.noTimestampCb.isSelected());
    }

    public void loadFromPrefs() {
        long l;
        long l2 = Main.pref.getLong(this.PREF_DATE_MIN, 0L);
        if (l2 != 0L) {
            this.dateFrom.setDate(new Date(l2));
        }
        if ((l = Main.pref.getLong(this.PREF_DATE_MAX, 0L)) != 0L) {
            this.dateTo.setDate(new Date(l));
        }
        this.noTimestampCb.setSelected(Main.pref.getBoolean(this.PREF_DATE_0, false));
    }

    public void setFilterAppliedListener(ActionListener actionListener) {
        this.filterAppliedListener = actionListener;
    }

    private void filterTracksByDate() {
        Date date = this.dateFrom.getDate();
        Date date2 = this.dateTo.getDate();
        this.layer.filterTracksByDate(date, date2, this.noTimestampCb.isSelected());
    }

    @Override
    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
    }
}

