/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.ConfigurationParameterRequestHandler;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UploadParameterSummaryPanel
extends JPanel
implements HyperlinkListener,
PropertyChangeListener {
    private transient UploadStrategySpecification spec = new UploadStrategySpecification();
    private int numObjects;
    private JMultilineLabel jepMessage;
    private JLabel lblWarning;
    private transient Changeset selectedChangeset;
    private boolean closeChangesetAfterNextUpload;
    private transient ConfigurationParameterRequestHandler configHandler;

    protected String buildChangesetSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.selectedChangeset == null || this.selectedChangeset.isNew()) {
            stringBuilder.append(I18n.tr("Objects are uploaded to a <strong>new changeset</strong>.", new Object[0]));
        } else {
            String string = this.selectedChangeset.get("comment") == null ? "" : this.selectedChangeset.get("comment");
            stringBuilder.append(I18n.tr("Objects are uploaded to the <strong>open changeset</strong> {0} with upload comment ''{1}''.", this.selectedChangeset.getId(), string));
        }
        stringBuilder.append(" ");
        if (this.closeChangesetAfterNextUpload) {
            stringBuilder.append(I18n.tr("The changeset is going to be <strong>closed</strong> after this upload", new Object[0]));
        } else {
            stringBuilder.append(I18n.tr("The changeset is <strong>left open</strong> after this upload", new Object[0]));
        }
        stringBuilder.append(" (<a href=\"urn:changeset-configuration\">" + I18n.tr("configure changeset", new Object[0]) + "</a>)");
        return stringBuilder.toString();
    }

    protected String buildStrategySummary() {
        if (this.spec == null) {
            return "";
        }
        boolean bl = true;
        int n = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
        if (n > 0 && this.numObjects > n) {
            bl = false;
        }
        int n2 = this.spec.getNumRequests(this.numObjects);
        String string = null;
        if (bl) {
            this.lblWarning.setVisible(false);
            if (n2 == 0) {
                string = I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong>", this.numObjects, this.numObjects);
            } else if (n2 == 1) {
                string = I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", this.numObjects, this.numObjects);
            } else if (n2 > 1) {
                string = I18n.tr("Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>{1} requests</strong>", this.numObjects, n2);
            }
            string = string + " (<a href=\"urn:advanced-configuration\">" + I18n.tr("advanced configuration", new Object[0]) + "</a>)";
        } else {
            this.lblWarning.setVisible(true);
            if (n2 == 0) {
                string = I18n.tr("{0} objects exceed the max. allowed {1} objects in a changeset on the server ''{2}''. Please <a href=\"urn:advanced-configuration\">configure</a> how to proceed with <strong>multiple changesets</strong>", this.numObjects, n, OsmApi.getOsmApi().getBaseUrl());
            } else if (n2 > 1) {
                string = I18n.tr("Uploading <strong>{0} objects</strong> to <strong>multiple changesets</strong> using <strong>{1} requests</strong>", this.numObjects, n2);
                string = string + " (<a href=\"urn:advanced-configuration\">" + I18n.tr("advanced configuration", new Object[0]) + "</a>)";
            }
        }
        return string;
    }

    protected void build() {
        this.jepMessage = new JMultilineLabel("");
        this.jepMessage.addHyperlinkListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jepMessage, "Center");
        this.lblWarning = new JLabel("");
        this.lblWarning.setVisible(false);
        this.lblWarning.setIcon(ImageProvider.get("warning-small"));
        this.lblWarning.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.lblWarning, "North");
        this.add((Component)jPanel, "West");
    }

    public UploadParameterSummaryPanel() {
        this.build();
        this.updateSummary();
    }

    public void setConfigurationParameterRequestListener(ConfigurationParameterRequestHandler configurationParameterRequestHandler) {
        this.configHandler = configurationParameterRequestHandler;
    }

    public void setUploadStrategySpecification(UploadStrategySpecification uploadStrategySpecification) {
        this.spec = uploadStrategySpecification;
        this.updateSummary();
    }

    public void setNumObjects(int n) {
        this.numObjects = n;
        this.updateSummary();
    }

    public void setCloseChangesetAfterNextUpload(boolean bl) {
        this.closeChangesetAfterNextUpload = bl;
        this.updateSummary();
    }

    protected void updateSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.buildStrategySummary());
        stringBuilder.append("<br><br>");
        stringBuilder.append(this.buildChangesetSummary());
        stringBuilder.append("</html>");
        this.jepMessage.setText(stringBuilder.toString());
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
            String string = hyperlinkEvent.getDescription();
            if (string == null || this.configHandler == null) {
                return;
            }
            if ("urn:changeset-configuration".equals(string)) {
                this.configHandler.handleChangesetConfigurationRequest();
            } else if ("urn:advanced-configuration".equals(string)) {
                this.configHandler.handleUploadStrategyConfigurationRequest();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            this.selectedChangeset = (Changeset)propertyChangeEvent.getNewValue();
            this.updateSummary();
        } else if (propertyChangeEvent.getPropertyName().equals(ChangesetManagementPanel.CLOSE_CHANGESET_AFTER_UPLOAD)) {
            this.closeChangesetAfterNextUpload = (Boolean)propertyChangeEvent.getNewValue();
            this.updateSummary();
        } else if (propertyChangeEvent.getPropertyName().equals(UploadedObjectsSummaryPanel.NUM_OBJECTS_TO_UPLOAD_PROP)) {
            this.numObjects = (Integer)propertyChangeEvent.getNewValue();
            this.updateSummary();
        } else if (propertyChangeEvent.getPropertyName().equals(UploadStrategySelectionPanel.UPLOAD_STRATEGY_SPECIFICATION_PROP)) {
            this.spec = (UploadStrategySpecification)propertyChangeEvent.getNewValue();
            this.updateSummary();
        }
    }
}

