/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagSettingsPanel
extends JPanel
implements TableModelListener {
    private final TagEditorPanel pnlTagEditor = new TagEditorPanel(null);
    private final transient ChangesetCommentModel changesetCommentModel;
    private final transient ChangesetCommentModel changesetSourceModel;
    private final transient Map<String, String> defaultTags = new HashMap<String, String>();

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlTagEditor, "Center");
    }

    public TagSettingsPanel(ChangesetCommentModel changesetCommentModel, ChangesetCommentModel changesetCommentModel2) {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel2, "changesetSourceModel");
        this.changesetCommentModel = changesetCommentModel;
        this.changesetSourceModel = changesetCommentModel2;
        this.changesetCommentModel.addObserver(new ChangesetCommentObserver("comment"));
        this.changesetSourceModel.addObserver(new ChangesetCommentObserver("source"));
        this.build();
        this.pnlTagEditor.getModel().addTableModelListener(this);
    }

    protected void setProperty(String string, String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if ((string2 = string2.trim()).equals(string3 = this.getTagEditorValue(string))) {
            return;
        }
        if (string2.isEmpty()) {
            this.pnlTagEditor.getModel().delete(string);
            return;
        }
        TagModel tagModel = this.pnlTagEditor.getModel().get(string);
        if (tagModel == null) {
            tagModel = new TagModel(string, string2);
            this.pnlTagEditor.getModel().add(tagModel);
        } else {
            this.pnlTagEditor.getModel().updateTagValue(tagModel, string2);
        }
    }

    protected String getTagEditorValue(String string) {
        TagModel tagModel = this.pnlTagEditor.getModel().get(string);
        if (tagModel == null) {
            return null;
        }
        return tagModel.getValue();
    }

    public void initFromChangeset(Changeset changeset) {
        Map<String, String> map = this.getDefaultTags();
        if (changeset != null) {
            map.putAll(changeset.getKeys());
        }
        if (map.get("comment") == null) {
            map.put("comment", this.getTagEditorValue("comment"));
        }
        if (map.get("source") == null) {
            map.put("source", this.getTagEditorValue("source"));
        }
        String string = Version.getInstance().getAgentString(false);
        String string2 = map.get("created_by");
        if (string2 == null || string2.isEmpty()) {
            map.put("created_by", string);
        } else if (!string2.contains(string)) {
            map.put("created_by", string2 + ";" + string);
        }
        this.pnlTagEditor.getModel().initFromTags(map);
    }

    public Map<String, String> getTags(boolean bl) {
        return this.pnlTagEditor.getModel().getTags(bl);
    }

    public Map<String, String> getDefaultTags() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.defaultTags);
        return hashMap;
    }

    public void setDefaultTags(Map<String, String> map) {
        this.defaultTags.clear();
        this.defaultTags.putAll(map);
        this.tableChanged(null);
    }

    public void startUserInput() {
        this.pnlTagEditor.initAutoCompletion(Main.main.getEditLayer());
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.changesetCommentModel.setComment(this.getTagEditorValue("comment"));
        this.changesetSourceModel.setComment(this.getTagEditorValue("source"));
    }

    class ChangesetCommentObserver
    implements Observer {
        private final String key;

        ChangesetCommentObserver(String string) {
            this.key = string;
        }

        @Override
        public void update(Observable observable, Object object) {
            if (!(observable instanceof ChangesetCommentModel)) {
                return;
            }
            String string = (String)object;
            String string2 = TagSettingsPanel.this.getTagEditorValue(this.key);
            if (string2 == null) {
                string2 = "";
            }
            if (!string2.equals(string)) {
                TagSettingsPanel.this.setProperty(this.key, (String)object);
            }
        }
    }
}

