/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadFileTask
extends PleaseWaitRunnable {
    private final String address;
    private final File file;
    private final boolean mkdir;
    private final boolean unpack;
    private boolean canceled;
    private HttpURLConnection downloadConnection;

    public DownloadFileTask(Component component, String string, File file, boolean bl, boolean bl2) {
        super(component, I18n.tr("Downloading file", new Object[0]), false);
        this.address = string;
        this.file = file;
        this.mkdir = bl;
        this.unpack = bl2;
    }

    private synchronized void closeConnectionIfNeeded() {
        if (this.downloadConnection != null) {
            this.downloadConnection.disconnect();
        }
        this.downloadConnection = null;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        this.closeConnectionIfNeeded();
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws DownloadException {
        try {
            int n;
            Serializable serializable;
            if (this.mkdir && !((File)(serializable = this.file.getParentFile())).exists()) {
                ((File)serializable).mkdirs();
            }
            serializable = new URL(this.address);
            Object object = this;
            synchronized (object) {
                this.downloadConnection = Utils.openHttpConnection((URL)serializable);
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.connect();
                n = this.downloadConnection.getContentLength();
            }
            this.progressMonitor.setTicksCount(100);
            this.progressMonitor.subTask(I18n.tr("Downloading File {0}: {1} bytes...", this.file.getName(), n));
            object = this.downloadConnection.getInputStream();
            Throwable throwable = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                byte[] byArray = new byte[32768];
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = ((InputStream)object).read(byArray);
                while (n5 != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n5);
                    n2 += n5;
                    if (this.canceled) {
                        break;
                    }
                    n4 = 100 * n2 / n;
                    if (n4 != n3) {
                        this.progressMonitor.setTicks(n4);
                        n3 = n4;
                    }
                    n5 = ((InputStream)object).read(byArray);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            if (!this.canceled) {
                Main.info(I18n.tr("Download finished", new Object[0]));
                if (this.unpack) {
                    Main.info(I18n.tr("Unpacking {0} into {1}", this.file.getAbsolutePath(), this.file.getParent()));
                    DownloadFileTask.unzipFileRecursively(this.file, this.file.getParent());
                    this.file.delete();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            String string = I18n.tr("Cannot download file ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", this.file.getName(), this.address);
            Main.warn(string);
            throw new DownloadException(string);
        }
        catch (IOException iOException) {
            if (this.canceled) {
                return;
            }
            throw new DownloadException(iOException.getMessage());
        }
        finally {
            this.closeConnectionIfNeeded();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        if (this.canceled) {
            return;
        }
        try {
            this.download();
        }
        catch (DownloadException downloadException) {
            Main.error(downloadException);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public static void unzipFileRecursively(File file, String string) throws IOException {
        try (ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = new File(string, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    Throwable throwable2 = null;
                    try {
                        int n;
                        byte[] byArray = new byte[8192];
                        while ((n = inputStream.read(byArray)) != -1) {
                            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)bufferedOutputStream).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)bufferedOutputStream).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    private static class DownloadException
    extends Exception {
        public DownloadException(String string) {
            super(string);
        }
    }
}

