/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.download.BookmarkSelection;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.download.PlaceSelection;
import org.openstreetmap.josm.gui.download.SlippyMapChooser;
import org.openstreetmap.josm.gui.download.TileSelection;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class DownloadDialog
extends JDialog {
    private static DownloadDialog instance;
    protected SlippyMapChooser slippyMapChooser;
    protected final transient List<DownloadSelection> downloadSelections = new ArrayList<DownloadSelection>();
    protected final JTabbedPane tpDownloadAreaSelectors = new JTabbedPane();
    protected JCheckBox cbNewLayer;
    protected JCheckBox cbStartup;
    protected final JLabel sizeCheck = new JLabel();
    protected transient Bounds currentBounds = null;
    protected boolean canceled;
    protected JCheckBox cbDownloadOsmData;
    protected JCheckBox cbDownloadGpxData;
    protected JCheckBox cbDownloadNotes;
    private DownloadAction actDownload;
    protected SideButton btnDownload;

    public static synchronized DownloadDialog getInstance() {
        if (instance == null) {
            instance = new DownloadDialog(Main.parent);
        }
        return instance;
    }

    private void makeCheckBoxRespondToEnter(JCheckBox jCheckBox) {
        jCheckBox.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "doDownload");
        jCheckBox.getActionMap().put("doDownload", this.actDownload);
    }

    protected final JPanel buildMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DownloadDialog.this.updateSizeCheck();
            }
        };
        jPanel.add((Component)new JLabel(I18n.tr("Data Sources and Types:", new Object[0])), GBC.std().insets(5, 5, 1, 5));
        this.cbDownloadOsmData = new JCheckBox(I18n.tr("OpenStreetMap data", new Object[0]), true);
        this.cbDownloadOsmData.setToolTipText(I18n.tr("Select to download OSM data in the selected download area.", new Object[0]));
        this.cbDownloadOsmData.getModel().addChangeListener(changeListener);
        jPanel.add((Component)this.cbDownloadOsmData, GBC.std().insets(1, 5, 1, 5));
        this.cbDownloadGpxData = new JCheckBox(I18n.tr("Raw GPS data", new Object[0]));
        this.cbDownloadGpxData.setToolTipText(I18n.tr("Select to download GPS traces in the selected download area.", new Object[0]));
        this.cbDownloadGpxData.getModel().addChangeListener(changeListener);
        jPanel.add((Component)this.cbDownloadGpxData, GBC.std().insets(5, 5, 1, 5));
        this.cbDownloadNotes = new JCheckBox(I18n.tr("Notes", new Object[0]));
        this.cbDownloadNotes.setToolTipText(I18n.tr("Select to download notes in the selected download area.", new Object[0]));
        this.cbDownloadNotes.getModel().addChangeListener(changeListener);
        jPanel.add((Component)this.cbDownloadNotes, GBC.eol().insets(50, 5, 1, 5));
        this.buildMainPanelAboveDownloadSelections(jPanel);
        this.slippyMapChooser = new SlippyMapChooser();
        this.downloadSelections.add(this.slippyMapChooser);
        this.downloadSelections.add(new BookmarkSelection());
        this.downloadSelections.add(new BoundingBoxSelection());
        this.downloadSelections.add(new PlaceSelection());
        this.downloadSelections.add(new TileSelection());
        PluginHandler.addDownloadSelection(this.downloadSelections);
        for (DownloadSelection object : this.downloadSelections) {
            object.addGui(this);
        }
        jPanel.add((Component)this.tpDownloadAreaSelectors, GBC.eol().fill());
        try {
            this.tpDownloadAreaSelectors.setSelectedIndex(Main.pref.getInteger("download.tab", 0));
        }
        catch (Exception exception) {
            Main.pref.putInteger("download.tab", 0);
        }
        Font font = this.sizeCheck.getFont();
        this.sizeCheck.setFont(font.deriveFont(0, font.getSize()));
        this.cbNewLayer = new JCheckBox(I18n.tr("Download as new layer", new Object[0]));
        this.cbNewLayer.setToolTipText(I18n.tr("<html>Select to download data into a new data layer.<br>Unselect to download into the currently active data layer.</html>", new Object[0]));
        this.cbStartup = new JCheckBox(I18n.tr("Open this dialog on startup", new Object[0]));
        this.cbStartup.setToolTipText(I18n.tr("<html>Autostart ''Download from OSM'' dialog every time JOSM is started.<br>You can open it manually from File menu or toolbar.</html>", new Object[0]));
        this.cbStartup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.pref.put("download.autorun", DownloadDialog.this.cbStartup.isSelected());
            }
        });
        jPanel.add((Component)this.cbNewLayer, GBC.std().anchor(17).insets(5, 5, 5, 5));
        jPanel.add((Component)this.cbStartup, GBC.std().anchor(17).insets(15, 5, 5, 5));
        jPanel.add((Component)this.sizeCheck, GBC.eol().anchor(13).insets(5, 5, 5, 2));
        if (!ExpertToggleAction.isExpert()) {
            JLabel jLabel = new JLabel(I18n.tr("Use left click&drag to select area, arrows or right mouse button to scroll map, wheel or +/- to zoom.", new Object[0]));
            jPanel.add((Component)jLabel, GBC.eol().anchor(15).insets(0, 0, 0, 0));
        }
        return jPanel;
    }

    @Override
    public void paint(Graphics graphics) {
        this.tpDownloadAreaSelectors.getSelectedComponent().paint(graphics);
        super.paint(graphics);
    }

    protected final JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.actDownload = new DownloadAction();
        this.btnDownload = new SideButton(this.actDownload);
        jPanel.add(this.btnDownload);
        InputMapUtils.enableEnter(this.btnDownload);
        this.makeCheckBoxRespondToEnter(this.cbDownloadGpxData);
        this.makeCheckBoxRespondToEnter(this.cbDownloadOsmData);
        this.makeCheckBoxRespondToEnter(this.cbDownloadNotes);
        this.makeCheckBoxRespondToEnter(this.cbNewLayer);
        CancelAction cancelAction = new CancelAction();
        SideButton sideButton = new SideButton(cancelAction);
        jPanel.add(sideButton);
        InputMapUtils.enableEnter(sideButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", cancelAction);
        SideButton sideButton2 = new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Download")));
        jPanel.add(sideButton2);
        InputMapUtils.enableEnter(sideButton2);
        return jPanel;
    }

    public DownloadDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), I18n.tr("Download", new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildMainPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(86, 2), "checkClipboardContents");
        this.getRootPane().getActionMap().put("checkClipboardContents", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Utils.getClipboardContent();
                if (string == null) {
                    return;
                }
                Bounds bounds = OsmUrlToBounds.parse(string);
                if (bounds != null) {
                    DownloadDialog.this.boundingBoxChanged(new Bounds(bounds), null);
                }
            }
        });
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Download"));
        this.addWindowListener(new WindowEventHandler());
        this.restoreSettings();
    }

    private void updateSizeCheck() {
        boolean bl = false;
        if (this.currentBounds == null) {
            this.sizeCheck.setText(I18n.tr("No area selected yet", new Object[0]));
            this.sizeCheck.setForeground(Color.darkGray);
        } else if (this.isDownloadNotes() && !this.isDownloadOsmData() && !this.isDownloadGpxData()) {
            bl = this.currentBounds.getArea() > Main.pref.getDouble("osm-server.max-request-area-notes", 25.0);
        } else {
            boolean bl2 = bl = this.currentBounds.getArea() > Main.pref.getDouble("osm-server.max-request-area", 0.25);
        }
        if (bl) {
            this.sizeCheck.setText(I18n.tr("Download area too large; will probably be rejected by server", new Object[0]));
            this.sizeCheck.setForeground(Color.red);
        } else {
            this.sizeCheck.setText(I18n.tr("Download area ok, size probably acceptable to server", new Object[0]));
            this.sizeCheck.setForeground(Color.darkGray);
        }
    }

    public void boundingBoxChanged(Bounds bounds, DownloadSelection downloadSelection) {
        this.currentBounds = bounds;
        for (DownloadSelection downloadSelection2 : this.downloadSelections) {
            if (downloadSelection2 == downloadSelection) continue;
            downloadSelection2.setDownloadArea(this.currentBounds);
        }
        this.updateSizeCheck();
    }

    public void startDownload(Bounds bounds) {
        this.currentBounds = bounds;
        this.actDownload.run();
    }

    public boolean isDownloadOsmData() {
        return this.cbDownloadOsmData.isSelected();
    }

    public boolean isDownloadGpxData() {
        return this.cbDownloadGpxData.isSelected();
    }

    public boolean isDownloadNotes() {
        return this.cbDownloadNotes.isSelected();
    }

    public boolean isNewLayerRequired() {
        return this.cbNewLayer.isSelected();
    }

    public void addDownloadAreaSelector(JPanel jPanel, String string) {
        this.tpDownloadAreaSelectors.add(string, jPanel);
    }

    public final void refreshTileSources() {
        if (this.slippyMapChooser != null) {
            this.slippyMapChooser.refreshTileSources();
        }
    }

    public void rememberSettings() {
        Main.pref.put("download.tab", Integer.toString(this.tpDownloadAreaSelectors.getSelectedIndex()));
        Main.pref.put("download.osm", this.cbDownloadOsmData.isSelected());
        Main.pref.put("download.gps", this.cbDownloadGpxData.isSelected());
        Main.pref.put("download.notes", this.cbDownloadNotes.isSelected());
        Main.pref.put("download.newlayer", this.cbNewLayer.isSelected());
        if (this.currentBounds != null) {
            Main.pref.put("osm-download.bounds", this.currentBounds.encodeAsString(";"));
        }
    }

    public void restoreSettings() {
        this.cbDownloadOsmData.setSelected(Main.pref.getBoolean("download.osm", true));
        this.cbDownloadGpxData.setSelected(Main.pref.getBoolean("download.gps", false));
        this.cbDownloadNotes.setSelected(Main.pref.getBoolean("download.notes", false));
        this.cbNewLayer.setSelected(Main.pref.getBoolean("download.newlayer", false));
        this.cbStartup.setSelected(DownloadDialog.isAutorunEnabled());
        int n = Main.pref.getInteger("download.tab", 0);
        if (n < 0 || n > this.tpDownloadAreaSelectors.getTabCount()) {
            n = 0;
        }
        this.tpDownloadAreaSelectors.setSelectedIndex(n);
        if (Main.isDisplayingMapView()) {
            MapView mapView = Main.map.mapView;
            this.currentBounds = new Bounds(mapView.getLatLon(0, mapView.getHeight()), mapView.getLatLon(mapView.getWidth(), 0));
            this.boundingBoxChanged(this.currentBounds, null);
        } else {
            Bounds bounds = DownloadDialog.getSavedDownloadBounds();
            if (bounds != null) {
                this.currentBounds = bounds;
                this.boundingBoxChanged(this.currentBounds, null);
            }
        }
    }

    public static Bounds getSavedDownloadBounds() {
        String string = Main.pref.get("osm-download.bounds");
        if (!string.isEmpty()) {
            try {
                return new Bounds(string, ";");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.warn(illegalArgumentException);
            }
        }
        return null;
    }

    public static boolean isAutorunEnabled() {
        return Main.pref.getBoolean("download.autorun", false);
    }

    public static void autostartIfNeeded() {
        if (DownloadDialog.isAutorunEnabled()) {
            Main.main.menu.download.actionPerformed(null);
        }
    }

    public Bounds getSelectedDownloadArea() {
        return this.currentBounds;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    protected void buildMainPanelAboveDownloadSelections(JPanel jPanel) {
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().run();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            DownloadDialog.this.btnDownload.requestFocusInWindow();
        }
    }

    class DownloadAction
    extends AbstractAction {
        public DownloadAction() {
            this.putValue("Name", I18n.tr("Download", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.putValue("ShortDescription", I18n.tr("Click to download the currently selected area", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        public void run() {
            if (DownloadDialog.this.currentBounds == null) {
                JOptionPane.showMessageDialog(DownloadDialog.this, I18n.tr("Please select a download area first.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return;
            }
            if (!(DownloadDialog.this.isDownloadOsmData() || DownloadDialog.this.isDownloadGpxData() || DownloadDialog.this.isDownloadNotes())) {
                JOptionPane.showMessageDialog(DownloadDialog.this, I18n.tr("<html>Neither <strong>{0}</strong> nor <strong>{1}</strong> nor <strong>{2}</strong> is enabled.<br>Please choose to either download OSM data, or GPX data, or Notes, or all.</html>", DownloadDialog.this.cbDownloadOsmData.getText(), DownloadDialog.this.cbDownloadGpxData.getText(), DownloadDialog.this.cbDownloadNotes.getText()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
            DownloadDialog.this.setCanceled(false);
            DownloadDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort downloading", new Object[0]));
        }

        public void run() {
            DownloadDialog.this.setCanceled(true);
            DownloadDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }
}

