/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

class TagEditHelper {
    private final DefaultTableModel tagData;
    private final Map<String, Map<String, Integer>> valueCount;
    private Collection<OsmPrimitive> sel;
    private String changedKey;
    private String objKey;
    private Comparator<AutoCompletionListItem> defaultACItemComparator = new Comparator<AutoCompletionListItem>(){

        @Override
        public int compare(AutoCompletionListItem autoCompletionListItem, AutoCompletionListItem autoCompletionListItem2) {
            return String.CASE_INSENSITIVE_ORDER.compare(autoCompletionListItem.getValue(), autoCompletionListItem2.getValue());
        }
    };
    private String lastAddKey = null;
    private String lastAddValue = null;
    public static final int DEFAULT_LRU_TAGS_NUMBER = 5;
    public static final int MAX_LRU_TAGS_NUMBER = 30;
    private final Map<Tag, Void> recentTags = new LinkedHashMap<Tag, Void>(31, 1.1f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Tag, Void> entry) {
            return this.size() > 30;
        }
    };
    public static final BooleanProperty PROPERTY_FIX_TAG_LOCALE = new BooleanProperty("properties.fix-tag-combobox-locale", false);
    public static final BooleanProperty PROPERTY_REMEMBER_TAGS = new BooleanProperty("properties.remember-recently-added-tags", true);
    public static final IntegerProperty PROPERTY_RECENT_TAGS_NUMBER = new IntegerProperty("properties.recently-added-tags", 5);

    TagEditHelper(DefaultTableModel defaultTableModel, Map<String, Map<String, Integer>> map) {
        this.tagData = defaultTableModel;
        this.valueCount = map;
    }

    public void addTag() {
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        AddTagsDialog addTagsDialog = new AddTagsDialog();
        addTagsDialog.showDialog();
        addTagsDialog.destroyActions();
        if (addTagsDialog.getValue() == 1) {
            addTagsDialog.performTagAdding();
        } else {
            addTagsDialog.undoAllTagsAdding();
        }
    }

    public void editTag(int n, boolean bl) {
        String string;
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        this.objKey = string = this.tagData.getValueAt(n, 0).toString();
        EditTagDialog editTagDialog = new EditTagDialog(string, (Map)this.tagData.getValueAt(n, 1), bl);
        editTagDialog.showDialog();
        if (editTagDialog.getValue() != 1) {
            return;
        }
        editTagDialog.performTagEdit();
    }

    public String getChangedKey() {
        return this.changedKey;
    }

    public void resetChangedKey() {
        this.changedKey = null;
    }

    private static List<String> getAutocompletionKeys(String string) {
        if ("name".equals(string) || "addr:street".equals(string)) {
            return Arrays.asList("addr:street", "name");
        }
        return Arrays.asList(string);
    }

    public void loadTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && this.recentTags.isEmpty()) {
            this.recentTags.clear();
            Collection<String> collection = Main.pref.getCollection("properties.recent-tags");
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = iterator.next();
                this.recentTags.put(new Tag(string, string2), null);
            }
        }
    }

    public void saveTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && !this.recentTags.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.recentTags.size() * 2);
            for (Tag tag : this.recentTags.keySet()) {
                arrayList.add(tag.getKey());
                arrayList.add(tag.getValue());
            }
            Main.pref.putCollection("properties.recent-tags", arrayList);
        }
    }

    private boolean warnOverwriteKey(String string, String string2) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite key", new Object[0]), new String[]{I18n.tr("Replace", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"purge", "cancel"});
        extendedDialog.setContent(string + "\n" + I18n.tr("The new key is already used, overwrite values?", new Object[0]));
        extendedDialog.setCancelButton(2);
        extendedDialog.toggleEnable(string2);
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }

    class AddTagsDialog
    extends AbstractTagsDialog {
        private transient List<JosmAction> recentTagsActions;
        private int commandCount;

        public AddTagsDialog() {
            int n;
            Object object;
            super(Main.parent, I18n.tr("Add value?", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.recentTagsActions = new ArrayList<JosmAction>();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.keys = new AutoCompletingComboBox();
            this.values = new AutoCompletingComboBox();
            jPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>" + I18n.tr("Please select a key", new Object[0])), GBC.eol().fill(2));
            AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
            List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
            AutoCompletionListItem autoCompletionListItem = null;
            Iterator<AutoCompletionListItem> iterator = list.iterator();
            block0: while (iterator.hasNext()) {
                object = iterator.next();
                if (((AutoCompletionListItem)object).getValue().equals(TagEditHelper.this.lastAddKey)) {
                    autoCompletionListItem = object;
                }
                for (n = 0; n < TagEditHelper.this.tagData.getRowCount(); ++n) {
                    if (!((AutoCompletionListItem)object).getValue().equals(TagEditHelper.this.tagData.getValueAt(n, 0))) continue;
                    if (autoCompletionListItem == object) {
                        autoCompletionListItem = null;
                    }
                    iterator.remove();
                    continue block0;
                }
            }
            Collections.sort(list, TagEditHelper.this.defaultACItemComparator);
            this.keys.setPossibleACItems(list);
            this.keys.setEditable(true);
            jPanel.add((Component)this.keys, GBC.eop().fill());
            jPanel.add((Component)new JLabel(I18n.tr("Please select a value", new Object[0])), GBC.eol());
            this.values.setEditable(true);
            jPanel.add((Component)this.values, GBC.eop().fill());
            if (autoCompletionListItem != null) {
                this.keys.setSelectedItem(autoCompletionListItem);
                if (TagEditHelper.this.lastAddValue != null) {
                    this.values.setSelectedItem(TagEditHelper.this.lastAddValue);
                }
            }
            object = this.addFocusAdapter(autoCompletionManager, TagEditHelper.this.defaultACItemComparator);
            ((FocusAdapter)object).focusGained(null);
            n = PROPERTY_RECENT_TAGS_NUMBER.get();
            if (n > 30) {
                n = 30;
            }
            jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 1), "addAndContinue");
            jPanel.getActionMap().put("addAndContinue", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddTagsDialog.this.performTagAdding();
                    AddTagsDialog.this.selectKeysComboBox();
                }
            });
            this.suggestRecentlyAddedTags(jPanel, n, (FocusAdapter)object);
            this.setContent(jPanel, false);
            this.selectKeysComboBox();
            this.popupMenu.add(new AbstractAction(I18n.tr("Set number of recently added tags", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddTagsDialog.this.selectNumberOfTags();
                }
            });
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Remember last used tags after a restart", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                    PROPERTY_REMEMBER_TAGS.put(bl);
                    if (bl) {
                        TagEditHelper.this.saveTagsIfNeeded();
                    }
                }
            });
            jCheckBoxMenuItem.setState(PROPERTY_REMEMBER_TAGS.get());
            this.popupMenu.add(jCheckBoxMenuItem);
        }

        @Override
        public void setContentPane(Container container) {
            String string = "<html>" + Utils.join("<br>", Arrays.asList(I18n.tr("<code>Ctrl-1</code> to apply first suggestion", new Object[0]), I18n.tr("<code>Shift-Enter</code> to add without closing the dialog", new Object[0]), I18n.tr("<code>Shift-Ctrl-1</code> to add first suggestion without closing the dialog", new Object[0])));
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            container.add((Component)jLabel, GBC.eol().fill(2).insets(1, 2, 1, 2));
            super.setContentPane(container);
        }

        private void selectNumberOfTags() {
            String string = JOptionPane.showInputDialog(this, (Object)I18n.tr("Please enter the number of recently added tags to display", new Object[0]));
            if (string == null) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n >= 0 && n <= 30) {
                    PROPERTY_RECENT_TAGS_NUMBER.put(n);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Main.warn(numberFormatException);
            }
            JOptionPane.showMessageDialog(this, I18n.tr("Please enter integer number between 0 and {0}", 30));
        }

        private void suggestRecentlyAddedTags(JPanel jPanel, int n, final FocusAdapter focusAdapter) {
            if (n <= 0 || TagEditHelper.this.recentTags.isEmpty()) {
                return;
            }
            jPanel.add((Component)new JLabel(I18n.tr("Recently added tags", new Object[0])), GBC.eol());
            int n2 = 1;
            LinkedList linkedList = new LinkedList(TagEditHelper.this.recentTags.keySet());
            for (int i = linkedList.size() - 1; i >= 0 && n2 <= n; --i, ++n2) {
                Serializable serializable;
                Object object;
                Cloneable cloneable;
                final Tag tag = (Tag)linkedList.get(i);
                String string = "properties:recent:" + n2;
                String string2 = "properties:recent:shift:" + n2;
                Shortcut shortcut = Shortcut.registerShortcut(string, I18n.tr("Choose recent tag {0}", n2), 48 + n2, 5006);
                final JosmAction josmAction = new JosmAction(string, null, I18n.tr("Use this tag again", new Object[0]), shortcut, false){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddTagsDialog.this.keys.setSelectedItem(tag.getKey());
                        focusAdapter.focusGained(null);
                        AddTagsDialog.this.values.setSelectedItem(tag.getValue());
                        AddTagsDialog.this.selectValuesCombobox();
                    }
                };
                Shortcut shortcut2 = Shortcut.registerShortcut(string2, I18n.tr("Apply recent tag {0}", n2), 48 + n2, 5009);
                JosmAction josmAction2 = new JosmAction(string2, null, I18n.tr("Use this tag again", new Object[0]), shortcut2, false){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        josmAction.actionPerformed(null);
                        AddTagsDialog.this.performTagAdding();
                        AddTagsDialog.this.selectKeysComboBox();
                    }
                };
                this.recentTagsActions.add(josmAction);
                this.recentTagsActions.add(josmAction2);
                this.disableTagIfNeeded(tag, josmAction);
                ImageIcon imageIcon = MapPaintStyles.getNodeIcon(tag, false);
                if (imageIcon == null) {
                    cloneable = new HashMap();
                    cloneable.put(tag.getKey(), tag.getValue());
                    object = TaggingPreset.getMatchingPresets(null, (Map<String, String>)((Object)cloneable), false).iterator();
                    while (object.hasNext() && (imageIcon = ((TaggingPreset)(serializable = object.next())).getIcon()) == null) {
                    }
                    if (imageIcon == null) {
                        imageIcon = new ImageIcon(new BufferedImage(16, 16, 2));
                    }
                }
                cloneable = new GridBagConstraints();
                ((GridBagConstraints)cloneable).ipadx = 5;
                jPanel.add((Component)new JLabel(josmAction.isEnabled() ? imageIcon : GuiHelper.getDisabledIcon(imageIcon)), cloneable);
                object = josmAction.isEnabled() ? "" : "; color:gray";
                serializable = new JLabel("<html><style>td{" + (String)object + "}</style>" + "<table><tr>" + "<td>" + n2 + ".</td>" + "<td style='border:1px solid gray'>" + XmlWriter.encode(tag.toString(), true) + "<" + "/td></tr></table></html>");
                ((JComponent)serializable).setFont(((Component)serializable).getFont().deriveFont(0));
                if (josmAction.isEnabled()) {
                    jPanel.getInputMap(2).put(shortcut.getKeyStroke(), string);
                    jPanel.getActionMap().put(string, josmAction);
                    jPanel.getInputMap(2).put(shortcut2.getKeyStroke(), string2);
                    jPanel.getActionMap().put(string2, josmAction2);
                    ((JComponent)serializable).setToolTipText((String)josmAction.getValue("ShortDescription"));
                    ((Component)serializable).setCursor(Cursor.getPredefinedCursor(12));
                    ((Component)serializable).addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            josmAction.actionPerformed(null);
                            if (mouseEvent.getClickCount() > 1) {
                                AddTagsDialog.this.buttonAction(0, null);
                            }
                            if (mouseEvent.isShiftDown()) {
                                AddTagsDialog.this.performTagAdding();
                                AddTagsDialog.this.selectKeysComboBox();
                            }
                        }
                    });
                } else {
                    ((JComponent)serializable).setEnabled(false);
                    ((JComponent)serializable).setToolTipText(I18n.tr("The key ''{0}'' is already used", tag.getKey()));
                }
                JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
                jPanel2.add((Component)serializable);
                jPanel.add((Component)jPanel2, GBC.eol().fill(2));
            }
        }

        public void destroyActions() {
            for (JosmAction josmAction : this.recentTagsActions) {
                josmAction.destroy();
            }
        }

        public final void performTagAdding() {
            String string = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            String string2 = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if (string.isEmpty() || string2.isEmpty()) {
                return;
            }
            for (OsmPrimitive osmPrimitive : TagEditHelper.this.sel) {
                String string3 = osmPrimitive.get(string);
                if (string3 == null || string3.equals(string2)) continue;
                if (TagEditHelper.this.warnOverwriteKey(I18n.tr("You changed the value of ''{0}'' from ''{1}'' to ''{2}''.", string, string3, string2), "overwriteAddKey")) break;
                return;
            }
            TagEditHelper.this.lastAddKey = string;
            TagEditHelper.this.lastAddValue = string2;
            TagEditHelper.this.recentTags.put(new Tag(string, string2), null);
            AutoCompletionManager.rememberUserInput(string, string2, false);
            ++this.commandCount;
            Main.main.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, string, string2));
            TagEditHelper.this.changedKey = string;
            this.keys.getEditor().setItem("");
            this.values.getEditor().setItem("");
        }

        public void undoAllTagsAdding() {
            Main.main.undoRedo.undo(this.commandCount);
        }

        private void disableTagIfNeeded(Tag tag, JosmAction josmAction) {
            for (int i = 0; i < TagEditHelper.this.tagData.getRowCount(); ++i) {
                if (!tag.getKey().equals(TagEditHelper.this.tagData.getValueAt(i, 0))) continue;
                josmAction.setEnabled(false);
                break;
            }
        }
    }

    abstract class AbstractTagsDialog
    extends ExtendedDialog {
        protected AutoCompletingComboBox keys;
        protected AutoCompletingComboBox values;
        protected Component componentUnderMouse;
        protected JPopupMenu popupMenu;

        public AbstractTagsDialog(Component component, String string, String[] stringArray) {
            super(component, string, stringArray);
            this.popupMenu = new JPopupMenu(){
                private JCheckBoxMenuItem fixTagLanguageCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Use English language for tag by default", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                        PROPERTY_FIX_TAG_LOCALE.put(bl);
                    }
                });
                {
                    this.add(this.fixTagLanguageCb);
                    this.fixTagLanguageCb.setState(PROPERTY_FIX_TAG_LOCALE.get());
                }
            };
            this.addMouseListener(new PopupMenuLauncher(this.popupMenu));
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            Dimension dimension = this.getSize();
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, dimension));
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                Dimension dimension;
                WindowGeometry windowGeometry = this.initWindowGeometry();
                Dimension dimension2 = windowGeometry.getSize();
                if (!dimension2.equals(dimension = this.getSize())) {
                    if (dimension2.width < dimension.width) {
                        dimension2.width = dimension.width;
                    }
                    if (dimension2.height != dimension.height) {
                        dimension2.height = dimension.height;
                    }
                    this.rememberWindowGeometry(windowGeometry);
                }
                this.keys.setFixedLocale(PROPERTY_FIX_TAG_LOCALE.get());
            }
            super.setVisible(bl);
        }

        private void selectACComboBoxSavingUnixBuffer(AutoCompletingComboBox autoCompletingComboBox) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
            if (clipboard != null) {
                Transferable transferable = clipboard.getContents(null);
                autoCompletingComboBox.requestFocusInWindow();
                autoCompletingComboBox.getEditor().selectAll();
                clipboard.setContents(transferable, null);
            } else {
                autoCompletingComboBox.requestFocusInWindow();
                autoCompletingComboBox.getEditor().selectAll();
            }
        }

        public void selectKeysComboBox() {
            this.selectACComboBoxSavingUnixBuffer(this.keys);
        }

        public void selectValuesCombobox() {
            this.selectACComboBoxSavingUnixBuffer(this.values);
        }

        protected FocusAdapter addFocusAdapter(final AutoCompletionManager autoCompletionManager, final Comparator<AutoCompletionListItem> comparator) {
            JTextComponent jTextComponent = (JTextComponent)this.values.getEditor().getEditorComponent();
            FocusAdapter focusAdapter = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    String string = AbstractTagsDialog.this.keys.getEditor().getItem().toString();
                    List<AutoCompletionListItem> list = autoCompletionManager.getValues(TagEditHelper.getAutocompletionKeys(string));
                    Collections.sort(list, comparator);
                    AbstractTagsDialog.this.values.setPossibleACItems(list);
                    AbstractTagsDialog.this.values.getEditor().selectAll();
                    TagEditHelper.this.objKey = string;
                }
            };
            jTextComponent.addFocusListener(focusAdapter);
            return focusAdapter;
        }
    }

    public final class EditTagDialog
    extends AbstractTagsDialog {
        private final String key;
        private final transient Map<String, Integer> m;
        private transient Comparator<AutoCompletionListItem> usedValuesAwareComparator;
        private transient ListCellRenderer<AutoCompletionListItem> cellRenderer;

        private EditTagDialog(String string, Map<String, Integer> map, final boolean bl) {
            super(Main.parent, I18n.trn("Change value?", "Change values?", map.size(), new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.usedValuesAwareComparator = new Comparator<AutoCompletionListItem>(){

                @Override
                public int compare(AutoCompletionListItem autoCompletionListItem, AutoCompletionListItem autoCompletionListItem2) {
                    boolean bl;
                    boolean bl2 = EditTagDialog.this.m.containsKey(autoCompletionListItem.getValue());
                    if (bl2 == (bl = EditTagDialog.this.m.containsKey(autoCompletionListItem2.getValue()))) {
                        return String.CASE_INSENSITIVE_ORDER.compare(autoCompletionListItem.getValue(), autoCompletionListItem2.getValue());
                    }
                    if (bl2) {
                        return -1;
                    }
                    return 1;
                }
            };
            this.cellRenderer = new ListCellRenderer<AutoCompletionListItem>(){
                private final DefaultListCellRenderer def = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends AutoCompletionListItem> jList, AutoCompletionListItem autoCompletionListItem, int n, boolean bl, boolean bl2) {
                    Component component = this.def.getListCellRendererComponent(jList, autoCompletionListItem, n, bl, bl2);
                    if (component instanceof JLabel) {
                        Map map;
                        String string = autoCompletionListItem.getValue();
                        if (TagEditHelper.this.valueCount.containsKey(TagEditHelper.this.objKey) && (map = (Map)TagEditHelper.this.valueCount.get(TagEditHelper.this.objKey)).containsKey(string)) {
                            string = I18n.tr("{0} ({1})", string, map.get(string));
                            component.setFont(component.getFont().deriveFont(3));
                        }
                        ((JLabel)component).setText(string);
                    }
                    return component;
                }
            };
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/EditValue", true);
            this.key = string;
            this.m = map;
            JPanel jPanel = new JPanel(new BorderLayout());
            String string2 = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", string) + ")</html>";
            jPanel.add((Component)new JLabel(string2), "North");
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel.add((Component)jPanel2, "Center");
            AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
            List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
            Collections.sort(list, TagEditHelper.this.defaultACItemComparator);
            this.keys = new AutoCompletingComboBox(string);
            this.keys.setPossibleACItems(list);
            this.keys.setEditable(true);
            this.keys.setSelectedItem(string);
            jPanel2.add(Box.createVerticalStrut(5), GBC.eol());
            jPanel2.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std());
            jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
            jPanel2.add((Component)this.keys, GBC.eol().fill(2));
            List<AutoCompletionListItem> list2 = autoCompletionManager.getValues(TagEditHelper.getAutocompletionKeys(string));
            Collections.sort(list2, this.usedValuesAwareComparator);
            String string3 = this.m.size() != 1 ? I18n.tr("<different>", new Object[0]) : this.m.entrySet().iterator().next().getKey();
            this.values = new AutoCompletingComboBox(string3);
            this.values.setRenderer(this.cellRenderer);
            this.values.setEditable(true);
            this.values.setPossibleACItems(list2);
            this.values.setSelectedItem(string3);
            this.values.getEditor().setItem(string3);
            jPanel2.add(Box.createVerticalStrut(5), GBC.eol());
            jPanel2.add((Component)new JLabel(I18n.tr("Value", new Object[0])), GBC.std());
            jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
            jPanel2.add((Component)this.values, GBC.eol().fill(2));
            this.values.getEditor().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditTagDialog.this.buttonAction(0, null);
                }
            });
            this.addFocusAdapter(autoCompletionManager, this.usedValuesAwareComparator);
            this.setContent(jPanel, false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    if (bl) {
                        EditTagDialog.this.selectKeysComboBox();
                    } else {
                        EditTagDialog.this.selectValuesCombobox();
                    }
                }
            });
        }

        private void performTagEdit() {
            String string = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if ((string = Normalizer.normalize(string, Normalizer.Form.NFC)).isEmpty()) {
                string = null;
            }
            String string2 = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            if ((string2 = Normalizer.normalize(string2, Normalizer.Form.NFC)).isEmpty()) {
                string2 = this.key;
                string = null;
            }
            if (this.key.equals(string2) && I18n.tr("<different>", new Object[0]).equals(string)) {
                return;
            }
            if (this.key.equals(string2) || string == null) {
                Main.main.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, string2, string));
                AutoCompletionManager.rememberUserInput(string2, string, true);
            } else {
                for (Object object : TagEditHelper.this.sel) {
                    if (((AbstractPrimitive)object).get(string2) == null) continue;
                    if (TagEditHelper.this.warnOverwriteKey(I18n.tr("You changed the key from ''{0}'' to ''{1}''.", this.key, string2), "overwriteEditKey")) break;
                    return;
                }
                ArrayList arrayList = new ArrayList();
                arrayList.add(new ChangePropertyCommand(TagEditHelper.this.sel, this.key, null));
                if (string.equals(I18n.tr("<different>", new Object[0]))) {
                    Object object;
                    object = new HashMap();
                    for (OsmPrimitive object2 : TagEditHelper.this.sel) {
                        String string3 = object2.get(this.key);
                        if (string3 == null) continue;
                        if (object.containsKey(string3)) {
                            ((List)object.get(string3)).add(object2);
                            continue;
                        }
                        ArrayList<OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>();
                        arrayList2.add(object2);
                        object.put(string3, arrayList2);
                    }
                    for (Map.Entry entry : object.entrySet()) {
                        arrayList.add(new ChangePropertyCommand((Collection)entry.getValue(), string2, (String)entry.getKey()));
                    }
                } else {
                    arrayList.add(new ChangePropertyCommand(TagEditHelper.this.sel, string2, string));
                    AutoCompletionManager.rememberUserInput(string2, string, false);
                }
                Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()), arrayList));
            }
            TagEditHelper.this.changedKey = string2;
        }
    }
}

